/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.observation.filter;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.nodetype.TypePredicate;
import org.apache.jackrabbit.oak.plugins.observation.filter.ACFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.AddSubtreeFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.ChangeSetFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.ConstantFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.DeleteSubtreeFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.EventAggregator;
import org.apache.jackrabbit.oak.plugins.observation.filter.EventFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.EventTypeFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.FilterConfigMBean;
import org.apache.jackrabbit.oak.plugins.observation.filter.FilterProvider;
import org.apache.jackrabbit.oak.plugins.observation.filter.Filters;
import org.apache.jackrabbit.oak.plugins.observation.filter.GlobbingPathFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.MoveFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.PermissionProviderFactory;
import org.apache.jackrabbit.oak.plugins.observation.filter.PropertyPredicate;
import org.apache.jackrabbit.oak.plugins.observation.filter.UniversalFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.UuidPredicate;
import org.apache.jackrabbit.oak.plugins.tree.factories.RootFactory;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.observation.ChangeSet;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FilterBuilder {
    private static final int ALL_EVENTS = 127;
    private boolean includeSessionLocal;
    private boolean includeClusterExternal;
    private boolean includeClusterLocal = true;
    private final List<String> subTrees = Lists.newArrayList();
    private final Set<String> pathsForMBean = Sets.newHashSet();
    private Condition condition = this.includeAll();
    private ChangeSetFilter changeSetFilter = new ChangeSetFilter(){

        @Override
        public boolean excludes(ChangeSet changeSet) {
            return false;
        }
    };
    private EventAggregator aggregator;

    @NotNull
    public FilterBuilder setChangeSetFilter(@NotNull ChangeSetFilter changeSetFilter) {
        this.changeSetFilter = changeSetFilter;
        return this;
    }

    @NotNull
    public FilterBuilder addSubTree(@NotNull String absPath) {
        if (absPath.endsWith("/")) {
            absPath = absPath.substring(0, absPath.length() - 1);
        }
        for (String path : this.subTrees) {
            if (!path.equals(absPath) && !PathUtils.isAncestor(path, absPath)) continue;
            return this;
        }
        this.subTrees.add((String)Preconditions.checkNotNull((Object)absPath));
        return this;
    }

    public FilterBuilder addPathsForMBean(@NotNull Set<String> paths) {
        this.pathsForMBean.addAll(paths);
        return this;
    }

    @NotNull
    private Iterable<String> getSubTrees() {
        return this.subTrees.isEmpty() ? ImmutableList.of((Object)"/") : this.subTrees;
    }

    public FilterBuilder aggregator(EventAggregator aggregator) {
        this.aggregator = aggregator;
        return this;
    }

    @NotNull
    public FilterBuilder includeSessionLocal(boolean include) {
        this.includeSessionLocal = include;
        return this;
    }

    @NotNull
    public FilterBuilder includeClusterExternal(boolean include) {
        this.includeClusterExternal = include;
        return this;
    }

    @NotNull
    public FilterBuilder includeClusterLocal(boolean include) {
        this.includeClusterLocal = include;
        return this;
    }

    @NotNull
    public FilterBuilder condition(@NotNull Condition condition) {
        this.condition = (Condition)Preconditions.checkNotNull((Object)condition);
        return this;
    }

    @NotNull
    public Condition includeAll() {
        return ConstantCondition.INCLUDE_ALL;
    }

    @NotNull
    public Condition excludeAll() {
        return ConstantCondition.EXCLUDE_ALL;
    }

    @NotNull
    public Condition accessControl(@NotNull PermissionProviderFactory permissionProviderFactory) {
        return new ACCondition((PermissionProviderFactory)Preconditions.checkNotNull((Object)permissionProviderFactory));
    }

    @NotNull
    public Condition path(@NotNull String pathPattern) {
        return new PathCondition((String)Preconditions.checkNotNull((Object)pathPattern));
    }

    @NotNull
    public Condition eventType(int eventTypes) {
        if ((0x7F & eventTypes) == 0) {
            return this.excludeAll();
        }
        if ((0x7F & eventTypes) != 127) {
            return new EventTypeCondition(eventTypes);
        }
        return this.includeAll();
    }

    @NotNull
    public Condition nodeType(@NotNull UniversalFilter.Selector selector, @Nullable String[] ntNames) {
        if (ntNames == null) {
            return this.includeAll();
        }
        if (ntNames.length == 0) {
            return this.excludeAll();
        }
        return new NodeTypeCondition((UniversalFilter.Selector)Preconditions.checkNotNull((Object)selector), ntNames);
    }

    @NotNull
    public Condition uuid(@NotNull UniversalFilter.Selector selector, @Nullable String[] uuids) {
        if (uuids == null) {
            return this.includeAll();
        }
        if (uuids.length == 0) {
            return this.excludeAll();
        }
        return new UniversalCondition((UniversalFilter.Selector)Preconditions.checkNotNull((Object)selector), new UuidPredicate(uuids));
    }

    @NotNull
    public Condition property(@NotNull UniversalFilter.Selector selector, @NotNull String name, @NotNull Predicate<PropertyState> predicate) {
        return new UniversalCondition((UniversalFilter.Selector)Preconditions.checkNotNull((Object)selector), new PropertyPredicate((String)Preconditions.checkNotNull((Object)name), (Predicate<PropertyState>)((Predicate)Preconditions.checkNotNull(predicate))));
    }

    @NotNull
    public Condition universal(@NotNull UniversalFilter.Selector selector, @NotNull Predicate<NodeState> predicate) {
        return new UniversalCondition((UniversalFilter.Selector)Preconditions.checkNotNull((Object)selector), (Predicate<NodeState>)((Predicate)Preconditions.checkNotNull(predicate)));
    }

    @NotNull
    public Condition addSubtree() {
        return new AddSubtreeTreeCondition();
    }

    @NotNull
    public Condition deleteSubtree() {
        return new DeleteSubtreeTreeCondition();
    }

    @NotNull
    public Condition moveSubtree() {
        return new MoveCondition();
    }

    @NotNull
    public Condition any(Condition ... conditions) {
        return new AnyCondition(Lists.newArrayList((Object[])((Object[])Preconditions.checkNotNull((Object)conditions))));
    }

    @NotNull
    public Condition all(Condition ... conditions) {
        return new AllCondition(Lists.newArrayList((Object[])((Object[])Preconditions.checkNotNull((Object)conditions))));
    }

    @NotNull
    public Condition all(@NotNull List<Condition> conditions) {
        return new AllCondition((Iterable)Preconditions.checkNotNull(conditions));
    }

    @NotNull
    public Condition not(@NotNull Condition condition) {
        return new NotCondition((Condition)Preconditions.checkNotNull((Object)condition));
    }

    @NotNull
    public Condition any(@NotNull Iterable<Condition> conditions) {
        return new AnyCondition((Iterable)Preconditions.checkNotNull(conditions));
    }

    @NotNull
    public Condition all(@NotNull Iterable<Condition> conditions) {
        return new AllCondition((Iterable)Preconditions.checkNotNull(conditions));
    }

    @NotNull
    public FilterProvider build() {
        return new FilterProvider(){
            final boolean includeSessionLocal;
            final boolean includeClusterExternal;
            final boolean includeClusterLocal;
            final EventAggregator aggregator;
            final Iterable<String> subTrees;
            final Condition condition;
            final ChangeSetFilter changeSetFilter;
            {
                this.includeSessionLocal = FilterBuilder.this.includeSessionLocal;
                this.includeClusterExternal = FilterBuilder.this.includeClusterExternal;
                this.includeClusterLocal = FilterBuilder.this.includeClusterLocal;
                this.aggregator = FilterBuilder.this.aggregator;
                this.subTrees = FilterBuilder.this.getSubTrees();
                this.condition = FilterBuilder.this.condition;
                this.changeSetFilter = FilterBuilder.this.changeSetFilter;
            }

            public String toString() {
                return super.toString() + " [changeSetFilter=" + this.changeSetFilter + "]";
            }

            @Override
            public boolean includeCommit(@NotNull String sessionId, @Nullable CommitInfo info) {
                return !(!this.includeSessionLocal && this.isLocal((String)Preconditions.checkNotNull((Object)sessionId), info) || !this.includeClusterExternal && this.isExternal(info) || !this.includeClusterLocal && !this.isExternal(info));
            }

            @Override
            @NotNull
            public EventFilter getFilter(@NotNull NodeState before, @NotNull NodeState after) {
                return this.condition.createFilter((NodeState)Preconditions.checkNotNull((Object)before), (NodeState)Preconditions.checkNotNull((Object)after));
            }

            @Override
            @NotNull
            public Iterable<String> getSubTrees() {
                return this.subTrees;
            }

            @Override
            public FilterConfigMBean getConfigMBean() {
                return FilterBuilder.this.getConfigMBean();
            }

            private boolean isLocal(String sessionId, CommitInfo info) {
                return info != null && Objects.equal((Object)info.getSessionId(), (Object)sessionId);
            }

            private boolean isExternal(CommitInfo info) {
                return info.isExternal();
            }

            @Override
            public EventAggregator getEventAggregator() {
                return this.aggregator;
            }

            @Override
            public boolean excludes(ChangeSet changeSet) {
                return this.changeSetFilter.excludes(changeSet);
            }
        };
    }

    @NotNull
    private FilterConfigMBean getConfigMBean() {
        return new FilterConfigMBean(){

            @Override
            public String[] getPaths() {
                return (String[])Iterables.toArray((Iterable)FilterBuilder.this.pathsForMBean, String.class);
            }

            @Override
            public boolean isIncludeClusterLocal() {
                return FilterBuilder.this.includeClusterLocal;
            }

            @Override
            public boolean isIncludeClusterExternal() {
                return FilterBuilder.this.includeClusterExternal;
            }
        };
    }

    private static class NotCondition
    implements Condition {
        private final Condition condition;

        public NotCondition(Condition condition) {
            this.condition = condition;
        }

        @Override
        @NotNull
        public EventFilter createFilter(NodeState before, NodeState after) {
            if (this.condition == ConstantCondition.EXCLUDE_ALL) {
                return ConstantFilter.INCLUDE_ALL;
            }
            if (this.condition == ConstantCondition.INCLUDE_ALL) {
                return ConstantFilter.EXCLUDE_ALL;
            }
            return Filters.not(this.condition.createFilter(before, after));
        }
    }

    private static class AllCondition
    implements Condition {
        private final Iterable<Condition> conditions;

        public AllCondition(Iterable<Condition> conditions) {
            this.conditions = conditions;
        }

        public AllCondition(Condition ... conditions) {
            this(Lists.newArrayList((Object[])conditions));
        }

        @Override
        public EventFilter createFilter(NodeState before, NodeState after) {
            ArrayList filters = Lists.newArrayList();
            for (Condition condition : this.conditions) {
                if (condition == ConstantCondition.EXCLUDE_ALL) {
                    return ConstantFilter.EXCLUDE_ALL;
                }
                if (condition == ConstantCondition.INCLUDE_ALL) continue;
                filters.add(condition.createFilter(before, after));
            }
            return filters.isEmpty() ? ConstantFilter.INCLUDE_ALL : Filters.all(filters);
        }
    }

    private static class AnyCondition
    implements Condition {
        private final Iterable<Condition> conditions;

        public AnyCondition(Iterable<Condition> conditions) {
            this.conditions = conditions;
        }

        public AnyCondition(Condition ... conditions) {
            this(Lists.newArrayList((Object[])conditions));
        }

        @Override
        public EventFilter createFilter(NodeState before, NodeState after) {
            ArrayList filters = Lists.newArrayList();
            for (Condition condition : this.conditions) {
                if (condition == ConstantCondition.INCLUDE_ALL) {
                    return ConstantFilter.INCLUDE_ALL;
                }
                if (condition == ConstantCondition.EXCLUDE_ALL) continue;
                filters.add(condition.createFilter(before, after));
            }
            return filters.isEmpty() ? ConstantFilter.EXCLUDE_ALL : Filters.any(filters);
        }
    }

    protected static class MoveCondition
    implements Condition {
        protected MoveCondition() {
        }

        @Override
        @NotNull
        public EventFilter createFilter(@NotNull NodeState before, @NotNull NodeState after) {
            return new MoveFilter();
        }
    }

    protected static class DeleteSubtreeTreeCondition
    implements Condition {
        protected DeleteSubtreeTreeCondition() {
        }

        @Override
        @NotNull
        public EventFilter createFilter(@NotNull NodeState before, @NotNull NodeState after) {
            return DeleteSubtreeFilter.getInstance();
        }
    }

    protected static class AddSubtreeTreeCondition
    implements Condition {
        protected AddSubtreeTreeCondition() {
        }

        @Override
        @NotNull
        public EventFilter createFilter(@NotNull NodeState before, @NotNull NodeState after) {
            return AddSubtreeFilter.getInstance();
        }
    }

    private static class UniversalCondition
    implements Condition {
        private final UniversalFilter.Selector selector;
        private final Predicate<NodeState> predicate;

        public UniversalCondition(UniversalFilter.Selector selector, Predicate<NodeState> predicate) {
            this.selector = selector;
            this.predicate = predicate;
        }

        @Override
        @NotNull
        public EventFilter createFilter(NodeState before, NodeState after) {
            return new UniversalFilter(before, after, this.selector, this.predicate);
        }
    }

    private static class NodeTypeCondition
    implements Condition {
        private final UniversalFilter.Selector selector;
        private final String[] ntNames;

        public NodeTypeCondition(UniversalFilter.Selector selector, String[] ntNames) {
            this.selector = selector;
            this.ntNames = ntNames;
        }

        @Override
        public EventFilter createFilter(NodeState before, NodeState after) {
            TypePredicate predicate = new TypePredicate(after.exists() ? after : before, this.ntNames);
            return new UniversalFilter(before, after, this.selector, predicate);
        }
    }

    private static class EventTypeCondition
    implements Condition {
        private final int eventTypes;

        public EventTypeCondition(int eventTypes) {
            this.eventTypes = eventTypes;
        }

        @Override
        public EventFilter createFilter(NodeState before, NodeState after) {
            return new EventTypeFilter(this.eventTypes);
        }
    }

    private static class PathCondition
    implements Condition {
        private final String pathGlob;
        private final Map<String, Pattern> patternMap = new HashMap<String, Pattern>();

        public PathCondition(String pathGlob) {
            this.pathGlob = pathGlob;
        }

        @Override
        public EventFilter createFilter(NodeState before, NodeState after) {
            return new GlobbingPathFilter(this.pathGlob, this.patternMap);
        }
    }

    private static class ACCondition
    implements Condition {
        private final PermissionProviderFactory permissionProviderFactory;

        public ACCondition(PermissionProviderFactory permissionProviderFactory) {
            this.permissionProviderFactory = permissionProviderFactory;
        }

        @Override
        public EventFilter createFilter(NodeState before, NodeState after) {
            return new ACFilter(before, after, this.permissionProviderFactory.create(RootFactory.createReadOnlyRoot(after)));
        }
    }

    private static class ConstantCondition
    implements Condition {
        public static final ConstantCondition INCLUDE_ALL = new ConstantCondition(true);
        public static final ConstantCondition EXCLUDE_ALL = new ConstantCondition(false);
        private final boolean value;

        public ConstantCondition(boolean value) {
            this.value = value;
        }

        @Override
        public EventFilter createFilter(NodeState before, NodeState after) {
            return this.value ? Filters.includeAll() : Filters.excludeAll();
        }
    }

    public static interface Condition {
        @NotNull
        public EventFilter createFilter(@NotNull NodeState var1, @NotNull NodeState var2);
    }
}

