/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.index;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.query.ast.Operator;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.QueryLimits;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextExpression;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilterImpl
implements Filter {
    private final SelectorImpl selector;
    private final String queryStatement;
    private final QueryLimits settings;
    private boolean alwaysFalse;
    private boolean matchesAllTypes;
    private String path = "/";
    private Filter.PathRestriction pathRestriction = Filter.PathRestriction.NO_RESTRICTION;
    private String pathPlan;
    private final ArrayList<String> fulltextConditions = new ArrayList();
    private FullTextExpression fullTextConstraint;
    private final ListMultimap<String, Filter.PropertyRestriction> propertyRestrictions = ArrayListMultimap.create();
    private boolean distinct;
    private boolean preparing;

    public static FilterImpl newTestInstance() {
        return new FilterImpl();
    }

    private FilterImpl() {
        this(null, null, new QueryLimits(){

            @Override
            public long getLimitInMemory() {
                return Long.MAX_VALUE;
            }

            @Override
            public long getLimitReads() {
                return Long.MAX_VALUE;
            }

            @Override
            public boolean getFullTextComparisonWithoutIndex() {
                return false;
            }

            @Override
            public boolean getFailTraversal() {
                return false;
            }
        });
    }

    public FilterImpl(SelectorImpl selector, String queryStatement, QueryLimits settings) {
        this.selector = selector;
        this.queryStatement = queryStatement;
        this.matchesAllTypes = selector != null ? selector.matchesAllTypes() : false;
        this.settings = settings;
    }

    public FilterImpl(Filter filter) {
        FilterImpl impl = (FilterImpl)filter;
        this.alwaysFalse = impl.alwaysFalse;
        this.distinct = impl.distinct;
        this.fullTextConstraint = impl.fullTextConstraint;
        this.matchesAllTypes = impl.matchesAllTypes;
        this.path = impl.path;
        this.pathRestriction = impl.pathRestriction;
        this.propertyRestrictions.putAll(impl.propertyRestrictions);
        this.queryStatement = impl.queryStatement;
        this.selector = impl.selector;
        this.matchesAllTypes = this.selector != null ? this.selector.matchesAllTypes() : false;
        this.settings = filter.getQueryLimits();
    }

    public void setPreparing(boolean preparing) {
        this.preparing = preparing;
    }

    public boolean isPreparing() {
        return this.preparing;
    }

    public boolean isPrepared(SelectorImpl selector) {
        return selector.isPrepared();
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Filter.PathRestriction getPathRestriction() {
        return this.pathRestriction;
    }

    @Override
    public String getPathPlan() {
        StringBuilder buff = new StringBuilder();
        String p = this.path;
        if (PathUtils.denotesRoot(this.path)) {
            p = "";
        }
        buff.append(p).append((Object)this.pathRestriction);
        if (this.pathPlan != null) {
            buff.append(" && ").append(this.pathPlan);
        }
        return buff.toString();
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public void setAlwaysFalse() {
        this.propertyRestrictions.clear();
        this.path = "/";
        this.pathRestriction = Filter.PathRestriction.EXACT;
        this.alwaysFalse = true;
    }

    @Override
    public boolean isAlwaysFalse() {
        return this.alwaysFalse;
    }

    public SelectorImpl getSelector() {
        return this.selector;
    }

    @Override
    @Nullable
    public String getNodeType() {
        if (this.selector == null) {
            return null;
        }
        return this.selector.getNodeType();
    }

    @Override
    public boolean matchesAllTypes() {
        return this.matchesAllTypes;
    }

    @Override
    @NotNull
    public Set<String> getSupertypes() {
        if (this.selector == null) {
            return Collections.emptySet();
        }
        return this.selector.getSupertypes();
    }

    @Override
    @NotNull
    public Set<String> getPrimaryTypes() {
        if (this.selector == null) {
            return Collections.emptySet();
        }
        return this.selector.getPrimaryTypes();
    }

    @Override
    @NotNull
    public Set<String> getMixinTypes() {
        if (this.selector == null) {
            return Collections.emptySet();
        }
        return this.selector.getMixinTypes();
    }

    @Override
    public Collection<Filter.PropertyRestriction> getPropertyRestrictions() {
        return this.propertyRestrictions.values();
    }

    @Override
    public Filter.PropertyRestriction getPropertyRestriction(String propertyName) {
        List list = this.propertyRestrictions.get((Object)propertyName);
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return (Filter.PropertyRestriction)list.get(0);
        }
        int bestSort = -1;
        Filter.PropertyRestriction best = null;
        for (Filter.PropertyRestriction x : list) {
            int sort = x.sortOrder();
            if (sort <= bestSort) continue;
            bestSort = sort;
            best = x;
        }
        return best;
    }

    public boolean testPath(String path) {
        if (this.isAlwaysFalse()) {
            return false;
        }
        switch (this.pathRestriction) {
            case NO_RESTRICTION: {
                return true;
            }
            case EXACT: {
                return path.matches(this.path);
            }
            case PARENT: {
                return PathUtils.getParentPath(this.path).equals(path);
            }
            case DIRECT_CHILDREN: {
                return PathUtils.getParentPath(path).equals(this.path);
            }
            case ALL_CHILDREN: {
                return PathUtils.isAncestor(this.path, path);
            }
        }
        throw new IllegalArgumentException("Unknown path restriction: " + (Object)((Object)this.pathRestriction));
    }

    public void restrictPropertyAsList(String propertyName, List<PropertyValue> list) {
        Filter.PropertyRestriction x = new Filter.PropertyRestriction();
        x.propertyName = propertyName;
        x.list = list;
        this.addRestriction(x);
    }

    public void restrictProperty(String propertyName, Operator op, PropertyValue v) {
        this.restrictProperty(propertyName, op, v, 0);
    }

    public void restrictProperty(String propertyName, Operator op, PropertyValue v, int propertyType) {
        Filter.PropertyRestriction x = new Filter.PropertyRestriction();
        x.propertyName = propertyName;
        x.propertyType = propertyType;
        switch (op) {
            case EQUAL: {
                x.first = x.last = v;
                x.lastIncluding = true;
                x.firstIncluding = true;
                break;
            }
            case NOT_EQUAL: {
                if (v == null) break;
                throw new IllegalArgumentException("NOT_EQUAL only supported for NOT_EQUAL NULL");
            }
            case GREATER_THAN: {
                x.first = v;
                x.firstIncluding = false;
                break;
            }
            case GREATER_OR_EQUAL: {
                x.first = v;
                x.firstIncluding = true;
                break;
            }
            case LESS_THAN: {
                x.last = v;
                x.lastIncluding = false;
                break;
            }
            case LESS_OR_EQUAL: {
                x.last = v;
                x.lastIncluding = true;
                break;
            }
            case LIKE: {
                x.isLike = true;
                x.first = v;
            }
        }
        this.addRestriction(x);
    }

    private void addRestriction(Filter.PropertyRestriction restriction) {
        List<Filter.PropertyRestriction> list = this.getPropertyRestrictions(restriction.propertyName);
        for (Filter.PropertyRestriction old : list) {
            if (!old.equals(restriction)) continue;
            return;
        }
        list.add(restriction);
    }

    @Override
    public List<Filter.PropertyRestriction> getPropertyRestrictions(String propertyName) {
        return this.propertyRestrictions.get((Object)propertyName);
    }

    static PropertyValue maxValue(PropertyValue a, PropertyValue b) {
        if (a == null) {
            return b;
        }
        return a.compareTo(b) < 0 ? b : a;
    }

    static PropertyValue minValue(PropertyValue a, PropertyValue b) {
        if (a == null) {
            return b;
        }
        return a.compareTo(b) <= 0 ? a : b;
    }

    public String toString() {
        if (this.alwaysFalse) {
            return "Filter(always false)";
        }
        StringBuilder buff = new StringBuilder();
        buff.append("Filter(");
        if (this.queryStatement != null) {
            buff.append("query=").append(this.queryStatement);
        }
        if (this.fullTextConstraint != null) {
            buff.append(" fullText=").append(this.fullTextConstraint);
        }
        buff.append(", path=").append(this.getPathPlan());
        if (!this.propertyRestrictions.isEmpty()) {
            buff.append(", property=[");
            Iterator iterator = new TreeMap(this.propertyRestrictions.asMap()).entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry p = iterator.next();
                buff.append((String)p.getKey()).append("=").append(p.getValue());
                if (!iterator.hasNext()) continue;
                buff.append(", ");
            }
            buff.append("]");
        }
        buff.append(")");
        return buff.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void restrictPath(String addedPath, Filter.PathRestriction addedPathRestriction) {
        block39: {
            if (addedPath == null) {
                addedPath = "/";
            }
            if (addedPath.startsWith("//")) {
                this.pathPlan = this.pathPlan == null ? "" : this.pathPlan + " && ";
                this.pathPlan = this.pathPlan + addedPath + (Object)((Object)addedPathRestriction);
                return;
            }
            block0 : switch (addedPathRestriction) {
                case NO_RESTRICTION: {
                    return;
                }
                case PARENT: {
                    switch (this.pathRestriction) {
                        case NO_RESTRICTION: {
                            break;
                        }
                        case PARENT: {
                            break;
                        }
                        case EXACT: 
                        case DIRECT_CHILDREN: 
                        case ALL_CHILDREN: {
                            if (PathUtils.isAncestor(this.path, addedPath)) break;
                            this.setAlwaysFalse();
                        }
                    }
                    this.pathRestriction = Filter.PathRestriction.PARENT;
                    this.path = addedPath;
                    return;
                }
                case EXACT: {
                    switch (this.pathRestriction) {
                        case NO_RESTRICTION: {
                            break;
                        }
                        case PARENT: {
                            if (PathUtils.isAncestor(addedPath, this.path)) break;
                            this.setAlwaysFalse();
                            break;
                        }
                        case EXACT: {
                            if (addedPath.equals(this.path)) break;
                            this.setAlwaysFalse();
                            break;
                        }
                        case ALL_CHILDREN: {
                            if (PathUtils.isAncestor(this.path, addedPath)) break;
                            this.setAlwaysFalse();
                            break;
                        }
                        case DIRECT_CHILDREN: {
                            if (PathUtils.getParentPath(addedPath).equals(this.path)) break;
                            this.setAlwaysFalse();
                        }
                    }
                    this.path = addedPath;
                    this.pathRestriction = Filter.PathRestriction.EXACT;
                    return;
                }
                case ALL_CHILDREN: {
                    switch (this.pathRestriction) {
                        case NO_RESTRICTION: {
                            this.path = addedPath;
                            this.pathRestriction = Filter.PathRestriction.ALL_CHILDREN;
                            return;
                        }
                        case EXACT: 
                        case PARENT: {
                            if (PathUtils.isAncestor(addedPath, this.path)) break;
                            this.setAlwaysFalse();
                            return;
                        }
                        case ALL_CHILDREN: {
                            if (PathUtils.isAncestor(this.path, addedPath)) {
                                this.path = addedPath;
                                return;
                            }
                            if (this.path.equals(addedPath) || PathUtils.isAncestor(addedPath, this.path)) break;
                            this.setAlwaysFalse();
                            return;
                        }
                        case DIRECT_CHILDREN: {
                            if (this.path.equals(addedPath) || PathUtils.isAncestor(addedPath, this.path)) break;
                            this.setAlwaysFalse();
                        }
                    }
                    return;
                }
                case DIRECT_CHILDREN: {
                    switch (this.pathRestriction) {
                        case NO_RESTRICTION: {
                            this.path = addedPath;
                            this.pathRestriction = Filter.PathRestriction.DIRECT_CHILDREN;
                            break block0;
                        }
                        case PARENT: {
                            if (PathUtils.isAncestor(addedPath, this.path)) return;
                            this.setAlwaysFalse();
                            break block39;
                        }
                        case EXACT: {
                            if (PathUtils.getParentPath(this.path).equals(addedPath)) return;
                            this.setAlwaysFalse();
                            break block39;
                        }
                        case ALL_CHILDREN: {
                            if (!this.path.equals(addedPath) && !PathUtils.isAncestor(this.path, addedPath)) {
                                this.setAlwaysFalse();
                                break block0;
                            }
                            this.path = addedPath;
                            this.pathRestriction = Filter.PathRestriction.DIRECT_CHILDREN;
                            break block0;
                        }
                        case DIRECT_CHILDREN: {
                            if (this.path.equals(addedPath)) return;
                            this.setAlwaysFalse();
                        }
                    }
                }
            }
        }
    }

    public List<String> getFulltextConditions() {
        return this.fulltextConditions;
    }

    public void restrictFulltextCondition(String condition) {
        this.fulltextConditions.add(condition);
    }

    public void setFullTextConstraint(FullTextExpression constraint) {
        this.fullTextConstraint = constraint;
    }

    @Override
    public FullTextExpression getFullTextConstraint() {
        return this.fullTextConstraint;
    }

    @Override
    public boolean containsNativeConstraint() {
        for (String p : this.propertyRestrictions.keySet()) {
            if (!p.startsWith("native*")) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public String getQueryStatement() {
        return this.queryStatement;
    }

    public void setMatchesAllTypes(boolean matchesAllTypes) {
        this.matchesAllTypes = matchesAllTypes;
    }

    @Override
    public QueryLimits getQueryLimits() {
        return this.settings;
    }

    @Override
    public boolean isAccessible(String path) {
        PermissionProvider permissionProvider = this.selector.getQuery().getExecutionContext().getPermissionProvider();
        return permissionProvider != null && permissionProvider.isGranted(path, "read");
    }
}

