/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication.token;

import java.io.IOException;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import javax.jcr.Credentials;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.apache.jackrabbit.api.security.authentication.token.TokenCredentials;
import org.apache.jackrabbit.oak.api.AuthInfo;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.security.authentication.token.TokenAuthentication;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.AbstractLoginModule;
import org.apache.jackrabbit.oak.spi.security.authentication.AuthInfoImpl;
import org.apache.jackrabbit.oak.spi.security.authentication.callback.TokenProviderCallback;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenConfiguration;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenInfo;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TokenLoginModule
extends AbstractLoginModule {
    private static final Logger log = LoggerFactory.getLogger(TokenLoginModule.class);
    private TokenProvider tokenProvider;
    private TokenCredentials tokenCredentials;
    private TokenInfo tokenInfo;
    private Principal principal;

    @Override
    public boolean login() throws LoginException {
        TokenCredentials tc;
        TokenAuthentication authentication;
        this.tokenProvider = this.getTokenProvider();
        if (this.tokenProvider == null) {
            return false;
        }
        Credentials credentials = this.getCredentials();
        if (credentials instanceof TokenCredentials && (authentication = new TokenAuthentication(this.tokenProvider)).authenticate((Credentials)(tc = (TokenCredentials)credentials))) {
            this.tokenCredentials = tc;
            this.tokenInfo = authentication.getTokenInfo();
            this.principal = authentication.getUserPrincipal();
            log.debug("Login: adding login name to shared state.");
            this.sharedState.put("javax.security.auth.login.name", this.tokenInfo.getUserId());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commit() throws LoginException {
        block6: {
            if (this.tokenCredentials != null && this.tokenInfo != null) {
                Set<? extends Principal> principals = this.principal != null ? this.getPrincipals(this.principal) : this.getPrincipals(this.tokenInfo.getUserId());
                this.updateSubject(this.tokenCredentials, TokenLoginModule.getAuthInfo(this.tokenInfo, principals), principals);
                this.clearState();
                return true;
            }
            try {
                TokenInfo ti;
                Credentials shared;
                if (this.tokenProvider == null || !this.sharedState.containsKey("org.apache.jackrabbit.credentials") || (shared = this.getSharedCredentials()) == null || !this.tokenProvider.doCreateToken(shared)) break block6;
                Root r = this.getRoot();
                if (r != null) {
                    r.refresh();
                }
                if ((ti = this.tokenProvider.createToken(shared)) != null) {
                    TokenCredentials tc = new TokenCredentials(ti.getToken());
                    ti.getPrivateAttributes().forEach((key, value) -> tc.setAttribute(key, value));
                    ti.getPublicAttributes().forEach((key, value) -> tc.setAttribute(key, value));
                    this.sharedState.put("javax.security.auth.login.attributes", ti.getPublicAttributes());
                    this.updateSubject(tc, null, null);
                    break block6;
                }
                this.onError();
                Object logId = this.sharedState.get("javax.security.auth.login.name");
                log.error("TokenProvider failed to create a login token for user {}", logId);
                throw new LoginException("Failed to create login token for user " + logId);
            }
            finally {
                this.clearState();
            }
        }
        return false;
    }

    @Override
    @NotNull
    protected Set<Class> getSupportedCredentials() {
        return Collections.singleton(TokenCredentials.class);
    }

    @Override
    protected void clearState() {
        super.clearState();
        this.tokenCredentials = null;
        this.tokenInfo = null;
        this.tokenProvider = null;
    }

    @Nullable
    private TokenProvider getTokenProvider() {
        TokenProvider provider = null;
        SecurityProvider securityProvider = this.getSecurityProvider();
        Root root = this.getRoot();
        if (root != null && securityProvider != null) {
            TokenConfiguration tokenConfig = securityProvider.getConfiguration(TokenConfiguration.class);
            provider = tokenConfig.getTokenProvider(root);
        }
        if (provider == null && this.callbackHandler != null) {
            try {
                TokenProviderCallback tcCallback = new TokenProviderCallback();
                this.callbackHandler.handle(new Callback[]{tcCallback});
                provider = tcCallback.getTokenProvider();
            }
            catch (IOException | UnsupportedCallbackException e) {
                this.onError();
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return provider;
    }

    @NotNull
    private static AuthInfo getAuthInfo(@NotNull TokenInfo tokenInfo, @NotNull Set<? extends Principal> principals) {
        HashMap attributes = new HashMap();
        tokenInfo.getPublicAttributes().forEach((key, value) -> attributes.put(key, value));
        return new AuthInfoImpl(tokenInfo.getUserId(), attributes, principals);
    }

    private void updateSubject(@NotNull TokenCredentials tc, @Nullable AuthInfo authInfo, @Nullable Set<? extends Principal> principals) {
        if (!this.subject.isReadOnly()) {
            this.subject.getPublicCredentials().add(tc);
            if (principals != null) {
                this.subject.getPrincipals().addAll(principals);
            }
            if (authInfo != null) {
                TokenLoginModule.setAuthInfo(authInfo, this.subject);
            }
        }
    }
}

