/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.accesscontrol;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.security.Principal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.NamedAccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.api.security.principal.ItemBasedPrincipal;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.commons.iterator.AccessControlPolicyIteratorAdapter;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.QueryEngine;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.api.ResultRow;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.memory.PropertyBuilder;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.security.authorization.accesscontrol.ACL;
import org.apache.jackrabbit.oak.security.authorization.accesscontrol.PolicyComparator;
import org.apache.jackrabbit.oak.security.authorization.accesscontrol.Util;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionUtil;
import org.apache.jackrabbit.oak.security.authorization.restriction.PrincipalRestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.ACE;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AbstractAccessControlManager;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.ImmutableACL;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.PolicyOwner;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.Restriction;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessControlManagerImpl
extends AbstractAccessControlManager
implements PolicyOwner {
    private static final Logger log = LoggerFactory.getLogger(AccessControlManagerImpl.class);
    private final PrivilegeBitsProvider bitsProvider;
    private final ReadOnlyNodeTypeManager ntMgr;
    private final PrincipalManager principalManager;
    private final RestrictionProvider restrictionProvider;
    private final ConfigurationParameters configParams;
    private final Set<String> readPaths;

    public AccessControlManagerImpl(@NotNull Root root, @NotNull NamePathMapper namePathMapper, @NotNull SecurityProvider securityProvider) {
        super(root, namePathMapper, securityProvider);
        this.bitsProvider = new PrivilegeBitsProvider(root);
        this.ntMgr = ReadOnlyNodeTypeManager.getInstance(root, namePathMapper);
        this.principalManager = securityProvider.getConfiguration(PrincipalConfiguration.class).getPrincipalManager(root, namePathMapper);
        this.restrictionProvider = this.getConfig().getRestrictionProvider();
        this.configParams = this.getConfig().getParameters();
        this.readPaths = this.configParams.getConfigValue("readPaths", PermissionConstants.DEFAULT_READ_PATHS);
    }

    @NotNull
    public AccessControlPolicy[] getPolicies(@Nullable String absPath) throws RepositoryException {
        String oakPath = this.getOakPath(absPath);
        Tree tree = this.getTree(oakPath, 128L, true);
        JackrabbitAccessControlList policy = this.createACL(oakPath, tree, false, (Predicate<Tree>)Predicates.alwaysTrue());
        ArrayList<Object> policies = new ArrayList<Object>(2);
        if (policy != null) {
            policies.add(policy);
        }
        if (this.readPaths.contains(oakPath)) {
            policies.add(ReadPolicy.INSTANCE);
        }
        return policies.toArray(new AccessControlPolicy[0]);
    }

    @NotNull
    public AccessControlPolicy[] getEffectivePolicies(@Nullable String absPath) throws RepositoryException {
        String oakPath = this.getOakPath(absPath);
        Tree tree = this.getTree(oakPath, 128L, true);
        Root r = this.getRoot().getContentSession().getLatestRoot();
        tree = r.getTree(tree.getPath());
        ArrayList<Object> effective = new ArrayList<Object>();
        JackrabbitAccessControlList policy = this.createACL(oakPath, tree, true, (Predicate<Tree>)Predicates.alwaysTrue());
        if (policy != null) {
            effective.add(policy);
        }
        if (oakPath != null) {
            String parentPath = Text.getRelativeParent(oakPath, 1);
            while (!parentPath.isEmpty()) {
                Tree t = r.getTree(parentPath);
                JackrabbitAccessControlList plc = this.createACL(parentPath, t, true, (Predicate<Tree>)Predicates.alwaysTrue());
                if (plc != null) {
                    effective.add(plc);
                }
                parentPath = PathUtils.denotesRoot(parentPath) ? "" : Text.getRelativeParent(parentPath, 1);
            }
        }
        if (this.readPaths.contains(oakPath)) {
            effective.add(ReadPolicy.INSTANCE);
        }
        return effective.toArray(new AccessControlPolicy[0]);
    }

    @NotNull
    public AccessControlPolicyIterator getApplicablePolicies(@Nullable String absPath) throws RepositoryException {
        String oakPath = this.getOakPath(absPath);
        Tree tree = this.getTree(oakPath, 128L, true);
        NodeACL policy = null;
        Tree aclTree = this.getAclTree(oakPath, tree);
        if (aclTree == null) {
            if (tree.hasChild(Util.getAclName(oakPath))) {
                log.warn("Colliding policy child without node being access controllable ({}).", (Object)absPath);
            } else {
                String mixinName = Util.getMixinName(oakPath);
                if (this.ntMgr.isNodeType(tree, mixinName) || this.ntMgr.getEffectiveNodeType(tree).supportsMixin(mixinName)) {
                    policy = new NodeACL(oakPath);
                } else {
                    log.warn("Node {} cannot be made access controllable.", (Object)absPath);
                }
            }
        }
        if (policy == null) {
            return AccessControlPolicyIteratorAdapter.EMPTY;
        }
        return new AccessControlPolicyIteratorAdapter(Collections.singleton(policy));
    }

    public void setPolicy(@Nullable String absPath, @NotNull AccessControlPolicy policy) throws RepositoryException {
        String oakPath = this.getOakPath(absPath);
        Util.checkValidPolicy(oakPath, policy);
        if (policy instanceof PrincipalACL) {
            this.setPrincipalBasedAcl((PrincipalACL)policy);
        } else {
            Tree tree = this.getTree(oakPath, 256L, true);
            this.setNodeBasedAcl(oakPath, tree, (ACL)policy);
        }
    }

    private void setPrincipalBasedAcl(PrincipalACL principalAcl) throws RepositoryException {
        ACL acl;
        Tree tree;
        String path;
        JackrabbitAccessControlPolicy[] plcs = this.getPolicies(principalAcl.principal);
        PrincipalACL existing = plcs.length == 0 ? null : (PrincipalACL)plcs[0];
        ArrayList toAdd = Lists.newArrayList(principalAcl.getEntries());
        List<Object> toRemove = Collections.emptyList();
        if (existing != null) {
            toAdd.removeAll(existing.getEntries());
            toRemove = existing.getEntries();
            toRemove.removeAll(principalAcl.getEntries());
        }
        for (ACE aCE : toAdd) {
            path = this.getNodePath(aCE);
            acl = (ACL)this.createACL(path, tree = this.getTree(path, 256L, true), false, (Predicate<Tree>)Predicates.alwaysTrue());
            if (acl == null) {
                acl = new NodeACL(path);
            }
            HashMap<String, Value> restrictions = new HashMap<String, Value>();
            HashMap<String, Value[]> mvRestrictions = new HashMap<String, Value[]>();
            for (Restriction r2 : aCE.getRestrictions()) {
                String name = r2.getDefinition().getName();
                if ("rep:nodePath".equals(name)) continue;
                if (r2.getDefinition().getRequiredType().isArray()) {
                    mvRestrictions.put(name, aCE.getRestrictions(name));
                    continue;
                }
                restrictions.put(name, aCE.getRestriction(name));
            }
            acl.addEntry(aCE.getPrincipal(), aCE.getPrivileges(), aCE.isAllow(), restrictions, mvRestrictions);
            this.setNodeBasedAcl(path, tree, acl);
        }
        for (ACE aCE : toRemove) {
            path = this.getNodePath(aCE);
            acl = (ACL)this.createACL(path, tree = this.getTree(path, 256L, true), false, (Predicate<Tree>)Predicates.alwaysTrue());
            if (acl != null) {
                HashSet rstr = Sets.newHashSet(aCE.getRestrictions());
                rstr.removeIf(r -> "rep:nodePath".equals(r.getDefinition().getName()));
                acl.removeAccessControlEntry((AccessControlEntry)new Entry(aCE.getPrincipal(), aCE.getPrivilegeBits(), aCE.isAllow(), rstr, this.getNamePathMapper()));
                this.setNodeBasedAcl(path, tree, acl);
                continue;
            }
            log.debug("Missing ACL at {}; cannot remove entry {}", (Object)path, (Object)aCE);
        }
    }

    private void setNodeBasedAcl(@Nullable String oakPath, @NotNull Tree tree, @NotNull ACL acl) throws RepositoryException {
        Tree aclTree = this.getAclTree(oakPath, tree);
        if (aclTree != null) {
            for (Tree aceTree : aclTree.getChildren()) {
                aceTree.remove();
            }
        } else {
            aclTree = this.createAclTree(oakPath, tree);
        }
        aclTree.setOrderableChildren(true);
        List<ACE> entries = acl.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            ACE ace = entries.get(i);
            String nodeName = Util.generateAceName(ace, i);
            String ntName = ace.isAllow() ? "rep:GrantACE" : "rep:DenyACE";
            Tree aceNode = TreeUtil.addChild(aclTree, nodeName, ntName);
            aceNode.setProperty("rep:principalName", ace.getPrincipal().getName());
            aceNode.setProperty("rep:privileges", this.bitsProvider.getPrivilegeNames(ace.getPrivilegeBits()), Type.NAMES);
            Set<Restriction> restrictions = ace.getRestrictions();
            this.restrictionProvider.writeRestrictions(oakPath, aceNode, restrictions);
        }
    }

    public void removePolicy(@Nullable String absPath, @NotNull AccessControlPolicy policy) throws RepositoryException {
        String oakPath = this.getOakPath(absPath);
        Util.checkValidPolicy(oakPath, policy);
        HashMap<String, Principal> principalMap = new HashMap<String, Principal>();
        if (policy instanceof PrincipalACL) {
            PrincipalACL principalAcl = (PrincipalACL)policy;
            for (ACE ace : principalAcl.getEntries()) {
                Tree tree;
                String path = this.getNodePath(ace);
                Tree aclTree = this.getAclTree(path, tree = this.getTree(path, 256L, true));
                if (aclTree == null) {
                    throw new AccessControlException("Unable to retrieve policy node at " + path);
                }
                for (Tree child : aclTree.getChildren()) {
                    if (!ace.equals(this.createACE(path, child, principalAcl.rProvider, principalMap))) continue;
                    child.remove();
                }
                if (aclTree.getChildren().iterator().hasNext()) continue;
                aclTree.remove();
            }
        } else {
            Tree tree = this.getTree(oakPath, 256L, true);
            Tree aclTree = this.getAclTree(oakPath, tree);
            if (aclTree != null) {
                aclTree.remove();
            } else {
                throw new AccessControlException("No policy to remove at " + absPath);
            }
        }
    }

    @NotNull
    public JackrabbitAccessControlPolicy[] getApplicablePolicies(@NotNull Principal principal) throws RepositoryException {
        Util.checkValidPrincipal(principal, this.principalManager);
        String oakPath = principal instanceof ItemBasedPrincipal ? ((ItemBasedPrincipal)principal).getPath() : null;
        JackrabbitAccessControlList policy = this.createPrincipalACL(oakPath, principal);
        if (policy != null) {
            return new JackrabbitAccessControlPolicy[0];
        }
        return new JackrabbitAccessControlPolicy[]{new PrincipalACL(oakPath, principal)};
    }

    @NotNull
    public JackrabbitAccessControlPolicy[] getPolicies(@NotNull Principal principal) throws RepositoryException {
        Util.checkValidPrincipal(principal, this.principalManager);
        String oakPath = principal instanceof ItemBasedPrincipal ? ((ItemBasedPrincipal)principal).getPath() : null;
        JackrabbitAccessControlList policy = this.createPrincipalACL(oakPath, principal);
        if (policy != null) {
            return new JackrabbitAccessControlPolicy[]{policy};
        }
        return new JackrabbitAccessControlPolicy[0];
    }

    @NotNull
    public AccessControlPolicy[] getEffectivePolicies(@NotNull Set<Principal> principals) throws RepositoryException {
        Util.checkValidPrincipals(principals, this.principalManager);
        Root r = this.getLatestRoot();
        Result aceResult = AccessControlManagerImpl.searchAces(principals, r);
        TreeSet effective = Sets.newTreeSet((Comparator)new PolicyComparator());
        HashSet paths = Sets.newHashSet();
        PrincipalPredicate predicate = new PrincipalPredicate(principals);
        for (ResultRow resultRow : aceResult.getRows()) {
            JackrabbitAccessControlList policy;
            String acePath = resultRow.getPath();
            String aclName = Text.getName(Text.getRelativeParent(acePath, 1));
            Tree accessControlledTree = r.getTree(Text.getRelativeParent(acePath, 2));
            if (!POLICY_NODE_NAMES.contains(aclName) || !accessControlledTree.exists()) {
                log.debug("Isolated access control entry -> ignore query result at {}", (Object)acePath);
                continue;
            }
            String path = "rep:repoPolicy".equals(aclName) ? null : accessControlledTree.getPath();
            if (paths.contains(path) || (policy = this.createACL(path, accessControlledTree, true, predicate)) == null) continue;
            effective.add(policy);
            paths.add(path);
        }
        return effective.toArray(new AccessControlPolicy[0]);
    }

    @Override
    public boolean defines(String absPath, @NotNull AccessControlPolicy accessControlPolicy) {
        try {
            return Util.isValidPolicy(this.getOakPath(absPath), accessControlPolicy);
        }
        catch (RepositoryException e) {
            log.warn("Invalid absolute path '{}': {}", (Object)absPath, (Object)e.getMessage());
            return false;
        }
    }

    @Nullable
    private Tree getAclTree(@Nullable String oakPath, @NotNull Tree accessControlledTree) {
        String aclName;
        Tree policyTree;
        if (Util.isAccessControlled(oakPath, accessControlledTree, this.ntMgr) && (policyTree = accessControlledTree.getChild(aclName = Util.getAclName(oakPath))).exists()) {
            return policyTree;
        }
        return null;
    }

    @NotNull
    private Tree createAclTree(@Nullable String oakPath, @NotNull Tree tree) throws AccessDeniedException {
        if (!Util.isAccessControlled(oakPath, tree, this.ntMgr)) {
            PropertyState mixins = tree.getProperty("jcr:mixinTypes");
            String mixinName = Util.getMixinName(oakPath);
            if (mixins == null) {
                tree.setProperty("jcr:mixinTypes", Collections.singleton(mixinName), Type.NAMES);
            } else {
                PropertyBuilder<String> pb = PropertyBuilder.copy(Type.NAME, mixins);
                pb.addValue(mixinName);
                tree.setProperty(pb.getPropertyState());
            }
        }
        String aclName = Util.getAclName(oakPath);
        return TreeUtil.addChild(tree, aclName, "rep:ACL");
    }

    @Nullable
    private JackrabbitAccessControlList createACL(@Nullable String oakPath, @NotNull Tree accessControlledTree, boolean isEffectivePolicy, @NotNull Predicate<Tree> predicate) throws RepositoryException {
        if (!accessControlledTree.exists() || !Util.isAccessControlled(oakPath, accessControlledTree, this.ntMgr)) {
            return null;
        }
        Tree aclTree = accessControlledTree.getChild(Util.getAclName(oakPath));
        if (!aclTree.exists()) {
            return null;
        }
        ArrayList<ACE> entries = new ArrayList<ACE>();
        HashMap<String, Principal> principalMap = new HashMap<String, Principal>();
        for (Tree child : aclTree.getChildren()) {
            if (!Util.isACE(child, this.ntMgr) || !predicate.apply((Object)child)) continue;
            ACE ace = this.createACE(oakPath, child, this.restrictionProvider, principalMap);
            entries.add(ace);
        }
        if (!isEffectivePolicy) {
            return new NodeACL(oakPath, entries);
        }
        return entries.isEmpty() ? null : new ImmutableACL(oakPath, entries, this.restrictionProvider, this.getNamePathMapper());
    }

    @Nullable
    private JackrabbitAccessControlList createPrincipalACL(@Nullable String oakPath, @NotNull Principal principal) throws RepositoryException {
        Root root = this.getRoot();
        Result aceResult = AccessControlManagerImpl.searchAces(Collections.singleton(principal), root);
        PrincipalRestrictionProvider restrProvider = new PrincipalRestrictionProvider(this.restrictionProvider);
        ArrayList<ACE> entries = new ArrayList<ACE>();
        HashMap<String, Principal> principalMap = new HashMap<String, Principal>();
        for (ResultRow resultRow : aceResult.getRows()) {
            Tree aceTree = root.getTree(resultRow.getPath());
            if (!Util.isACE(aceTree, this.ntMgr)) continue;
            String aclPath = Text.getRelativeParent(aceTree.getPath(), 1);
            String path = aclPath.endsWith("rep:repoPolicy") ? null : Text.getRelativeParent(aclPath, 1);
            entries.add(this.createACE(path, aceTree, restrProvider, principalMap));
        }
        if (entries.isEmpty()) {
            return null;
        }
        return new PrincipalACL(oakPath, principal, entries, restrProvider);
    }

    @NotNull
    private ACE createACE(@Nullable String oakPath, @NotNull Tree aceTree, @NotNull RestrictionProvider restrictionProvider, @NotNull Map<String, Principal> principalMap) throws RepositoryException {
        boolean isAllow = "rep:GrantACE".equals(TreeUtil.getPrimaryTypeName(aceTree));
        Set<Restriction> restrictions = restrictionProvider.readRestrictions(oakPath, aceTree);
        Iterable privNames = (Iterable)Preconditions.checkNotNull(TreeUtil.getStrings(aceTree, "rep:privileges"));
        return new Entry(this.getPrincipal(aceTree, principalMap), this.bitsProvider.getBits(privNames), isAllow, restrictions, this.getNamePathMapper());
    }

    @NotNull
    private static Result searchAces(@NotNull Set<Principal> principals, @NotNull Root root) throws RepositoryException {
        StringBuilder stmt = new StringBuilder("/jcr:root");
        stmt.append("//element(*,");
        stmt.append("rep:ACE");
        stmt.append(")[");
        int i = 0;
        for (Principal principal : principals) {
            if (i > 0) {
                stmt.append(" or ");
            }
            stmt.append('@');
            stmt.append(ISO9075.encode("rep:principalName"));
            stmt.append("='");
            stmt.append(principal.getName().replaceAll("'", "''"));
            stmt.append('\'');
            ++i;
        }
        stmt.append(']');
        stmt.append(" order by jcr:path");
        try {
            QueryEngine queryEngine = root.getQueryEngine();
            return queryEngine.executeQuery(stmt.toString(), "xpath", QueryEngine.NO_BINDINGS, QueryEngine.NO_MAPPINGS);
        }
        catch (ParseException e) {
            String msg = "Error while collecting effective policies.";
            log.error(msg, (Throwable)e);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    @NotNull
    private Principal getPrincipal(@NotNull Tree aceTree, @NotNull Map<String, Principal> principalMap) {
        String principalName = (String)Preconditions.checkNotNull((Object)TreeUtil.getString(aceTree, "rep:principalName"));
        return principalMap.computeIfAbsent(principalName, pn -> {
            Object principal = this.principalManager.getPrincipal(pn);
            if (principal == null) {
                principal = new PrincipalImpl((String)pn);
            }
            return principal;
        });
    }

    private String getNodePath(ACE principalBasedAce) throws RepositoryException {
        Value v = principalBasedAce.getRestriction("rep:nodePath");
        if (v == null) {
            throw new AccessControlException("Missing mandatory restriction rep:nodePath");
        }
        return this.getOakPath(Strings.emptyToNull((String)v.getString()));
    }

    private static final class PrincipalPredicate
    implements Predicate<Tree> {
        private final Iterable<String> principalNames;

        private PrincipalPredicate(@NotNull Set<Principal> principals) {
            this.principalNames = Iterables.transform(principals, Principal::getName);
        }

        public boolean apply(@Nullable Tree aceTree) {
            return aceTree != null && Iterables.contains(this.principalNames, (Object)TreeUtil.getString(aceTree, "rep:principalName"));
        }
    }

    private static final class ReadPolicy
    implements NamedAccessControlPolicy {
        private static final NamedAccessControlPolicy INSTANCE = new ReadPolicy();

        private ReadPolicy() {
        }

        public String getName() {
            return "Grants read access on configured trees.";
        }
    }

    private final class Entry
    extends ACE {
        private Entry(Principal principal, PrivilegeBits privilegeBits, boolean isAllow, Set<Restriction> restrictions, NamePathMapper namePathMapper) throws AccessControlException {
            super(principal, privilegeBits, isAllow, restrictions, namePathMapper);
        }

        public Privilege[] getPrivileges() {
            HashSet<Privilege> privileges = new HashSet<Privilege>();
            for (String name : AccessControlManagerImpl.this.bitsProvider.getPrivilegeNames(this.getPrivilegeBits())) {
                try {
                    privileges.add(AccessControlManagerImpl.this.getPrivilegeManager().getPrivilege(AccessControlManagerImpl.this.getNamePathMapper().getJcrName(name)));
                }
                catch (RepositoryException e) {
                    log.warn("Unable to get privilege with name : " + name, (Throwable)e);
                }
            }
            return privileges.toArray(new Privilege[0]);
        }
    }

    private final class PrincipalACL
    extends ACL {
        private final Principal principal;
        private final RestrictionProvider rProvider;

        private PrincipalACL(@NotNull String oakPath, Principal principal) {
            this(oakPath, principal, null, new PrincipalRestrictionProvider(accessControlManagerImpl.restrictionProvider));
        }

        private PrincipalACL(@NotNull String oakPath, @Nullable Principal principal, @NotNull List<ACE> entries, RestrictionProvider restrictionProvider) {
            super(oakPath, entries, AccessControlManagerImpl.this.getNamePathMapper());
            this.principal = principal;
            this.rProvider = restrictionProvider;
        }

        @Override
        @NotNull
        public RestrictionProvider getRestrictionProvider() {
            return this.rProvider;
        }

        @Override
        ACE createACE(Principal principal, PrivilegeBits privilegeBits, boolean isAllow, Set<Restriction> restrictions) throws RepositoryException {
            return new Entry(principal, privilegeBits, isAllow, restrictions, this.getNamePathMapper());
        }

        @Override
        boolean checkValidPrincipal(Principal principal) throws AccessControlException {
            Util.checkValidPrincipal(principal, AccessControlManagerImpl.this.principalManager);
            return true;
        }

        @Override
        PrivilegeManager getPrivilegeManager() {
            return AccessControlManagerImpl.this.getPrivilegeManager();
        }

        @Override
        PrivilegeBits getPrivilegeBits(Privilege[] privileges) {
            return AccessControlManagerImpl.this.bitsProvider.getBits(privileges, this.getNamePathMapper());
        }

        @Override
        public void orderBefore(AccessControlEntry srcEntry, AccessControlEntry destEntry) throws RepositoryException {
            throw new UnsupportedRepositoryOperationException("reordering is not supported");
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof PrincipalACL) {
                PrincipalACL other = (PrincipalACL)obj;
                return this.principal.equals(other.principal) && Objects.equal((Object)this.getOakPath(), (Object)other.getOakPath()) && this.getEntries().equals(other.getEntries());
            }
            return false;
        }

        public int hashCode() {
            return 0;
        }
    }

    private class NodeACL
    extends ACL {
        NodeACL(String oakPath) {
            this(oakPath, null);
        }

        NodeACL(@Nullable String oakPath, List<ACE> entries) {
            super(oakPath, entries, AccessControlManagerImpl.this.getNamePathMapper());
        }

        @Override
        @NotNull
        public RestrictionProvider getRestrictionProvider() {
            return AccessControlManagerImpl.this.restrictionProvider;
        }

        @Override
        ACE createACE(Principal principal, PrivilegeBits privilegeBits, boolean isAllow, Set<Restriction> restrictions) throws RepositoryException {
            return new Entry(principal, privilegeBits, isAllow, restrictions, this.getNamePathMapper());
        }

        @Override
        boolean checkValidPrincipal(Principal principal) throws AccessControlException {
            int importBehavior = Util.getImportBehavior(AccessControlManagerImpl.this.getConfig());
            if (!Util.checkValidPrincipal(principal, AccessControlManagerImpl.this.principalManager, importBehavior)) {
                return false;
            }
            if (PermissionUtil.isAdminOrSystem((Set<Principal>)ImmutableSet.of((Object)principal), AccessControlManagerImpl.this.configParams)) {
                log.warn("Attempt to create an ACE for an administrative principal which always has full access: {}", (Object)this.getPath());
                switch (Util.getImportBehavior(AccessControlManagerImpl.this.getConfig())) {
                    case 3: {
                        throw new AccessControlException("Attempt to create an ACE for an administrative principal which always has full access.");
                    }
                    case 1: {
                        return false;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid import behavior" + importBehavior);
                    }
                }
            }
            return true;
        }

        @Override
        PrivilegeManager getPrivilegeManager() {
            return AccessControlManagerImpl.this.getPrivilegeManager();
        }

        @Override
        PrivilegeBits getPrivilegeBits(Privilege[] privileges) {
            return AccessControlManagerImpl.this.bitsProvider.getBits(privileges, this.getNamePathMapper());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof NodeACL) {
                NodeACL other = (NodeACL)obj;
                return Objects.equal((Object)this.getOakPath(), (Object)other.getOakPath()) && this.getEntries().equals(other.getEntries());
            }
            return false;
        }

        public int hashCode() {
            return 0;
        }
    }
}

