/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.security.auth.Subject;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Impersonation;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.security.user.TreeBasedPrincipal;
import org.apache.jackrabbit.oak.security.user.UserImpl;
import org.apache.jackrabbit.oak.spi.security.principal.AdminPrincipal;
import org.apache.jackrabbit.oak.spi.security.principal.GroupPrincipals;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalIteratorAdapter;
import org.apache.jackrabbit.oak.spi.security.user.UserConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ImpersonationImpl
implements Impersonation,
UserConstants {
    private static final Logger log = LoggerFactory.getLogger(ImpersonationImpl.class);
    private final UserImpl user;
    private final PrincipalManager principalManager;

    ImpersonationImpl(@NotNull UserImpl user) {
        this.user = user;
        this.principalManager = user.getUserManager().getPrincipalManager();
    }

    @NotNull
    public PrincipalIterator getImpersonators() {
        Set<String> impersonators = this.getImpersonatorNames();
        if (impersonators.isEmpty()) {
            return PrincipalIteratorAdapter.EMPTY;
        }
        HashSet<Principal> s = new HashSet<Principal>();
        for (String pName : impersonators) {
            Object p = this.principalManager.getPrincipal(pName);
            if (p == null) {
                log.debug("Impersonator {} does not correspond to a known Principal.", (Object)pName);
                p = new PrincipalImpl(pName);
            }
            s.add((Principal)p);
        }
        return new PrincipalIteratorAdapter(s);
    }

    public boolean grantImpersonation(@NotNull Principal principal) throws RepositoryException {
        if (!this.isValidPrincipal(principal)) {
            return false;
        }
        String principalName = principal.getName();
        Tree userTree = this.user.getTree();
        PropertyState prop = userTree.getProperty("rep:principalName");
        if (prop != null && prop.getValue(Type.STRING).equals(principalName)) {
            log.warn("Cannot grant impersonation to oneself.");
            return false;
        }
        this.user.getUserManager().onImpersonation(this.user, principal, true);
        Set<String> impersonators = this.getImpersonatorNames(userTree);
        if (impersonators.add(principalName)) {
            this.updateImpersonatorNames(userTree, impersonators);
            return true;
        }
        return false;
    }

    public boolean revokeImpersonation(@NotNull Principal principal) throws RepositoryException {
        String pName = principal.getName();
        this.user.getUserManager().onImpersonation(this.user, principal, false);
        Tree userTree = this.user.getTree();
        Set<String> impersonators = this.getImpersonatorNames(userTree);
        if (impersonators.remove(pName)) {
            this.updateImpersonatorNames(userTree, impersonators);
            return true;
        }
        return false;
    }

    public boolean allows(@Nullable Subject subject) {
        if (subject == null) {
            return false;
        }
        HashSet<String> principalNames = new HashSet<String>();
        for (Principal principal : subject.getPrincipals()) {
            principalNames.add(principal.getName());
        }
        boolean allows = this.getImpersonatorNames().removeAll(principalNames);
        if (!allows) {
            for (Principal principal : subject.getPrincipals()) {
                if (!this.isAdmin(principal)) continue;
                allows = true;
                break;
            }
        }
        return allows;
    }

    @NotNull
    private Set<String> getImpersonatorNames() {
        return this.getImpersonatorNames(this.user.getTree());
    }

    @NotNull
    private Set<String> getImpersonatorNames(@NotNull Tree userTree) {
        HashSet<String> princNames = new HashSet<String>();
        PropertyState impersonators = userTree.getProperty("rep:impersonators");
        if (impersonators != null) {
            for (String v : impersonators.getValue(Type.STRINGS)) {
                princNames.add(v);
            }
        }
        return princNames;
    }

    private void updateImpersonatorNames(@NotNull Tree userTree, @NotNull Set<String> principalNames) {
        if (principalNames.isEmpty()) {
            userTree.removeProperty("rep:impersonators");
        } else {
            userTree.setProperty("rep:impersonators", principalNames, Type.STRINGS);
        }
    }

    private boolean isAdmin(@NotNull Principal principal) {
        if (principal instanceof AdminPrincipal) {
            return true;
        }
        if (GroupPrincipals.isGroup(principal)) {
            return false;
        }
        try {
            Authorizable authorizable = this.user.getUserManager().getAuthorizable(principal);
            return authorizable != null && !authorizable.isGroup() && ((User)authorizable).isAdmin();
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage());
            return false;
        }
    }

    private boolean isValidPrincipal(@NotNull Principal principal) {
        Principal p = null;
        if (principal instanceof TreeBasedPrincipal) {
            try {
                Authorizable otherUser = this.user.getUserManager().getAuthorizable(principal);
                if (otherUser != null) {
                    p = otherUser.getPrincipal();
                }
            }
            catch (RepositoryException e) {
                log.debug(e.getMessage());
            }
        } else {
            p = this.principalManager.getPrincipal(principal.getName());
        }
        if (p == null) {
            log.debug("Cannot grant impersonation to an unknown principal.");
            return false;
        }
        if (GroupPrincipals.isGroup(p)) {
            log.debug("Cannot grant impersonation to a principal that is a Group.");
            return false;
        }
        if (this.isAdmin(p)) {
            log.debug("Admin principal is already granted impersonation.");
            return false;
        }
        return true;
    }
}

