/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user.query;

import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.QueryBuilder;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.QueryUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.security.user.query.GroupPredicate;
import org.apache.jackrabbit.oak.security.user.query.RelationOp;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QueryUtil {
    private static final Logger log = LoggerFactory.getLogger(GroupPredicate.class);

    private QueryUtil() {
    }

    @NotNull
    public static String getSearchRoot(AuthorizableType type, ConfigurationParameters config) {
        String path = UserUtil.getAuthorizableRootPath(config, type);
        if (PathUtils.denotesRoot(path)) {
            return "/jcr:root";
        }
        return "/jcr:root" + path;
    }

    @NotNull
    public static String getNodeTypeName(@NotNull AuthorizableType type) {
        if (type == AuthorizableType.USER) {
            return "rep:User";
        }
        if (type == AuthorizableType.GROUP) {
            return "rep:Group";
        }
        return "rep:Authorizable";
    }

    @NotNull
    public static String escapeNodeName(@NotNull String string) {
        return QueryUtils.escapeNodeName(string);
    }

    @NotNull
    public static String format(@NotNull Value value) throws RepositoryException {
        switch (value.getType()) {
            case 1: 
            case 6: {
                return '\'' + QueryUtil.escapeForQuery(value.getString()) + '\'';
            }
            case 3: 
            case 4: {
                return value.getString();
            }
            case 5: {
                return "xs:dateTime('" + value.getString() + "')";
            }
        }
        throw new RepositoryException("Property of type " + PropertyType.nameFromValue((int)value.getType()) + " not supported");
    }

    @NotNull
    public static String escapeForQuery(@NotNull String oakName, @NotNull NamePathMapper namePathMapper) {
        return QueryUtil.escapeForQuery(namePathMapper.getJcrName(oakName));
    }

    @NotNull
    public static String escapeForQuery(@NotNull String value) {
        return QueryUtils.escapeForQuery(value);
    }

    @NotNull
    public static RelationOp getCollation(@NotNull QueryBuilder.Direction direction) {
        if (direction == QueryBuilder.Direction.ASCENDING) {
            return RelationOp.GT;
        }
        return RelationOp.LT;
    }

    @Nullable
    public static String getID(@Nullable Authorizable authorizable) {
        if (authorizable != null) {
            try {
                return authorizable.getID();
            }
            catch (RepositoryException e) {
                log.debug("Error while retrieving ID for authorizable {}", (Object)authorizable, (Object)e);
            }
        }
        return null;
    }
}

