/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.principal;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import org.apache.jackrabbit.api.security.principal.GroupPrincipal;
import org.apache.jackrabbit.api.security.principal.JackrabbitPrincipal;
import org.apache.jackrabbit.oak.spi.security.principal.GroupPrincipals;

public final class EveryonePrincipal
implements JackrabbitPrincipal,
Group,
GroupPrincipal {
    public static final String NAME = "everyone";
    private static final EveryonePrincipal INSTANCE = new EveryonePrincipal();

    private EveryonePrincipal() {
    }

    public static EveryonePrincipal getInstance() {
        return INSTANCE;
    }

    public String getName() {
        return NAME;
    }

    public boolean addMember(Principal user) {
        return false;
    }

    public boolean removeMember(Principal user) {
        throw new UnsupportedOperationException("Cannot remove a member from the everyone group.");
    }

    public boolean isMember(Principal member) {
        return !member.equals(this);
    }

    public Enumeration<? extends Principal> members() {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public int hashCode() {
        return NAME.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JackrabbitPrincipal && GroupPrincipals.isGroup((Principal)obj)) {
            JackrabbitPrincipal other = (JackrabbitPrincipal)obj;
            return NAME.equals(other.getName());
        }
        return false;
    }

    public String toString() {
        return "everyone principal";
    }
}

