/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.delegate;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.oak.jcr.delegate.AuthorizableDelegator;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GroupDelegator
extends AuthorizableDelegator
implements Group {
    private GroupDelegator(SessionDelegate sessionDelegate, Group groupDelegate) {
        super(sessionDelegate, groupDelegate);
    }

    static Group wrap(@NotNull SessionDelegate sessionDelegate, Group group) {
        if (group == null) {
            return null;
        }
        return new GroupDelegator(sessionDelegate, group);
    }

    @NotNull
    static Group unwrap(@NotNull Group group) {
        if (group instanceof GroupDelegator) {
            return ((GroupDelegator)group).getDelegate();
        }
        return group;
    }

    private Group getDelegate() {
        return (Group)this.delegate;
    }

    @Override
    @NotNull
    public Iterator<Authorizable> getDeclaredMembers() throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Iterator<Authorizable>>("getDeclaredMembers"){

            @Override
            @NotNull
            public Iterator<Authorizable> perform() throws RepositoryException {
                Iterator<Authorizable> authorizables = GroupDelegator.this.getDelegate().getDeclaredMembers();
                return Iterators.transform(authorizables, (Function)new Function<Authorizable, Authorizable>(){

                    @Nullable
                    public Authorizable apply(@Nullable Authorizable authorizable) {
                        return AuthorizableDelegator.wrap(GroupDelegator.this.sessionDelegate, authorizable);
                    }
                });
            }
        });
    }

    @Override
    @NotNull
    public Iterator<Authorizable> getMembers() throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Iterator<Authorizable>>("getMembers"){

            @Override
            @NotNull
            public Iterator<Authorizable> perform() throws RepositoryException {
                Iterator<Authorizable> authorizables = GroupDelegator.this.getDelegate().getMembers();
                return Iterators.transform(authorizables, (Function)new Function<Authorizable, Authorizable>(){

                    @Nullable
                    public Authorizable apply(@Nullable Authorizable authorizable) {
                        return AuthorizableDelegator.wrap(GroupDelegator.this.sessionDelegate, authorizable);
                    }
                });
            }
        });
    }

    @Override
    public boolean isDeclaredMember(final @NotNull Authorizable authorizable) throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Boolean>("isDeclaredMember"){

            @Override
            @NotNull
            public Boolean perform() throws RepositoryException {
                return GroupDelegator.this.getDelegate().isDeclaredMember(AuthorizableDelegator.unwrap(authorizable));
            }
        });
    }

    @Override
    public boolean isMember(final @NotNull Authorizable authorizable) throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Boolean>("isMember"){

            @Override
            @NotNull
            public Boolean perform() throws RepositoryException {
                return GroupDelegator.this.getDelegate().isMember(AuthorizableDelegator.unwrap(authorizable));
            }
        });
    }

    @Override
    public boolean addMember(final @NotNull Authorizable authorizable) throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Boolean>("addMember", true){

            @Override
            @NotNull
            public Boolean perform() throws RepositoryException {
                return GroupDelegator.this.getDelegate().addMember(AuthorizableDelegator.unwrap(authorizable));
            }
        });
    }

    @Override
    @NotNull
    public Set<String> addMembers(final String ... memberIds) throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Set<String>>("addMembers", true){

            @Override
            @NotNull
            public Set<String> perform() throws RepositoryException {
                return GroupDelegator.this.getDelegate().addMembers(memberIds);
            }
        });
    }

    @Override
    public boolean removeMember(final @NotNull Authorizable authorizable) throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Boolean>("removeMember", true){

            @Override
            @NotNull
            public Boolean perform() throws RepositoryException {
                return GroupDelegator.this.getDelegate().removeMember(AuthorizableDelegator.unwrap(authorizable));
            }
        });
    }

    @Override
    @NotNull
    public Set<String> removeMembers(final String ... memberIds) throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Set<String>>("removeMembers", true){

            @Override
            @NotNull
            public Set<String> perform() throws RepositoryException {
                return GroupDelegator.this.getDelegate().removeMembers(memberIds);
            }
        });
    }
}

