/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.delegate;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.jcr.delegate.ItemDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.NodeDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyDelegate
extends ItemDelegate {
    private final Tree parent;
    @NotNull
    private final String name;
    @Nullable
    private PropertyState state;

    PropertyDelegate(SessionDelegate sessionDelegate, Tree parent, String name) {
        super(sessionDelegate);
        this.parent = (Tree)Preconditions.checkNotNull((Object)parent);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.state = parent.getProperty(name);
    }

    @Override
    protected void update() {
        this.state = this.parent.getProperty(this.name);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getPath() {
        return PathUtils.concat(this.parent.getPath(), this.name);
    }

    @Override
    @Nullable
    public NodeDelegate getParent() {
        return this.parent.exists() ? new NodeDelegate(this.sessionDelegate, this.parent) : null;
    }

    @Override
    public boolean exists() {
        return this.state != null;
    }

    @Override
    @Nullable
    public Tree.Status getStatus() {
        return this.parent.getPropertyStatus(this.name);
    }

    @Override
    public boolean isProtected() throws InvalidItemStateException {
        return this.getParent().isProtected(this.name);
    }

    @NotNull
    public PropertyState getPropertyState() throws InvalidItemStateException {
        if (this.state != null) {
            return this.state;
        }
        throw new InvalidItemStateException("The " + this.name + " property does not exist");
    }

    @NotNull
    public PropertyState getSingleState() throws InvalidItemStateException, ValueFormatException {
        PropertyState p = this.getPropertyState();
        if (p.isArray()) {
            throw new ValueFormatException(p + " is multi-valued.");
        }
        return p;
    }

    public boolean getBoolean() throws ValueFormatException, InvalidItemStateException {
        return this.getSingleState().getValue(Type.BOOLEAN);
    }

    public String getString() throws ValueFormatException, InvalidItemStateException {
        return this.getSingleState().getValue(Type.STRING);
    }

    public String getDate() throws ValueFormatException, InvalidItemStateException {
        return this.getSingleState().getValue(Type.DATE);
    }

    @NotNull
    public PropertyState getMultiState() throws InvalidItemStateException, ValueFormatException {
        PropertyState p = this.getPropertyState();
        if (!p.isArray()) {
            throw new ValueFormatException(p + " is single-valued.");
        }
        return p;
    }

    public void setState(@NotNull PropertyState propertyState) {
        this.parent.setProperty(propertyState);
    }

    @Override
    public boolean remove() {
        if (this.parent.hasProperty(this.name)) {
            this.parent.removeProperty(this.name);
            return true;
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("parent", (Object)this.parent).add("property", (Object)this.parent.getProperty(this.name)).toString();
    }
}

