/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob.datastore;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.oak.plugins.blob.SharedDataStore;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SharedDataStoreUtils {
    public static boolean isShared(BlobStore blobStore) {
        return blobStore instanceof SharedDataStore && ((SharedDataStore)((Object)blobStore)).getType() == SharedDataStore.Type.SHARED;
    }

    public static DataRecord getEarliestRecord(List<DataRecord> recs) {
        return (DataRecord)Ordering.natural().onResultOf((Function)new Function<DataRecord, Long>(){

            @Nullable
            public Long apply(@NotNull DataRecord input) {
                return input.getLastModified();
            }
        }).min(recs);
    }

    public static Set<String> refsNotAvailableFromRepos(List<DataRecord> repos, List<DataRecord> refs) {
        return Sets.difference((Set)FluentIterable.from(repos).uniqueIndex((Function)new Function<DataRecord, String>(){

            @Nullable
            public String apply(@NotNull DataRecord input) {
                return SharedStoreRecordType.REPOSITORY.getIdFromName(input.getIdentifier().toString());
            }
        }).keySet(), (Set)FluentIterable.from(refs).index((Function)new Function<DataRecord, String>(){

            @Nullable
            public String apply(@NotNull DataRecord input) {
                return SharedStoreRecordType.REFERENCES.getIdFromName(input.getIdentifier().toString());
            }
        }).keySet());
    }

    public static Set<String> refsNotOld(List<DataRecord> repos, List<DataRecord> refs, long referenceTime) {
        Set<String> qualifyingRefs = refs.stream().filter(dataRecord -> dataRecord.getLastModified() < referenceTime).collect(Collectors.groupingBy(input -> SharedStoreRecordType.MARKED_START_MARKER.getIdFromName(input.getIdentifier().toString()), Collectors.mapping(java.util.function.Function.identity(), Collectors.toList()))).keySet();
        Set<String> repoIds = repos.stream().map(dataRecord -> SharedStoreRecordType.REPOSITORY.getIdFromName(dataRecord.getIdentifier().toString())).collect(Collectors.toSet());
        repoIds.removeAll(qualifyingRefs);
        return repoIds;
    }

    public static enum SharedStoreRecordType {
        REFERENCES("references"),
        REPOSITORY("repository"),
        MARKED_START_MARKER("markedTimestamp"),
        BLOBREFERENCES("blob");

        private final String type;
        static final String DELIM = "-";

        private SharedStoreRecordType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public String getIdFromName(String name) {
            return (String)Splitter.on((String)"_").limit(2).splitToList((CharSequence)Splitter.on((String)DELIM).limit(2).splitToList((CharSequence)name).get(1)).get(0);
        }

        public String getNameFromId(String id) {
            return Joiner.on((String)DELIM).join((Object)this.getType(), (Object)id, new Object[0]);
        }

        public String getNameFromIdPrefix(String id, String prefix) {
            return Joiner.on((String)"_").join((Object)Joiner.on((String)DELIM).join((Object)this.getType(), (Object)id, new Object[0]), (Object)prefix, new Object[0]);
        }
    }
}

