/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.property.PropertyIndexPlan;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PropertyIndex
implements QueryIndex {
    private static final String PROPERTY = "property";
    private static final Logger LOG = LoggerFactory.getLogger(PropertyIndex.class);
    private final MountInfoProvider mountInfoProvider;
    private PropertyIndexPlan cachedPlan;

    PropertyIndex(MountInfoProvider mountInfoProvider) {
        this.mountInfoProvider = mountInfoProvider;
    }

    private PropertyIndexPlan getPlan(NodeState root, Filter filter) {
        PropertyIndexPlan plan = this.cachedPlan;
        if (plan != null && plan.getFilter().toString().equals(filter.toString())) {
            return plan;
        }
        this.cachedPlan = plan = PropertyIndex.createPlan(root, filter, this.mountInfoProvider);
        return plan;
    }

    private static PropertyIndexPlan createPlan(NodeState root, Filter filter, MountInfoProvider mountInfoProvider) {
        PropertyIndexPlan bestPlan = null;
        NodeState state = root.getChildNode("oak:index");
        for (ChildNodeEntry childNodeEntry : state.getChildNodeEntries()) {
            PropertyIndexPlan plan;
            NodeState definition = childNodeEntry.getNodeState();
            if (PropertyIndex.wrongIndex(childNodeEntry, filter, root) || !PROPERTY.equals(definition.getString("type")) || !definition.hasChildNode(":index") || (plan = new PropertyIndexPlan(childNodeEntry.getName(), root, definition, filter, mountInfoProvider)).getCost() == Double.POSITIVE_INFINITY) continue;
            LOG.debug("property cost for {} is {}", (Object)plan.getName(), (Object)plan.getCost());
            if (bestPlan != null && !(plan.getCost() < bestPlan.getCost())) continue;
            bestPlan = plan;
            if (plan.getCost() != 2.0) continue;
            break;
        }
        return bestPlan;
    }

    private static boolean wrongIndex(ChildNodeEntry entry, Filter filter, NodeState root) {
        Filter.PropertyRestriction indexTag;
        NodeState definition = entry.getNodeState();
        if (!PropertyIndex.isEnabled(definition, root)) {
            return true;
        }
        Filter.PropertyRestriction indexName = filter.getPropertyRestriction(":indexName");
        boolean wrong = false;
        if (indexName != null && indexName.first != null) {
            String name = indexName.first.getValue(Type.STRING);
            String thisName = entry.getName();
            if (thisName.equals(name)) {
                return false;
            }
            wrong = true;
        }
        if ((indexTag = filter.getPropertyRestriction(":indexTag")) != null && indexTag.first != null) {
            String[] tags = PropertyIndex.getOptionalStrings(definition, "tags");
            if (tags == null) {
                return true;
            }
            String tag = indexTag.first.getValue(Type.STRING);
            for (String t : tags) {
                if (!t.equals(tag)) continue;
                return false;
            }
            return true;
        }
        return wrong;
    }

    private static boolean isEnabled(NodeState definition, NodeState root) {
        String useIfExists = definition.getString("useIfExists");
        if (useIfExists == null) {
            return true;
        }
        if (!PathUtils.isValid(useIfExists)) {
            return false;
        }
        NodeState nodeState = root;
        for (String element : PathUtils.elements(useIfExists)) {
            if (element.startsWith("@")) {
                return nodeState.hasProperty(element.substring(1));
            }
            if ((nodeState = nodeState.getChildNode(element)).exists()) continue;
            return false;
        }
        return true;
    }

    private static String[] getOptionalStrings(NodeState defn, String propertyName) {
        PropertyState ps = defn.getProperty(propertyName);
        if (ps != null) {
            return (String[])Iterables.toArray(ps.getValue(Type.STRINGS), String.class);
        }
        return null;
    }

    @Override
    public double getMinimumCost() {
        return 2.0;
    }

    @Override
    public String getIndexName() {
        return PROPERTY;
    }

    @Override
    public String getIndexName(Filter filter, NodeState root) {
        PropertyIndexPlan plan = this.getPlan(root, filter);
        return plan == null ? null : plan.getName();
    }

    @Override
    public double getCost(Filter filter, NodeState root) {
        if (filter.getFullTextConstraint() != null) {
            return Double.POSITIVE_INFINITY;
        }
        if (filter.containsNativeConstraint()) {
            return Double.POSITIVE_INFINITY;
        }
        if (filter.getPropertyRestrictions().isEmpty()) {
            return Double.POSITIVE_INFINITY;
        }
        PropertyIndexPlan plan = this.getPlan(root, filter);
        if (plan != null) {
            return plan.getCost();
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public Cursor query(Filter filter, NodeState root) {
        PropertyIndexPlan plan = this.getPlan(root, filter);
        Preconditions.checkState((plan != null ? 1 : 0) != 0, (Object)("Property index is used even when no index is available for filter " + filter));
        return plan.execute();
    }

    @Override
    public String getPlan(Filter filter, NodeState root) {
        PropertyIndexPlan plan = this.getPlan(root, filter);
        if (plan != null) {
            return plan.toString();
        }
        return "property index not applicable";
    }
}

