/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.tree.impl;

import com.google.common.base.Preconditions;
import java.util.Collections;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HiddenTree
implements Tree {
    private final Tree parent;
    private final String name;

    HiddenTree(Tree parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public String toString() {
        return this.getPath() + ": {}";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    @NotNull
    public String getPath() {
        return PathUtils.concat(this.parent.getPath(), this.name);
    }

    @Override
    @NotNull
    public Tree.Status getStatus() {
        return Tree.Status.UNCHANGED;
    }

    @Override
    public boolean exists() {
        return false;
    }

    @Override
    @NotNull
    public Tree getParent() {
        return this.parent;
    }

    @Override
    @Nullable
    public PropertyState getProperty(@NotNull String name) {
        return null;
    }

    @Override
    @Nullable
    public Tree.Status getPropertyStatus(@NotNull String name) {
        return null;
    }

    @Override
    public boolean hasProperty(@NotNull String name) {
        return false;
    }

    @Override
    public long getPropertyCount() {
        return 0L;
    }

    @Override
    @NotNull
    public Iterable<? extends PropertyState> getProperties() {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public Tree getChild(@NotNull String name) {
        return new HiddenTree(this, (String)Preconditions.checkNotNull((Object)name));
    }

    @Override
    public boolean hasChild(@NotNull String name) {
        return false;
    }

    @Override
    public long getChildrenCount(long max) {
        return 0L;
    }

    @Override
    @NotNull
    public Iterable<Tree> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public boolean remove() {
        return false;
    }

    @Override
    @NotNull
    public Tree addChild(@NotNull String name) {
        throw HiddenTree.nonExistingTree();
    }

    @Override
    public void setOrderableChildren(boolean enable) {
        throw HiddenTree.nonExistingTree();
    }

    @Override
    public boolean orderBefore(@Nullable String name) {
        throw HiddenTree.nonExistingTree();
    }

    @Override
    public void setProperty(@NotNull PropertyState property) {
        throw HiddenTree.nonExistingTree();
    }

    @Override
    public <T> void setProperty(@NotNull String name, @NotNull T value) {
        throw HiddenTree.nonExistingTree();
    }

    @Override
    public <T> void setProperty(@NotNull String name, @NotNull T value, @NotNull Type<T> type) {
        throw HiddenTree.nonExistingTree();
    }

    @Override
    public void removeProperty(@NotNull String name) {
        throw HiddenTree.nonExistingTree();
    }

    private static IllegalStateException nonExistingTree() {
        return new IllegalStateException("This tree does not exist");
    }
}

