/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.index;

import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.Cursors;
import org.apache.jackrabbit.oak.plugins.index.counter.jmx.NodeCounter;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class TraversingIndex
implements QueryIndex {
    @Override
    public double getMinimumCost() {
        return 0.0;
    }

    @Override
    public Cursor query(Filter filter, NodeState rootState) {
        return Cursors.newTraversingCursor(filter, rootState);
    }

    public boolean isPotentiallySlow(Filter filter, NodeState rootState) {
        if (filter.getFullTextConstraint() != null) {
            return true;
        }
        if (filter.containsNativeConstraint()) {
            return true;
        }
        if (filter.isAlwaysFalse()) {
            return false;
        }
        Filter.PathRestriction restriction = filter.getPathRestriction();
        switch (restriction) {
            case EXACT: 
            case PARENT: 
            case DIRECT_CHILDREN: {
                return false;
            }
            case NO_RESTRICTION: 
            case ALL_CHILDREN: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unknown restriction: " + (Object)((Object)restriction));
    }

    @Override
    public double getCost(Filter filter, NodeState rootState) {
        if (filter.getFullTextConstraint() != null) {
            return Double.POSITIVE_INFINITY;
        }
        if (filter.containsNativeConstraint()) {
            return Double.POSITIVE_INFINITY;
        }
        Filter.PropertyRestriction facetRestriction = filter.getPropertyRestriction("rep:facet");
        if (facetRestriction != null) {
            return Double.POSITIVE_INFINITY;
        }
        if (filter.isAlwaysFalse()) {
            return 0.0;
        }
        String path = filter.getPath();
        Filter.PathRestriction restriction = filter.getPathRestriction();
        switch (restriction) {
            case EXACT: {
                return 1.0;
            }
            case PARENT: {
                if (PathUtils.denotesRoot(path)) {
                    return 0.0;
                }
                return 1.0;
            }
            case DIRECT_CHILDREN: 
            case NO_RESTRICTION: 
            case ALL_CHILDREN: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown restriction: " + (Object)((Object)restriction));
            }
        }
        if (!path.startsWith("//")) {
            long count;
            String testPath = path;
            if (restriction == Filter.PathRestriction.NO_RESTRICTION) {
                testPath = "/";
            }
            if ((count = NodeCounter.getEstimatedNodeCount(rootState, testPath, true)) >= 0L) {
                if (restriction == Filter.PathRestriction.DIRECT_CHILDREN) {
                    count /= 2L;
                }
                return count;
            }
        }
        double nodeCount = 1.0E8;
        double nodeCountChildren = 100000.0;
        switch (restriction) {
            case NO_RESTRICTION: {
                break;
            }
            case ALL_CHILDREN: {
                int depth;
                if (PathUtils.denotesRoot(path)) break;
                for (int i = depth = PathUtils.getDepth(path); i > 0; --i) {
                    nodeCount = Math.max(nodeCountChildren * 2.0 - (double)depth, nodeCount / 10.0);
                }
                break;
            }
            case DIRECT_CHILDREN: {
                nodeCount = nodeCountChildren;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown restriction: " + (Object)((Object)restriction));
            }
        }
        return nodeCount;
    }

    @Override
    public String getPlan(Filter filter, NodeState rootState) {
        return "traverse \"" + filter.getPathPlan() + '\"';
    }

    @Override
    public String getIndexName() {
        return "traverse";
    }
}

