/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.security.user.AuthorizableImpl;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class Utils {
    private Utils() {
    }

    @NotNull
    static Tree getOrAddTree(@NotNull Tree tree, @NotNull String relativePath, @NotNull String primaryTypeName) throws AccessDeniedException {
        if (PathUtils.denotesCurrent(relativePath)) {
            return tree;
        }
        if (PathUtils.denotesParent(relativePath)) {
            return tree.getParent();
        }
        if (relativePath.indexOf(47) == -1) {
            return TreeUtil.getOrAddChild(tree, relativePath, primaryTypeName);
        }
        for (String element : PathUtils.elements(relativePath)) {
            if (PathUtils.denotesParent(element)) {
                tree = tree.getParent();
                continue;
            }
            if (PathUtils.denotesCurrent(element)) continue;
            tree = TreeUtil.getOrAddChild(tree, element, primaryTypeName);
        }
        return tree;
    }

    static boolean canHavePasswordExpired(@NotNull String userId, @NotNull ConfigurationParameters config) {
        return !UserUtil.isAdmin(config, userId) || config.getConfigValue("passwordExpiryForAdmin", false) != false;
    }

    static boolean canHavePasswordExpired(@NotNull User user, @NotNull ConfigurationParameters config) {
        return !user.isAdmin() || config.getConfigValue("passwordExpiryForAdmin", false) != false;
    }

    static boolean isEveryone(@NotNull Authorizable authorizable) {
        return authorizable.isGroup() && "everyone".equals(Utils.getPrincipalName(authorizable));
    }

    @Nullable
    private static String getPrincipalName(@NotNull Authorizable authorizable) {
        if (authorizable instanceof AuthorizableImpl) {
            return ((AuthorizableImpl)authorizable).getPrincipalNameOrNull();
        }
        try {
            return authorizable.getPrincipal().getName();
        }
        catch (RepositoryException e) {
            return null;
        }
    }
}

