/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user.query;

import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.security.user.query.QueryUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GroupPredicate
implements Predicate<Authorizable> {
    private final Iterator<Authorizable> membersIterator;
    private final Set<String> memberIds = new HashSet<String>();

    GroupPredicate(@NotNull UserManager userManager, @NotNull String groupId, boolean declaredMembersOnly) throws RepositoryException {
        Group group;
        Authorizable authorizable = userManager.getAuthorizable(groupId);
        Group group2 = group = authorizable == null || !authorizable.isGroup() ? null : (Group)authorizable;
        this.membersIterator = group != null ? (declaredMembersOnly ? group.getDeclaredMembers() : group.getMembers()) : Collections.emptyIterator();
    }

    public boolean apply(@Nullable Authorizable authorizable) {
        String id = QueryUtil.getID(authorizable);
        if (id != null) {
            if (this.memberIds.contains(id)) {
                return true;
            }
            while (this.membersIterator.hasNext()) {
                String memberId = QueryUtil.getID(this.membersIterator.next());
                if (memberId == null) continue;
                this.memberIds.add(memberId);
                if (!memberId.equals(id)) continue;
                return true;
            }
        }
        return false;
    }
}

