/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.commit;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.spi.commit.ThreeWayConflictHandler;
import org.apache.jackrabbit.oak.spi.state.ConflictType;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

public class CompositeConflictHandler
implements ThreeWayConflictHandler {
    private final LinkedList<ThreeWayConflictHandler> handlers;

    public CompositeConflictHandler(@NotNull Iterable<ThreeWayConflictHandler> handlers) {
        this.handlers = Lists.newLinkedList((Iterable)((Iterable)Preconditions.checkNotNull(handlers)));
    }

    public CompositeConflictHandler() {
        this.handlers = Lists.newLinkedList();
    }

    public CompositeConflictHandler addHandler(@NotNull ThreeWayConflictHandler handler) {
        this.handlers.addFirst(handler);
        return this;
    }

    @Override
    @NotNull
    public ThreeWayConflictHandler.Resolution addExistingProperty(@NotNull NodeBuilder parent, @NotNull PropertyState ours, @NotNull PropertyState theirs) {
        for (ThreeWayConflictHandler handler : this.handlers) {
            ThreeWayConflictHandler.Resolution resolution = handler.addExistingProperty(parent, ours, theirs);
            if (resolution == ThreeWayConflictHandler.Resolution.IGNORED) continue;
            return resolution;
        }
        throw new IllegalStateException("No conflict handler for " + (Object)((Object)ConflictType.ADD_EXISTING_PROPERTY) + " conflict");
    }

    @Override
    @NotNull
    public ThreeWayConflictHandler.Resolution changeDeletedProperty(@NotNull NodeBuilder parent, @NotNull PropertyState ours, @NotNull PropertyState base) {
        for (ThreeWayConflictHandler handler : this.handlers) {
            ThreeWayConflictHandler.Resolution resolution = handler.changeDeletedProperty(parent, ours, base);
            if (resolution == ThreeWayConflictHandler.Resolution.IGNORED) continue;
            return resolution;
        }
        throw new IllegalStateException("No conflict handler for " + (Object)((Object)ConflictType.CHANGE_DELETED_PROPERTY) + " conflict");
    }

    @Override
    @NotNull
    public ThreeWayConflictHandler.Resolution changeChangedProperty(@NotNull NodeBuilder parent, @NotNull PropertyState ours, @NotNull PropertyState theirs, @NotNull PropertyState base) {
        for (ThreeWayConflictHandler handler : this.handlers) {
            ThreeWayConflictHandler.Resolution resolution = handler.changeChangedProperty(parent, ours, theirs, base);
            if (resolution == ThreeWayConflictHandler.Resolution.IGNORED) continue;
            return resolution;
        }
        throw new IllegalStateException("No conflict handler for " + (Object)((Object)ConflictType.CHANGE_CHANGED_PROPERTY) + " conflict");
    }

    @Override
    @NotNull
    public ThreeWayConflictHandler.Resolution deleteDeletedProperty(@NotNull NodeBuilder parent, @NotNull PropertyState base) {
        for (ThreeWayConflictHandler handler : this.handlers) {
            ThreeWayConflictHandler.Resolution resolution = handler.deleteDeletedProperty(parent, base);
            if (resolution == ThreeWayConflictHandler.Resolution.IGNORED) continue;
            return resolution;
        }
        throw new IllegalStateException("No conflict handler for " + (Object)((Object)ConflictType.DELETE_DELETED_PROPERTY) + " conflict");
    }

    @Override
    @NotNull
    public ThreeWayConflictHandler.Resolution deleteChangedProperty(@NotNull NodeBuilder parent, @NotNull PropertyState theirs, @NotNull PropertyState base) {
        for (ThreeWayConflictHandler handler : this.handlers) {
            ThreeWayConflictHandler.Resolution resolution = handler.deleteChangedProperty(parent, theirs, base);
            if (resolution == ThreeWayConflictHandler.Resolution.IGNORED) continue;
            return resolution;
        }
        throw new IllegalStateException("No conflict handler for " + (Object)((Object)ConflictType.DELETE_CHANGED_PROPERTY) + " conflict");
    }

    @Override
    @NotNull
    public ThreeWayConflictHandler.Resolution addExistingNode(@NotNull NodeBuilder parent, @NotNull String name, @NotNull NodeState ours, @NotNull NodeState theirs) {
        for (ThreeWayConflictHandler handler : this.handlers) {
            ThreeWayConflictHandler.Resolution resolution = handler.addExistingNode(parent, name, ours, theirs);
            if (resolution == ThreeWayConflictHandler.Resolution.IGNORED) continue;
            return resolution;
        }
        throw new IllegalStateException("No conflict handler for " + (Object)((Object)ConflictType.ADD_EXISTING_NODE) + " conflict");
    }

    @Override
    @NotNull
    public ThreeWayConflictHandler.Resolution changeDeletedNode(@NotNull NodeBuilder parent, @NotNull String name, @NotNull NodeState ours, @NotNull NodeState base) {
        for (ThreeWayConflictHandler handler : this.handlers) {
            ThreeWayConflictHandler.Resolution resolution = handler.changeDeletedNode(parent, name, ours, base);
            if (resolution == ThreeWayConflictHandler.Resolution.IGNORED) continue;
            return resolution;
        }
        throw new IllegalStateException("No conflict handler for " + (Object)((Object)ConflictType.CHANGE_DELETED_NODE) + " conflict");
    }

    @Override
    @NotNull
    public ThreeWayConflictHandler.Resolution deleteChangedNode(@NotNull NodeBuilder parent, @NotNull String name, @NotNull NodeState theirs, @NotNull NodeState base) {
        for (ThreeWayConflictHandler handler : this.handlers) {
            ThreeWayConflictHandler.Resolution resolution = handler.deleteChangedNode(parent, name, theirs, base);
            if (resolution == ThreeWayConflictHandler.Resolution.IGNORED) continue;
            return resolution;
        }
        throw new IllegalStateException("No conflict handler for " + (Object)((Object)ConflictType.DELETE_CHANGED_NODE) + " conflict");
    }

    @Override
    @NotNull
    public ThreeWayConflictHandler.Resolution deleteDeletedNode(@NotNull NodeBuilder parent, @NotNull String name, @NotNull NodeState base) {
        for (ThreeWayConflictHandler handler : this.handlers) {
            ThreeWayConflictHandler.Resolution resolution = handler.deleteDeletedNode(parent, name, base);
            if (resolution == ThreeWayConflictHandler.Resolution.IGNORED) continue;
            return resolution;
        }
        throw new IllegalStateException("No conflict handler for " + (Object)((Object)ConflictType.DELETE_DELETED_NODE) + " conflict");
    }
}

