/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.jmx;

import java.util.Hashtable;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jetbrains.annotations.NotNull;
import sling-mock-oak.com.google.common.collect.ImmutableMap;

public final class JmxUtil {
    private JmxUtil() {
    }

    public static String quoteValueIfRequired(String unquotedValue) {
        String result;
        String quotedValue = ObjectName.quote(unquotedValue);
        if (quotedValue.substring(1, quotedValue.length() - 1).equals(unquotedValue)) {
            ObjectName on = null;
            try {
                on = new ObjectName("dummy", "dummy", unquotedValue);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                // empty catch block
            }
            result = on != null ? unquotedValue : quotedValue;
        } else {
            result = quotedValue;
        }
        return result;
    }

    @NotNull
    public static Map<String, ObjectName> createObjectNameMap(@NotNull String type, @NotNull String name, @NotNull Map<String, String> properties) throws MalformedObjectNameException {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("type", JmxUtil.quoteValueIfRequired(type));
        table.put("name", JmxUtil.quoteValueIfRequired(name));
        properties.forEach((key, value) -> table.put((String)key, JmxUtil.quoteValueIfRequired(value)));
        return ImmutableMap.of("jmx.objectname", new ObjectName("org.apache.jackrabbit.oak", table));
    }
}

