/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.delegate;

import java.security.Principal;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.Query;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.jcr.delegate.AuthorizableDelegator;
import org.apache.jackrabbit.oak.jcr.delegate.GroupDelegator;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.UserDelegator;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;
import org.apache.jackrabbit.oak.jcr.session.operation.UserManagerOperation;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sling-mock-oak.com.google.common.base.Preconditions;
import sling-mock-oak.com.google.common.collect.Iterators;

public class UserManagerDelegator
implements UserManager {
    private final SessionDelegate sessionDelegate;
    private final UserManager userManagerDelegate;

    public UserManagerDelegator(SessionDelegate sessionDelegate, UserManager userManagerDelegate) {
        Preconditions.checkArgument(!(userManagerDelegate instanceof UserManagerDelegator));
        this.sessionDelegate = sessionDelegate;
        this.userManagerDelegate = userManagerDelegate;
    }

    @Override
    @Nullable
    public Authorizable getAuthorizable(final @NotNull String id) throws RepositoryException {
        return this.sessionDelegate.performNullable(new UserManagerOperation<Authorizable>(this.sessionDelegate, "getAuthorizable"){

            @Override
            public Authorizable performNullable() throws RepositoryException {
                Authorizable authorizable = UserManagerDelegator.this.userManagerDelegate.getAuthorizable(id);
                return AuthorizableDelegator.wrap(UserManagerDelegator.this.sessionDelegate, authorizable);
            }
        });
    }

    @Override
    @Nullable
    public <T extends Authorizable> T getAuthorizable(final @NotNull String id, final @NotNull Class<T> authorizableClass) throws RepositoryException {
        return (T)((Authorizable)this.sessionDelegate.performNullable(new UserManagerOperation<T>(this.sessionDelegate, "getAuthorizable"){

            @Override
            public T performNullable() throws RepositoryException {
                Authorizable authorizable = UserManagerDelegator.this.userManagerDelegate.getAuthorizable(id);
                return UserUtil.castAuthorizable(AuthorizableDelegator.wrap(UserManagerDelegator.this.sessionDelegate, authorizable), authorizableClass);
            }
        }));
    }

    @Override
    @Nullable
    public Authorizable getAuthorizable(final @NotNull Principal principal) throws RepositoryException {
        return this.sessionDelegate.performNullable(new UserManagerOperation<Authorizable>(this.sessionDelegate, "getAuthorizable"){

            @Override
            public Authorizable performNullable() throws RepositoryException {
                Authorizable authorizable = UserManagerDelegator.this.userManagerDelegate.getAuthorizable(principal);
                return AuthorizableDelegator.wrap(UserManagerDelegator.this.sessionDelegate, authorizable);
            }
        });
    }

    @Override
    @Nullable
    public Authorizable getAuthorizableByPath(final @NotNull String path) throws RepositoryException {
        return this.sessionDelegate.performNullable(new UserManagerOperation<Authorizable>(this.sessionDelegate, "getAuthorizableByPath"){

            @Override
            public Authorizable performNullable() throws RepositoryException {
                Authorizable authorizable = UserManagerDelegator.this.userManagerDelegate.getAuthorizableByPath(path);
                return AuthorizableDelegator.wrap(UserManagerDelegator.this.sessionDelegate, authorizable);
            }
        });
    }

    @Override
    @NotNull
    public Iterator<Authorizable> findAuthorizables(final @NotNull String relPath, final @Nullable String value) throws RepositoryException {
        return this.sessionDelegate.perform(new UserManagerOperation<Iterator<Authorizable>>(this.sessionDelegate, "findAuthorizables"){

            @Override
            @NotNull
            public Iterator<Authorizable> perform() throws RepositoryException {
                Iterator<Authorizable> authorizables = UserManagerDelegator.this.userManagerDelegate.findAuthorizables(relPath, value);
                return Iterators.transform(authorizables, authorizable -> AuthorizableDelegator.wrap(UserManagerDelegator.this.sessionDelegate, authorizable));
            }
        });
    }

    @Override
    @NotNull
    public Iterator<Authorizable> findAuthorizables(final @NotNull String relPath, final @Nullable String value, final int searchType) throws RepositoryException {
        return this.sessionDelegate.perform(new UserManagerOperation<Iterator<Authorizable>>(this.sessionDelegate, "findAuthorizables"){

            @Override
            @NotNull
            public Iterator<Authorizable> perform() throws RepositoryException {
                Iterator<Authorizable> authorizables = UserManagerDelegator.this.userManagerDelegate.findAuthorizables(relPath, value, searchType);
                return Iterators.transform(authorizables, authorizable -> AuthorizableDelegator.wrap(UserManagerDelegator.this.sessionDelegate, authorizable));
            }
        });
    }

    @Override
    @NotNull
    public Iterator<Authorizable> findAuthorizables(final @NotNull Query query) throws RepositoryException {
        return this.sessionDelegate.perform(new UserManagerOperation<Iterator<Authorizable>>(this.sessionDelegate, "findAuthorizables"){

            @Override
            @NotNull
            public Iterator<Authorizable> perform() throws RepositoryException {
                Iterator<Authorizable> authorizables = UserManagerDelegator.this.userManagerDelegate.findAuthorizables(query);
                return Iterators.transform(authorizables, authorizable -> AuthorizableDelegator.wrap(UserManagerDelegator.this.sessionDelegate, authorizable));
            }
        });
    }

    @Override
    @NotNull
    public User createUser(final @NotNull String userID, final @Nullable String password) throws RepositoryException {
        return this.sessionDelegate.perform(new UserManagerOperation<User>(this.sessionDelegate, "createUser", true){

            @Override
            @NotNull
            public User perform() throws RepositoryException {
                User user = UserManagerDelegator.this.userManagerDelegate.createUser(userID, password);
                return UserDelegator.wrap(UserManagerDelegator.this.sessionDelegate, user);
            }
        });
    }

    @Override
    @NotNull
    public User createUser(final @NotNull String userID, final @Nullable String password, final @NotNull Principal principal, final @Nullable String intermediatePath) throws RepositoryException {
        return this.sessionDelegate.perform(new UserManagerOperation<User>(this.sessionDelegate, "createUser", true){

            @Override
            @NotNull
            public User perform() throws RepositoryException {
                User user = UserManagerDelegator.this.userManagerDelegate.createUser(userID, password, principal, intermediatePath);
                return UserDelegator.wrap(UserManagerDelegator.this.sessionDelegate, user);
            }
        });
    }

    @Override
    @NotNull
    public User createSystemUser(final @NotNull String userID, final @Nullable String intermediatePath) throws RepositoryException {
        return this.sessionDelegate.perform(new UserManagerOperation<User>(this.sessionDelegate, "createUser", true){

            @Override
            @NotNull
            public User perform() throws RepositoryException {
                User user = UserManagerDelegator.this.userManagerDelegate.createSystemUser(userID, intermediatePath);
                return UserDelegator.wrap(UserManagerDelegator.this.sessionDelegate, user);
            }
        });
    }

    @Override
    @NotNull
    public Group createGroup(final @NotNull String groupID) throws RepositoryException {
        return this.sessionDelegate.perform(new UserManagerOperation<Group>(this.sessionDelegate, "createGroup", true){

            @Override
            @NotNull
            public Group perform() throws RepositoryException {
                Group group = UserManagerDelegator.this.userManagerDelegate.createGroup(groupID);
                return GroupDelegator.wrap(UserManagerDelegator.this.sessionDelegate, group);
            }
        });
    }

    @Override
    @NotNull
    public Group createGroup(final @NotNull Principal principal) throws RepositoryException {
        return this.sessionDelegate.perform(new UserManagerOperation<Group>(this.sessionDelegate, "createGroup", true){

            @Override
            @NotNull
            public Group perform() throws RepositoryException {
                Group group = UserManagerDelegator.this.userManagerDelegate.createGroup(principal);
                return GroupDelegator.wrap(UserManagerDelegator.this.sessionDelegate, group);
            }
        });
    }

    @Override
    @NotNull
    public Group createGroup(final @NotNull Principal principal, final @Nullable String intermediatePath) throws RepositoryException {
        return this.sessionDelegate.perform(new UserManagerOperation<Group>(this.sessionDelegate, "createGroup", true){

            @Override
            @NotNull
            public Group perform() throws RepositoryException {
                Group group = UserManagerDelegator.this.userManagerDelegate.createGroup(principal, intermediatePath);
                return GroupDelegator.wrap(UserManagerDelegator.this.sessionDelegate, group);
            }
        });
    }

    @Override
    @NotNull
    public Group createGroup(final @NotNull String groupID, final @NotNull Principal principal, final @Nullable String intermediatePath) throws RepositoryException {
        return this.sessionDelegate.perform(new UserManagerOperation<Group>(this.sessionDelegate, "createGroup", true){

            @Override
            @NotNull
            public Group perform() throws RepositoryException {
                Group group = UserManagerDelegator.this.userManagerDelegate.createGroup(groupID, principal, intermediatePath);
                return GroupDelegator.wrap(UserManagerDelegator.this.sessionDelegate, group);
            }
        });
    }

    @Override
    public boolean isAutoSave() {
        return this.sessionDelegate.safePerform(new UserManagerOperation<Boolean>(this.sessionDelegate, "isAutoSave"){

            @Override
            @NotNull
            public Boolean perform() {
                return UserManagerDelegator.this.userManagerDelegate.isAutoSave();
            }
        });
    }

    @Override
    public void autoSave(final boolean enable) throws RepositoryException {
        this.sessionDelegate.performVoid((SessionOperation<Void>)new UserManagerOperation<Void>(this.sessionDelegate, "autoSave"){

            @Override
            public void performVoid() throws RepositoryException {
                UserManagerDelegator.this.userManagerDelegate.autoSave(enable);
            }
        });
    }
}

