/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jackrabbit.oak.plugins.index.IndexInfo;
import org.apache.jackrabbit.oak.plugins.index.IndexInfoProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexInfoService;
import org.apache.jackrabbit.oak.plugins.index.IndexPathService;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sling-mock-oak.com.google.common.base.Function;
import sling-mock-oak.com.google.common.base.Preconditions;
import sling-mock-oak.com.google.common.base.Predicates;
import sling-mock-oak.com.google.common.collect.Iterables;

@Component
public class IndexInfoServiceImpl
implements IndexInfoService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private IndexPathService indexPathService;
    private final Map<String, IndexInfoProvider> infoProviders = new ConcurrentHashMap<String, IndexInfoProvider>();
    @Reference
    private NodeStore nodeStore;

    public IndexInfoServiceImpl() {
    }

    public IndexInfoServiceImpl(NodeStore nodeStore, IndexPathService indexPathService) {
        this.indexPathService = indexPathService;
        this.nodeStore = nodeStore;
    }

    @Override
    public Iterable<IndexInfo> getAllIndexInfo() {
        return Iterables.filter(Iterables.transform(this.indexPathService.getIndexPaths(), new Function<String, IndexInfo>(){

            @Override
            public IndexInfo apply(String indexPath) {
                try {
                    return IndexInfoServiceImpl.this.getInfo(indexPath);
                }
                catch (Exception e) {
                    IndexInfoServiceImpl.this.log.warn("Error occurred while capturing IndexInfo for path {}", (Object)indexPath, (Object)e);
                    return null;
                }
            }
        }), Predicates.notNull());
    }

    @Override
    public IndexInfo getInfo(String indexPath) throws IOException {
        String type = this.getIndexType(indexPath);
        if (type == null) {
            return null;
        }
        IndexInfoProvider infoProvider = this.infoProviders.get(type);
        if (infoProvider == null) {
            return new SimpleIndexInfo(indexPath, type);
        }
        return infoProvider.getInfo(indexPath);
    }

    @Override
    public boolean isValid(String indexPath) throws IOException {
        String type = this.getIndexType(indexPath);
        if (type == null) {
            this.log.warn("No type property defined for index definition at path {}", (Object)indexPath);
            return false;
        }
        IndexInfoProvider infoProvider = this.infoProviders.get(type);
        if (infoProvider == null) {
            this.log.warn("No IndexInfoProvider for for index definition at path {} of type {}", (Object)indexPath, (Object)type);
            return true;
        }
        return infoProvider.isValid(indexPath);
    }

    @Reference(name="infoProviders", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY, service=IndexInfoProvider.class)
    public void bindInfoProviders(IndexInfoProvider infoProvider) {
        this.infoProviders.put(Preconditions.checkNotNull(infoProvider.getType()), infoProvider);
    }

    public void unbindInfoProviders(IndexInfoProvider infoProvider) {
        this.infoProviders.remove(infoProvider.getType());
    }

    private String getIndexType(String indexPath) {
        NodeState idxState = NodeStateUtils.getNode(this.nodeStore.getRoot(), indexPath);
        String type = idxState.getString("type");
        if (type == null || "disabled".equals(type)) {
            return null;
        }
        return type;
    }

    private static class SimpleIndexInfo
    implements IndexInfo {
        private final String indexPath;
        private final String type;

        private SimpleIndexInfo(String indexPath, String type) {
            this.indexPath = indexPath;
            this.type = type;
        }

        @Override
        public String getIndexPath() {
            return this.indexPath;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public String getAsyncLaneName() {
            return null;
        }

        @Override
        public long getLastUpdatedTime() {
            return -1L;
        }

        @Override
        public long getIndexedUpToTime() {
            return -1L;
        }

        @Override
        public long getEstimatedEntryCount() {
            return -1L;
        }

        @Override
        public long getSizeInBytes() {
            return -1L;
        }

        @Override
        public boolean hasIndexDefinitionChangedWithoutReindexing() {
            return false;
        }

        @Override
        public String getIndexDefinitionDiff() {
            return null;
        }

        @Override
        public boolean hasHiddenOakLibsMount() {
            return false;
        }

        @Override
        public boolean hasPropertyIndexNode() {
            return false;
        }

        @Override
        public long getSuggestSizeInBytes() {
            return -1L;
        }

        @Override
        public long getCreationTimestamp() {
            return -1L;
        }

        @Override
        public long getReindexCompletionTimestamp() {
            return -1L;
        }
    }
}

