/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.privilege;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyBuilder;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.PostValidationHook;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeConstants;
import org.apache.jackrabbit.oak.spi.state.DefaultNodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;

class JcrAllCommitHook
implements PostValidationHook,
PrivilegeConstants {
    JcrAllCommitHook() {
    }

    @Override
    @NotNull
    public NodeState processCommit(NodeState before, NodeState after, CommitInfo info) {
        NodeBuilder builder = after.builder();
        after.compareAgainstBaseState(before, new PrivilegeDiff(builder));
        return builder.getNodeState();
    }

    public String toString() {
        return "JcrAllCommitHook";
    }

    private static final class PrivilegeDiff
    extends DefaultNodeStateDiff {
        private static final String ROOT_PATH = "";
        private final String path;
        private final NodeBuilder nodeBuilder;

        private PrivilegeDiff(@NotNull NodeBuilder nodeBuilder) {
            this.path = ROOT_PATH;
            this.nodeBuilder = nodeBuilder;
        }

        private PrivilegeDiff(@NotNull PrivilegeDiff parentDiff, @NotNull String nodeName, @NotNull NodeBuilder nodeBuilder) {
            this.path = parentDiff.path + '/' + nodeName;
            this.nodeBuilder = nodeBuilder;
        }

        @Override
        public boolean childNodeAdded(String name, NodeState after) {
            if ("/jcr:system/rep:privileges".equals(this.path)) {
                if (!"jcr:all".equals(name)) {
                    this.updateJcrAll(name, after);
                }
            } else {
                String p = this.path + '/' + name;
                if (Text.isDescendantOrEqual(p, "/jcr:system/rep:privileges")) {
                    EmptyNodeState.compareAgainstEmptyState(after, new PrivilegeDiff(this, name, this.nodeBuilder.child(name)));
                }
            }
            return true;
        }

        private void updateJcrAll(@NotNull String name, @NotNull NodeState after) {
            NodeBuilder jcrAll = this.nodeBuilder.child("jcr:all");
            PropertyState aggregates = jcrAll.getProperty("rep:aggregates");
            PropertyBuilder<String> propertyBuilder = aggregates == null ? PropertyBuilder.array(Type.NAME, "rep:aggregates") : PropertyBuilder.copy(Type.NAME, aggregates);
            if (!propertyBuilder.hasValue(name)) {
                propertyBuilder.addValue(name);
                jcrAll.setProperty(propertyBuilder.getPropertyState());
            }
            if (!after.hasProperty("rep:aggregates")) {
                PrivilegeBits bits = PrivilegeBits.getInstance(after.getProperty("rep:bits"));
                PrivilegeBits all = PrivilegeBits.getInstance(jcrAll.getProperty("rep:bits"));
                jcrAll.setProperty(PrivilegeBits.getInstance(all).add(bits).asPropertyState("rep:bits"));
            }
        }

        @Override
        public boolean childNodeChanged(String name, NodeState before, NodeState after) {
            if (ROOT_PATH.equals(this.path) || Text.isDescendant(this.path, "/jcr:system/rep:privileges")) {
                after.compareAgainstBaseState(before, new PrivilegeDiff(this, name, this.nodeBuilder.child(name)));
            }
            return true;
        }
    }
}

