/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import java.security.Principal;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Impersonation;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.security.user.AdminPrincipalImpl;
import org.apache.jackrabbit.oak.security.user.AuthorizableImpl;
import org.apache.jackrabbit.oak.security.user.CredentialsImpl;
import org.apache.jackrabbit.oak.security.user.ImpersonationImpl;
import org.apache.jackrabbit.oak.security.user.PasswordHistory;
import org.apache.jackrabbit.oak.security.user.TreeBasedPrincipal;
import org.apache.jackrabbit.oak.security.user.UserManagerImpl;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.UserIdCredentials;
import org.apache.jackrabbit.oak.spi.security.user.util.PasswordUtil;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class UserImpl
extends AuthorizableImpl
implements User {
    private final boolean isAdmin;
    private final PasswordHistory pwHistory;

    UserImpl(String id, Tree tree, UserManagerImpl userManager) throws RepositoryException {
        super(id, tree, userManager);
        this.isAdmin = UserUtil.isAdmin(userManager.getConfig(), id);
        this.pwHistory = new PasswordHistory(userManager.getConfig());
    }

    @Override
    void checkValidTree(@NotNull Tree tree) throws RepositoryException {
        if (!UserUtil.isType(tree, AuthorizableType.USER)) {
            throw new IllegalArgumentException("Invalid user node: node type rep:User expected.");
        }
    }

    @Override
    public boolean isGroup() {
        return false;
    }

    @Override
    @NotNull
    public Principal getPrincipal() throws RepositoryException {
        Tree userTree = this.getTree();
        String principalName = this.getPrincipalName();
        NamePathMapper npMapper = this.getUserManager().getNamePathMapper();
        if (this.isAdmin()) {
            return new AdminPrincipalImpl(principalName, userTree, npMapper);
        }
        return new TreeBasedPrincipal(principalName, userTree, npMapper);
    }

    @Override
    public boolean isAdmin() {
        return this.isAdmin;
    }

    @Override
    public boolean isSystemUser() {
        return false;
    }

    @Override
    @NotNull
    public Credentials getCredentials() {
        String pwHash = this.getPasswordHash();
        if (pwHash == null) {
            return new UserIdCredentials(this.getID());
        }
        return new CredentialsImpl(this.getID(), pwHash);
    }

    @Override
    @NotNull
    public Impersonation getImpersonation() {
        return new ImpersonationImpl(this);
    }

    @Override
    public void changePassword(@Nullable String password) throws RepositoryException {
        if (password == null) {
            throw new RepositoryException("Attempt to set 'null' password for user " + this.getID());
        }
        UserManagerImpl userManager = this.getUserManager();
        userManager.onPasswordChange(this, password);
        this.pwHistory.updatePasswordHistory(this.getTree(), password);
        userManager.setPassword(this.getTree(), this.getID(), password, false);
    }

    @Override
    public void changePassword(@Nullable String password, @NotNull String oldPassword) throws RepositoryException {
        String pwHash = this.getPasswordHash();
        if (!PasswordUtil.isSame(pwHash, oldPassword)) {
            throw new RepositoryException("Failed to change password: Old password does not match.");
        }
        this.changePassword(password);
    }

    @Override
    public void disable(@Nullable String reason) throws RepositoryException {
        if (this.isAdmin) {
            throw new RepositoryException("The administrator user cannot be disabled.");
        }
        this.getUserManager().onDisable(this, reason);
        Tree tree = this.getTree();
        if (reason == null) {
            if (tree.hasProperty("rep:disabled")) {
                tree.removeProperty("rep:disabled");
            }
        } else {
            tree.setProperty("rep:disabled", reason);
        }
    }

    @Override
    public boolean isDisabled() {
        return this.getTree().hasProperty("rep:disabled");
    }

    @Override
    @Nullable
    public String getDisabledReason() {
        PropertyState disabled = this.getTree().getProperty("rep:disabled");
        if (disabled != null) {
            return disabled.getValue(Type.STRING);
        }
        return null;
    }

    @Nullable
    private String getPasswordHash() {
        return TreeUtil.getString(this.getTree(), "rep:password");
    }
}

