/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob.datastore;

import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.oak.plugins.blob.SharedDataStore;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sling-mock-oak.com.google.common.base.Joiner;
import sling-mock-oak.com.google.common.base.Splitter;
import sling-mock-oak.com.google.common.collect.FluentIterable;
import sling-mock-oak.com.google.common.collect.Ordering;
import sling-mock-oak.com.google.common.collect.Sets;

public class SharedDataStoreUtils {
    public static boolean isShared(BlobStore blobStore) {
        return blobStore instanceof SharedDataStore && ((SharedDataStore)((Object)blobStore)).getType() == SharedDataStore.Type.SHARED;
    }

    public static DataRecord getEarliestRecord(List<DataRecord> recs) {
        return Ordering.natural().onResultOf(new sling-mock-oak.com.google.common.base.Function<DataRecord, Long>(){

            @Override
            @Nullable
            public Long apply(@NotNull DataRecord input) {
                return input.getLastModified();
            }
        }).min(recs);
    }

    public static Set<String> refsNotAvailableFromRepos(List<DataRecord> repos, List<DataRecord> refs) {
        return Sets.difference(FluentIterable.from(repos).uniqueIndex(new sling-mock-oak.com.google.common.base.Function<DataRecord, String>(){

            @Override
            @Nullable
            public String apply(@NotNull DataRecord input) {
                return SharedStoreRecordType.REPOSITORY.getIdFromName(input.getIdentifier().toString());
            }
        }).keySet(), FluentIterable.from(refs).index(new sling-mock-oak.com.google.common.base.Function<DataRecord, String>(){

            @Override
            @Nullable
            public String apply(@NotNull DataRecord input) {
                return SharedStoreRecordType.REFERENCES.getIdFromName(input.getIdentifier().toString());
            }
        }).keySet());
    }

    public static Set<String> refsNotOld(List<DataRecord> repos, List<DataRecord> refs, long referenceTime) {
        Set<String> qualifyingRefs = refs.stream().filter(dataRecord -> dataRecord.getLastModified() < referenceTime).collect(Collectors.groupingBy(input -> SharedStoreRecordType.MARKED_START_MARKER.getIdFromName(input.getIdentifier().toString()), Collectors.mapping(Function.identity(), Collectors.toList()))).keySet();
        Set<String> repoIds = repos.stream().map(dataRecord -> SharedStoreRecordType.REPOSITORY.getIdFromName(dataRecord.getIdentifier().toString())).collect(Collectors.toSet());
        repoIds.removeAll(qualifyingRefs);
        return repoIds;
    }

    public static enum SharedStoreRecordType {
        REFERENCES("references"),
        REPOSITORY("repository"),
        MARKED_START_MARKER("markedTimestamp"),
        BLOBREFERENCES("blob");

        private final String type;
        static final String DELIM = "-";

        private SharedStoreRecordType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public String getIdFromName(String name) {
            return Splitter.on("_").limit(2).splitToList(Splitter.on(DELIM).limit(2).splitToList(name).get(1)).get(0);
        }

        public String getNameFromId(String id) {
            return Joiner.on(DELIM).join(this.getType(), id, new Object[0]);
        }

        public String getNameFromIdPrefix(String id, String prefix) {
            return Joiner.on("_").join(Joiner.on(DELIM).join(this.getType(), id, new Object[0]), prefix, new Object[0]);
        }
    }
}

