/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.SinglePropertyState;
import org.apache.jackrabbit.oak.plugins.value.Conversions;
import org.jetbrains.annotations.NotNull;

public class DoublePropertyState
extends SinglePropertyState<Double> {
    private final double value;

    public DoublePropertyState(@NotNull String name, double value) {
        super(name);
        this.value = value;
    }

    public static PropertyState doubleProperty(@NotNull String name, double value) {
        return new DoublePropertyState(name, value);
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public Conversions.Converter getConverter() {
        return Conversions.convert(this.value);
    }

    @Override
    public Type<?> getType() {
        return Type.DOUBLE;
    }
}

