/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import java.util.Collections;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.AbstractPropertyState;
import org.jetbrains.annotations.NotNull;
import sling-mock-oak.com.google.common.base.Preconditions;

public abstract class EmptyPropertyState
extends AbstractPropertyState {
    private final String name;

    protected EmptyPropertyState(@NotNull String name) {
        this.name = Preconditions.checkNotNull(name);
    }

    public static PropertyState emptyProperty(String name, final Type<?> type) {
        if (!type.isArray()) {
            throw new IllegalArgumentException("Not an array type:" + type);
        }
        return new EmptyPropertyState(name){

            @Override
            public Type<?> getType() {
                return type;
            }
        };
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    @NotNull
    public <T> T getValue(Type<T> type) {
        Preconditions.checkState(type.isArray(), "Type must be an array type");
        return (T)Collections.emptyList();
    }

    @Override
    @NotNull
    public <T> T getValue(Type<T> type, int index) {
        throw new IndexOutOfBoundsException(String.valueOf(index));
    }

    @Override
    public long size() {
        throw new IllegalStateException("Not a single valued property");
    }

    @Override
    public long size(int index) {
        throw new IndexOutOfBoundsException(String.valueOf(index));
    }

    @Override
    public int count() {
        return 0;
    }
}

