/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.commons.iterator.RangeIteratorAdapter;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.security.user.AuthorizableIterator;
import org.apache.jackrabbit.oak.security.user.AuthorizableProperties;
import org.apache.jackrabbit.oak.security.user.AuthorizablePropertiesImpl;
import org.apache.jackrabbit.oak.security.user.GroupImpl;
import org.apache.jackrabbit.oak.security.user.MembershipProvider;
import org.apache.jackrabbit.oak.security.user.UserManagerImpl;
import org.apache.jackrabbit.oak.security.user.Utils;
import org.apache.jackrabbit.oak.security.user.monitor.UserMonitor;
import org.apache.jackrabbit.oak.spi.security.principal.EveryonePrincipal;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.UserConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sling-mock-oak.com.google.common.base.Stopwatch;
import sling-mock-oak.com.google.common.collect.ImmutableSet;
import sling-mock-oak.com.google.common.collect.Iterators;

abstract class AuthorizableImpl
implements Authorizable,
UserConstants {
    private static final Logger log = LoggerFactory.getLogger(AuthorizableImpl.class);
    private final String id;
    private final Tree tree;
    private final UserManagerImpl userManager;
    private String principalName;
    private AuthorizableProperties properties;
    private int hashCode;

    AuthorizableImpl(@NotNull String id, @NotNull Tree tree, @NotNull UserManagerImpl userManager) throws RepositoryException {
        this.checkValidTree(tree);
        this.id = id;
        this.tree = tree;
        this.userManager = userManager;
    }

    abstract void checkValidTree(@NotNull Tree var1) throws RepositoryException;

    static boolean isValidAuthorizableImpl(@NotNull Authorizable authorizable) {
        return authorizable instanceof AuthorizableImpl;
    }

    @Override
    @NotNull
    public String getID() {
        return this.id;
    }

    @Override
    @NotNull
    public Iterator<Group> declaredMemberOf() throws RepositoryException {
        return this.memberOfMonitored(false);
    }

    @Override
    @NotNull
    public Iterator<Group> memberOf() throws RepositoryException {
        return this.memberOfMonitored(true);
    }

    @Override
    public void remove() throws RepositoryException {
        if (!this.isGroup() && ((User)((Object)this)).isAdmin()) {
            throw new RepositoryException("The administrator cannot be removed.");
        }
        this.userManager.onRemove(this);
        this.getTree().remove();
    }

    @Override
    @NotNull
    public Iterator<String> getPropertyNames() throws RepositoryException {
        return this.getPropertyNames(".");
    }

    @Override
    @NotNull
    public Iterator<String> getPropertyNames(@NotNull String relPath) throws RepositoryException {
        return this.getAuthorizableProperties().getNames(relPath);
    }

    @Override
    public boolean hasProperty(@NotNull String relPath) throws RepositoryException {
        return this.getAuthorizableProperties().hasProperty(relPath);
    }

    @Override
    @Nullable
    public Value[] getProperty(@NotNull String relPath) throws RepositoryException {
        return this.getAuthorizableProperties().getProperty(relPath);
    }

    @Override
    public void setProperty(@NotNull String relPath, @Nullable Value value) throws RepositoryException {
        this.getAuthorizableProperties().setProperty(relPath, value);
    }

    @Override
    public void setProperty(@NotNull String relPath, @Nullable Value[] values) throws RepositoryException {
        this.getAuthorizableProperties().setProperty(relPath, values);
    }

    @Override
    public boolean removeProperty(@NotNull String relPath) throws RepositoryException {
        return this.getAuthorizableProperties().removeProperty(relPath);
    }

    @Override
    @NotNull
    public String getPath() {
        return this.userManager.getNamePathMapper().getJcrPath(this.getTree().getPath());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.isGroup() ? "group:" : "user:");
            sb.append(':');
            sb.append(this.id);
            sb.append('_');
            sb.append(this.userManager.hashCode());
            this.hashCode = sb.toString().hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AuthorizableImpl) {
            AuthorizableImpl otherAuth = (AuthorizableImpl)obj;
            return this.isGroup() == otherAuth.isGroup() && this.id.equals(otherAuth.id) && this.userManager.equals(otherAuth.userManager);
        }
        return false;
    }

    public String toString() {
        String typeStr = this.isGroup() ? "Group '" : "User '";
        return typeStr + this.id + '\'';
    }

    @NotNull
    Tree getTree() {
        if (this.tree.exists()) {
            return this.tree;
        }
        throw new IllegalStateException("Authorizable " + this.id + ": underlying tree has been disconnected.");
    }

    @Nullable
    String getPrincipalNameOrNull() {
        PropertyState pNameProp;
        if (this.principalName == null && (pNameProp = this.tree.getProperty("rep:principalName")) != null) {
            this.principalName = pNameProp.getValue(Type.STRING);
        }
        return this.principalName;
    }

    @NotNull
    String getPrincipalName() throws RepositoryException {
        String pName = this.getPrincipalNameOrNull();
        if (pName == null) {
            String msg = "Authorizable without principal name " + this.id;
            log.warn(msg);
            throw new RepositoryException(msg);
        }
        return pName;
    }

    @NotNull
    UserManagerImpl getUserManager() {
        return this.userManager;
    }

    @NotNull
    MembershipProvider getMembershipProvider() {
        return this.userManager.getMembershipProvider();
    }

    @NotNull
    UserMonitor getMonitor() {
        return this.userManager.getMonitor();
    }

    boolean isEveryone() {
        return Utils.isEveryone(this);
    }

    private AuthorizableProperties getAuthorizableProperties() {
        if (this.properties == null) {
            this.properties = new AuthorizablePropertiesImpl(this, this.userManager.getPartialValueFactory());
        }
        return this.properties;
    }

    @NotNull
    private Iterator<Group> memberOfMonitored(boolean includeInherited) throws RepositoryException {
        Stopwatch watch = Stopwatch.createStarted();
        Iterator<Group> groups = this.getMembership(includeInherited);
        this.getMonitor().doneMemberOf(watch.elapsed(TimeUnit.NANOSECONDS), !includeInherited);
        return groups;
    }

    @NotNull
    private Iterator<Group> getMembership(boolean includeInherited) throws RepositoryException {
        if (this.isEveryone()) {
            return Collections.emptySet().iterator();
        }
        MembershipProvider mMgr = this.getMembershipProvider();
        Iterator<String> oakPaths = mMgr.getMembership(this.getTree(), includeInherited);
        Authorizable everyoneGroup = this.userManager.getAuthorizable(EveryonePrincipal.getInstance());
        if (everyoneGroup instanceof GroupImpl) {
            String everyonePath = ((GroupImpl)everyoneGroup).getTree().getPath();
            oakPaths = Iterators.concat(oakPaths, ImmutableSet.of(everyonePath).iterator());
        }
        if (oakPaths.hasNext()) {
            AuthorizableIterator groups = AuthorizableIterator.create(oakPaths, this.userManager, AuthorizableType.GROUP);
            return new RangeIteratorAdapter(groups, groups.getSize());
        }
        return RangeIteratorAdapter.EMPTY;
    }
}

