/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.restriction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.security.AccessControlException;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.CompositePattern;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.Restriction;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinition;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionPattern;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sling-mock-oak.com.google.common.collect.Sets;

public final class CompositeRestrictionProvider
implements RestrictionProvider {
    private final RestrictionProvider[] providers;

    private CompositeRestrictionProvider(@NotNull Collection<? extends RestrictionProvider> providers) {
        this.providers = providers.toArray(new RestrictionProvider[0]);
    }

    public static RestrictionProvider newInstance(RestrictionProvider ... providers) {
        return CompositeRestrictionProvider.newInstance(Arrays.asList(providers));
    }

    public static RestrictionProvider newInstance(@NotNull Collection<? extends RestrictionProvider> providers) {
        switch (providers.size()) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                return providers.iterator().next();
            }
        }
        return new CompositeRestrictionProvider(providers);
    }

    @Override
    @NotNull
    public Set<RestrictionDefinition> getSupportedRestrictions(@Nullable String oakPath) {
        HashSet<RestrictionDefinition> defs = Sets.newHashSet();
        for (RestrictionProvider rp : this.providers) {
            defs.addAll(rp.getSupportedRestrictions(oakPath));
        }
        return defs;
    }

    @Override
    @NotNull
    public Restriction createRestriction(@Nullable String oakPath, @NotNull String oakName, @NotNull Value value) throws RepositoryException {
        return this.getProvider(oakPath, oakName).createRestriction(oakPath, oakName, value);
    }

    @Override
    @NotNull
    public Restriction createRestriction(@Nullable String oakPath, @NotNull String oakName, Value ... values) throws RepositoryException {
        return this.getProvider(oakPath, oakName).createRestriction(oakPath, oakName, values);
    }

    @Override
    @NotNull
    public Set<Restriction> readRestrictions(@Nullable String oakPath, @NotNull Tree aceTree) {
        HashSet<Restriction> restrictions = Sets.newHashSet();
        for (RestrictionProvider rp : this.providers) {
            restrictions.addAll(rp.readRestrictions(oakPath, aceTree));
        }
        return restrictions;
    }

    @Override
    public void writeRestrictions(@Nullable String oakPath, @NotNull Tree aceTree, @NotNull Set<Restriction> restrictions) throws RepositoryException {
        for (Restriction r : restrictions) {
            RestrictionProvider rp = this.getProvider(oakPath, CompositeRestrictionProvider.getName(r));
            rp.writeRestrictions(oakPath, aceTree, Collections.singleton(r));
        }
    }

    @Override
    public void validateRestrictions(@Nullable String oakPath, @NotNull Tree aceTree) throws RepositoryException {
        Map<String, RestrictionDefinition> supported = this.getSupported(oakPath);
        HashSet<String> rNames = new HashSet<String>();
        for (Restriction r : this.readRestrictions(oakPath, aceTree)) {
            String name = CompositeRestrictionProvider.getName(r);
            rNames.add(name);
            if (!supported.containsKey(name)) {
                throw new AccessControlException("Unsupported restriction: " + name + " at " + oakPath);
            }
            if (r.getDefinition().equals(supported.get(name))) continue;
            throw new AccessControlException("Invalid restriction: " + name + " at " + oakPath);
        }
        for (RestrictionDefinition def : supported.values()) {
            String defName = def.getName();
            if (CompositeRestrictionProvider.hasRestrictionProperty(aceTree, defName) && !rNames.contains(defName)) {
                throw new AccessControlException("Invalid restriction " + defName + " at " + oakPath);
            }
            if (!def.isMandatory() || rNames.contains(defName)) continue;
            throw new AccessControlException("Mandatory restriction " + defName + " is missing.");
        }
    }

    @Override
    @NotNull
    public RestrictionPattern getPattern(@Nullable String oakPath, @NotNull Tree tree) {
        return this.getPattern(oakPath, this.readRestrictions(oakPath, tree));
    }

    @Override
    @NotNull
    public RestrictionPattern getPattern(@Nullable String oakPath, @NotNull Set<Restriction> restrictions) {
        ArrayList<RestrictionPattern> patterns = new ArrayList<RestrictionPattern>();
        for (RestrictionProvider rp : this.providers) {
            RestrictionPattern pattern = rp.getPattern(oakPath, restrictions);
            if (pattern == RestrictionPattern.EMPTY) continue;
            patterns.add(pattern);
        }
        return CompositePattern.create(patterns);
    }

    @NotNull
    private RestrictionProvider getProvider(@Nullable String oakPath, @NotNull String oakName) throws AccessControlException {
        for (RestrictionProvider rp : this.providers) {
            for (RestrictionDefinition def : rp.getSupportedRestrictions(oakPath)) {
                if (!def.getName().equals(oakName)) continue;
                return rp;
            }
        }
        throw new AccessControlException("Unsupported restriction (path = " + oakPath + "; name = " + oakName + ')');
    }

    @NotNull
    private Map<String, RestrictionDefinition> getSupported(@Nullable String oakPath) {
        HashMap<String, RestrictionDefinition> supported = new HashMap<String, RestrictionDefinition>();
        for (RestrictionProvider rp : this.providers) {
            for (RestrictionDefinition rd : rp.getSupportedRestrictions(oakPath)) {
                supported.put(rd.getName(), rd);
            }
        }
        return supported;
    }

    private static boolean hasRestrictionProperty(@NotNull Tree aceTree, @NotNull String name) {
        if (aceTree.hasProperty(name)) {
            return true;
        }
        Tree restrictionTree = aceTree.getChild("rep:restrictions");
        return restrictionTree.exists() && restrictionTree.hasProperty(name);
    }

    @NotNull
    private static String getName(@NotNull Restriction restriction) {
        return restriction.getDefinition().getName();
    }
}

