/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AccessControlConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionAware;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAccessControlManager
implements JackrabbitAccessControlManager,
AccessControlConstants {
    private static final Logger log = LoggerFactory.getLogger(AbstractAccessControlManager.class);
    private final Root root;
    private final String workspaceName;
    private final NamePathMapper namePathMapper;
    private final AuthorizationConfiguration config;
    private final PrivilegeManager privilegeManager;
    private PermissionProvider permissionProvider;
    private boolean doRefresh = false;

    protected AbstractAccessControlManager(@NotNull Root root, @NotNull NamePathMapper namePathMapper, @NotNull SecurityProvider securityProvider) {
        this.root = root;
        this.workspaceName = root.getContentSession().getWorkspaceName();
        this.namePathMapper = namePathMapper;
        this.privilegeManager = securityProvider.getConfiguration(PrivilegeConfiguration.class).getPrivilegeManager(root, namePathMapper);
        this.config = securityProvider.getConfiguration(AuthorizationConfiguration.class);
    }

    @NotNull
    public Privilege[] getSupportedPrivileges(@Nullable String absPath) throws RepositoryException {
        this.getTree(this.getOakPath(absPath), 0L, false);
        return this.privilegeManager.getRegisteredPrivileges();
    }

    @NotNull
    public Privilege privilegeFromName(@NotNull String privilegeName) throws RepositoryException {
        return this.privilegeManager.getPrivilege(privilegeName);
    }

    public boolean hasPrivileges(@Nullable String absPath, @Nullable Privilege[] privileges) throws RepositoryException {
        return this.hasPrivileges(absPath, privileges, this.getPermissionProvider(), 0L, false);
    }

    @NotNull
    public Privilege[] getPrivileges(@Nullable String absPath) throws RepositoryException {
        return this.getPrivileges(absPath, this.getPermissionProvider(), 0L);
    }

    @Override
    public boolean hasPrivileges(@Nullable String absPath, @NotNull Set<Principal> principals, @Nullable Privilege[] privileges) throws RepositoryException {
        if (this.getPrincipals().equals(principals)) {
            return this.hasPrivileges(absPath, privileges);
        }
        PermissionProvider provider = this.config.getPermissionProvider(this.root, this.workspaceName, principals);
        return this.hasPrivileges(absPath, privileges, provider, 128L, false);
    }

    @Override
    @NotNull
    public Privilege[] getPrivileges(@Nullable String absPath, @NotNull Set<Principal> principals) throws RepositoryException {
        if (this.getPrincipals().equals(principals)) {
            return this.getPrivileges(absPath);
        }
        PermissionProvider provider = this.config.getPermissionProvider(this.root, this.workspaceName, principals);
        return this.getPrivileges(absPath, provider, 128L);
    }

    @NotNull
    protected AuthorizationConfiguration getConfig() {
        return this.config;
    }

    @NotNull
    protected Root getRoot() {
        return this.root;
    }

    @NotNull
    protected Root getLatestRoot() {
        return this.root.getContentSession().getLatestRoot();
    }

    @NotNull
    protected NamePathMapper getNamePathMapper() {
        return this.namePathMapper;
    }

    @NotNull
    protected PrivilegeManager getPrivilegeManager() {
        return this.privilegeManager;
    }

    @Nullable
    protected String getOakPath(@Nullable String jcrPath) throws RepositoryException {
        if (jcrPath == null) {
            return null;
        }
        String oakPath = this.namePathMapper.getOakPath(jcrPath);
        if (oakPath == null || !PathUtils.isAbsolute(oakPath)) {
            throw new RepositoryException("Failed to resolve JCR path " + jcrPath);
        }
        return oakPath;
    }

    @NotNull
    protected Tree getTree(@Nullable String oakPath, long permissions, boolean checkAcContent) throws RepositoryException {
        Tree tree;
        Tree tree2 = tree = oakPath == null ? this.root.getTree("/") : this.root.getTree(oakPath);
        if (!tree.exists()) {
            throw new PathNotFoundException("No tree at " + oakPath);
        }
        if (permissions != 0L) {
            this.checkPermissions(oakPath == null ? null : tree, permissions);
        }
        if (checkAcContent && this.config.getContext().definesTree(tree)) {
            throw new AccessControlException("Tree " + tree.getPath() + " defines access control content.");
        }
        return tree;
    }

    @NotNull
    protected PermissionProvider getPermissionProvider() {
        if (this.permissionProvider == null) {
            if (this.root instanceof PermissionAware) {
                this.permissionProvider = ((PermissionAware)((Object)this.root)).getPermissionProvider();
            } else {
                this.permissionProvider = this.config.getPermissionProvider(this.root, this.workspaceName, this.getPrincipals());
                this.doRefresh = true;
            }
        } else if (this.doRefresh) {
            this.permissionProvider.refresh();
        }
        return this.permissionProvider;
    }

    @NotNull
    private Set<Principal> getPrincipals() {
        return this.root.getContentSession().getAuthInfo().getPrincipals();
    }

    private void checkPermissions(@Nullable Tree tree, long permissions) throws AccessDeniedException {
        boolean isGranted = tree == null ? this.getPermissionProvider().getRepositoryPermission().isGranted(permissions) : this.getPermissionProvider().isGranted(tree, null, permissions);
        if (!isGranted) {
            throw new AccessDeniedException("Access denied.");
        }
    }

    @NotNull
    private Privilege[] getPrivileges(@Nullable String absPath, @NotNull PermissionProvider provider, long permissions) throws RepositoryException {
        Set<String> pNames;
        Tree tree;
        if (absPath == null) {
            tree = null;
            if (permissions != 0L) {
                this.checkPermissions(null, permissions);
            }
        } else {
            tree = this.getTree(this.getOakPath(absPath), permissions, false);
        }
        if ((pNames = provider.getPrivileges(tree)).isEmpty()) {
            return new Privilege[0];
        }
        HashSet<Privilege> privileges = new HashSet<Privilege>(pNames.size());
        for (String name : pNames) {
            privileges.add(this.privilegeManager.getPrivilege(this.namePathMapper.getJcrName(name)));
        }
        return privileges.toArray(new Privilege[0]);
    }

    private boolean hasPrivileges(@Nullable String absPath, @Nullable Privilege[] privileges, @NotNull PermissionProvider provider, long permissions, boolean checkAcContent) throws RepositoryException {
        Tree tree;
        if (absPath == null) {
            tree = null;
            if (permissions != 0L) {
                this.checkPermissions(null, permissions);
            }
        } else {
            tree = this.getTree(this.getOakPath(absPath), permissions, checkAcContent);
        }
        if (privileges == null || privileges.length == 0) {
            log.debug("No privileges passed -> allowed.");
            return true;
        }
        HashSet<String> privilegeNames = new HashSet<String>(privileges.length);
        for (Privilege privilege : privileges) {
            privilegeNames.add(this.namePathMapper.getOakName(privilege.getName()));
        }
        return provider.hasPrivileges(tree, privilegeNames.toArray(new String[0]));
    }
}

