/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.inventory;

import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.felix.inventory.Format;
import org.apache.felix.inventory.InventoryPrinter;
import org.apache.jackrabbit.oak.api.jmx.IndexStatsMBean;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.plugins.index.AsyncIndexInfo;
import org.apache.jackrabbit.oak.plugins.index.AsyncIndexInfoService;
import org.apache.jackrabbit.oak.plugins.index.IndexInfo;
import org.apache.jackrabbit.oak.plugins.index.IndexInfoService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import sling-mock-oak.com.google.common.base.Preconditions;
import sling-mock-oak.com.google.common.base.Strings;
import sling-mock-oak.com.google.common.collect.ImmutableList;

@Component(service={InventoryPrinter.class}, property={"felix.inventory.printer.name=oak-index-stats", "felix.inventory.printer.title=Oak Index Stats", "felix.inventory.printer.format=TEXT", "felix.inventory.printer.format=JSON"})
public class IndexPrinter
implements InventoryPrinter {
    @Reference
    private IndexInfoService indexInfoService;
    @Reference
    private AsyncIndexInfoService asyncIndexInfoService;

    public IndexPrinter() {
    }

    public IndexPrinter(IndexInfoService indexInfoService, AsyncIndexInfoService asyncIndexInfoService) {
        this.indexInfoService = Preconditions.checkNotNull(indexInfoService);
        this.asyncIndexInfoService = Preconditions.checkNotNull(asyncIndexInfoService);
    }

    public void print(PrintWriter pw, Format format, boolean isZip) {
        PrinterOutput po = format == Format.JSON ? new JsonPrinterOutput() : new TextPrinterOutput();
        this.asyncLanesInfo(po);
        this.indexInfo(po);
        pw.print(po.output());
    }

    private void asyncLanesInfo(PrinterOutput po) {
        ImmutableList<String> asyncLanes = ImmutableList.copyOf(this.asyncIndexInfoService.getAsyncLanes());
        po.startSection("Async Indexers State", true);
        po.text("Number of async indexer lanes", asyncLanes.size());
        for (String lane : asyncLanes) {
            po.startSection(lane, false);
            AsyncIndexInfo info = this.asyncIndexInfoService.getInfo(lane);
            if (info != null) {
                po.text("Last indexed to", IndexPrinter.formatTime(info.getLastIndexedTo()));
                IndexStatsMBean stats = info.getStatsMBean();
                if (stats != null) {
                    po.text("Status", stats.getStatus());
                    po.text("Failing", stats.isFailing());
                    po.text("Paused", stats.isPaused());
                    if (stats.isFailing()) {
                        po.text("Failing since", stats.getFailingSince());
                        po.text("Latest error", stats.getLatestError());
                    }
                }
            }
            po.endSection();
        }
        po.endSection();
    }

    private void indexInfo(PrinterOutput po) {
        Map<String, List<IndexInfo>> indexesByType = StreamSupport.stream(this.indexInfoService.getAllIndexInfo().spliterator(), false).collect(Collectors.groupingBy(IndexInfo::getType));
        po.text("Total number of indexes", indexesByType.values().stream().mapToInt(List::size).sum());
        for (String type : indexesByType.keySet()) {
            List<IndexInfo> typedInfo = indexesByType.get(type);
            po.startSection(type, true);
            po.text("Number of " + type + " indexes", typedInfo.size());
            for (IndexInfo info : typedInfo) {
                this.indexInfo(po, info);
            }
            po.endSection();
        }
    }

    private void indexInfo(PrinterOutput po, IndexInfo info) {
        String diff;
        po.startSection(info.getIndexPath(), false);
        po.text("Type", info.getType());
        if (info.getAsyncLaneName() != null) {
            po.text("Async", true);
            po.text("Async lane name", info.getAsyncLaneName());
        }
        if (info.getIndexedUpToTime() > 0L) {
            po.text("Last indexed up to", IndexPrinter.formatTime(info.getIndexedUpToTime()));
        }
        if (info.getLastUpdatedTime() > 0L) {
            po.text("Last updated time", IndexPrinter.formatTime(info.getLastUpdatedTime()));
        }
        if (info.getCreationTimestamp() > 0L) {
            po.text("Creation time", IndexPrinter.formatTime(info.getCreationTimestamp()));
        }
        if (info.getReindexCompletionTimestamp() > 0L) {
            po.text("Reindex completion time", IndexPrinter.formatTime(info.getReindexCompletionTimestamp()));
        }
        if (info.getSizeInBytes() >= 0L) {
            po.text("Size", IOUtils.humanReadableByteCount(info.getSizeInBytes()));
            po.text("Size (in bytes)", info.getSizeInBytes());
        }
        if (info.getSuggestSizeInBytes() >= 0L) {
            po.text("Suggest size", IOUtils.humanReadableByteCount(info.getSuggestSizeInBytes()));
            po.text("Suggest size (in bytes)", info.getSuggestSizeInBytes());
        }
        if (info.getEstimatedEntryCount() >= 0L) {
            po.text("Estimated entry count", info.getEstimatedEntryCount());
        }
        if ("lucene".equals(info.getType())) {
            po.text("Has hidden oak mount", info.hasHiddenOakLibsMount());
            po.text("Has property index", info.hasPropertyIndexNode());
        }
        if (info.hasIndexDefinitionChangedWithoutReindexing() && (diff = info.getIndexDefinitionDiff()) != null) {
            po.text("Index definition changed without reindexing", diff);
        }
        po.endSection();
    }

    private static String formatTime(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        Date date = cal.getTime();
        SimpleDateFormat outputFmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        outputFmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        return outputFmt.format(date);
    }

    private static class TextPrinterOutput
    extends PrinterOutput {
        private final StringBuilder sb = new StringBuilder();
        private int leftPadding = 0;

        @Override
        String output() {
            return this.sb.toString();
        }

        @Override
        void startSection(String section, boolean topLevel) {
            this.newLine();
            this.appendLine(section);
            if (topLevel) {
                this.appendLine(Strings.repeat("=", section.length()));
                this.newLine();
            } else {
                this.leftPadding += 4;
            }
        }

        @Override
        void endSection() {
            if (this.leftPadding >= 4) {
                this.leftPadding -= 4;
            }
        }

        @Override
        void text(String key, Object value) {
            this.appendLine(key, value);
        }

        private void appendLine(String text) {
            this.sb.append(text).append(System.lineSeparator());
        }

        private void appendLine(String key, Object value) {
            String leftPaddedKey = this.leftPadding > 0 ? String.format("%" + this.leftPadding + "s", key) : key;
            this.sb.append(String.format("%-29s", leftPaddedKey)).append(":").append(value).append(System.lineSeparator());
        }

        private void newLine() {
            this.sb.append(System.lineSeparator());
        }
    }

    private static class JsonPrinterOutput
    extends PrinterOutput {
        private final JsopBuilder json = new JsopBuilder().object();

        @Override
        String output() {
            return JsopBuilder.prettyPrint(this.json.endObject().toString());
        }

        @Override
        void startSection(String section, boolean topLevel) {
            this.json.key(section);
            this.json.object();
        }

        @Override
        void endSection() {
            this.json.endObject();
        }

        @Override
        void text(String key, Object value) {
            this.json.key(key);
            if (value instanceof String) {
                this.json.value((String)value);
            } else if (value instanceof Long) {
                this.json.value((Long)value);
            } else if (value instanceof Boolean) {
                this.json.value((Boolean)value);
            } else if (value instanceof Integer) {
                this.json.value(((Integer)value).intValue());
            } else {
                throw new IllegalArgumentException("Unsupported type of value while creating the json output");
            }
        }
    }

    private static abstract class PrinterOutput {
        private PrinterOutput() {
        }

        abstract String output();

        abstract void startSection(String var1, boolean var2);

        void endSection() {
        }

        abstract void text(String var1, Object var2);
    }
}

