/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.api.ResultRow;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.PropertyValues;
import org.apache.jackrabbit.oak.query.ExecutionContext;
import org.apache.jackrabbit.oak.query.FilterIterators;
import org.apache.jackrabbit.oak.query.Query;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.query.QueryImpl;
import org.apache.jackrabbit.oak.query.QueryOptions;
import org.apache.jackrabbit.oak.query.ResultImpl;
import org.apache.jackrabbit.oak.query.ResultRowImpl;
import org.apache.jackrabbit.oak.query.ast.ColumnImpl;
import org.apache.jackrabbit.oak.query.ast.OrderingImpl;
import org.apache.jackrabbit.oak.query.facet.FacetResult;
import org.apache.jackrabbit.oak.query.stats.QueryStatsData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sling-mock-oak.com.google.common.collect.AbstractIterator;
import sling-mock-oak.com.google.common.collect.ImmutableList;
import sling-mock-oak.com.google.common.collect.Iterators;
import sling-mock-oak.com.google.common.collect.Maps;
import sling-mock-oak.com.google.common.collect.PeekingIterator;
import sling-mock-oak.com.google.common.collect.UnmodifiableIterator;

public class UnionQueryImpl
implements Query {
    private static final Logger LOG = LoggerFactory.getLogger(UnionQueryImpl.class);
    private final boolean unionAll;
    private final Query left;
    private final Query right;
    private ColumnImpl[] columns;
    private OrderingImpl[] orderings;
    private boolean explain;
    private boolean measure;
    private Optional<Long> limit = Optional.empty();
    private Optional<Long> offset = Optional.empty();
    private long size = -1L;
    private final QueryEngineSettings settings;
    private boolean isInternal;

    UnionQueryImpl(boolean unionAll, Query left, Query right, QueryEngineSettings settings) {
        this.unionAll = unionAll;
        this.left = left;
        this.right = right;
        this.settings = settings;
    }

    @Override
    public void setExecutionContext(ExecutionContext context) {
        this.left.setExecutionContext(context);
        this.right.setExecutionContext(context);
    }

    @Override
    public void setOrderings(OrderingImpl[] orderings) {
        if (orderings == null) {
            this.left.setOrderings(null);
            this.right.setOrderings(null);
            return;
        }
        OrderingImpl[] l = new OrderingImpl[orderings.length];
        OrderingImpl[] r = new OrderingImpl[orderings.length];
        for (int i = 0; i < orderings.length; ++i) {
            OrderingImpl o = orderings[i];
            l[i] = o.createCopy();
            r[i] = o.createCopy();
        }
        this.left.setOrderings(l);
        this.right.setOrderings(r);
        this.orderings = orderings;
    }

    @Override
    public void setLimit(long limit) {
        this.limit = Optional.of(limit);
        this.applyLimitOffset();
    }

    @Override
    public void setOffset(long offset) {
        this.offset = Optional.of(offset);
        this.applyLimitOffset();
    }

    private void applyLimitOffset() {
        long subqueryLimit = QueryImpl.saturatedAdd(this.limit.orElse(Long.MAX_VALUE), this.offset.orElse(0L));
        this.left.setLimit(subqueryLimit);
        this.right.setLimit(subqueryLimit);
    }

    @Override
    public void bindValue(String key, PropertyValue value) {
        this.left.bindValue(key, value);
        this.right.bindValue(key, value);
    }

    @Override
    public void setTraversalEnabled(boolean traversal) {
        this.left.setTraversalEnabled(traversal);
        this.right.setTraversalEnabled(traversal);
    }

    @Override
    public void setQueryOptions(QueryOptions options) {
        this.left.setQueryOptions(options);
        this.right.setQueryOptions(options);
    }

    @Override
    public void prepare() {
        this.left.prepare();
        this.right.prepare();
    }

    @Override
    public double getEstimatedCost() {
        return 10.0 + this.left.getEstimatedCost() + this.right.getEstimatedCost();
    }

    @Override
    public List<String> getBindVariableNames() {
        HashSet<String> set = new HashSet<String>();
        set.addAll(this.left.getBindVariableNames());
        set.addAll(this.right.getBindVariableNames());
        return new ArrayList<String>(set);
    }

    @Override
    public ColumnImpl[] getColumns() {
        if (this.columns != null) {
            return this.columns;
        }
        return this.left.getColumns();
    }

    @Override
    public String[] getSelectorNames() {
        return this.left.getSelectorNames();
    }

    @Override
    public int getSelectorIndex(String selectorName) {
        return this.left.getSelectorIndex(selectorName);
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getSize(Result.SizePrecision precision, long max) {
        long localLimit = this.limit.orElse(Long.MAX_VALUE);
        long a = this.left.getSize(precision, max);
        if (a < 0L) {
            return -1L;
        }
        if (a >= localLimit) {
            return localLimit;
        }
        long b = this.right.getSize(precision, max);
        if (b < 0L) {
            return -1L;
        }
        long total = QueryImpl.saturatedAdd(a, b);
        return Math.min(localLimit, total);
    }

    @Override
    public void setExplain(boolean explain) {
        this.explain = explain;
    }

    @Override
    public void setMeasure(boolean measure) {
        this.left.setMeasure(measure);
        this.right.setMeasure(measure);
        this.measure = measure;
    }

    @Override
    public void init() {
        this.left.init();
        this.right.init();
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.left.toString());
        buff.append(" union ");
        if (this.unionAll) {
            buff.append("all ");
        }
        buff.append(this.right.toString());
        if (this.orderings != null) {
            buff.append(" order by ");
            int i = 0;
            for (OrderingImpl o : this.orderings) {
                if (i++ > 0) {
                    buff.append(", ");
                }
                buff.append(o);
            }
        }
        return buff.toString();
    }

    @Override
    public Result executeQuery() {
        return new ResultImpl(this);
    }

    @Override
    public String getPlan() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.left.getPlan());
        buff.append(" union ");
        if (this.unionAll) {
            buff.append("all ");
        }
        buff.append(this.right.getPlan());
        return buff.toString();
    }

    @Override
    public String getIndexCostInfo() {
        StringBuilder buff = new StringBuilder();
        buff.append("{ ");
        buff.append(this.left.getIndexCostInfo());
        buff.append(", ");
        buff.append(this.right.getIndexCostInfo());
        buff.append(" }");
        return buff.toString();
    }

    @Override
    public Tree getTree(String path) {
        return this.left.getTree(path);
    }

    @Override
    public boolean isMeasureOrExplainEnabled() {
        return this.explain || this.measure;
    }

    @Override
    public int getColumnIndex(String columnName) {
        if (this.columns == null) {
            this.columns = this.left.getColumns();
        }
        return QueryImpl.getColumnIndex(this.columns, columnName);
    }

    @Override
    public Iterator<ResultRowImpl> getRows() {
        this.prepare();
        if (this.explain) {
            String plan = this.getPlan();
            this.columns = new ColumnImpl[]{new ColumnImpl("explain", "plan", "plan"), new ColumnImpl("explain", "statement", "statement")};
            ResultRowImpl r = new ResultRowImpl(this, Tree.EMPTY_ARRAY, new PropertyValue[]{PropertyValues.newString(plan), PropertyValues.newString(this.left.getStatement().replaceFirst("(?i)\\bexplain\\s+", ""))}, null, null);
            return Arrays.asList(r).iterator();
        }
        if (LOG.isDebugEnabled()) {
            if (this.isInternal) {
                LOG.trace("query union plan {}", (Object)this.getPlan());
            } else {
                LOG.debug("query union plan {}", (Object)this.getPlan());
            }
        }
        boolean distinct = !this.unionAll;
        Comparator<ResultRowImpl> orderBy = ResultRowImpl.getComparator(this.orderings);
        FacetMerger facetMerger = new FacetMerger(this.left, this.right);
        final Iterator<ResultRowImpl> leftRows = facetMerger.getLeftIterator();
        final Iterator<ResultRowImpl> rightRows = facetMerger.getRightIterator();
        Iterator<ResultRowImpl> leftIter = leftRows;
        Iterator<ResultRowImpl> rightIter = rightRows;
        if (this.measure) {
            leftIter = ((QueryImpl.MeasuringIterator)leftRows).getDelegate();
            rightIter = ((QueryImpl.MeasuringIterator)rightRows).getDelegate();
        }
        UnmodifiableIterator it = orderBy == null ? Iterators.concat(leftIter, rightIter) : Iterators.mergeSorted(ImmutableList.of(leftIter, rightIter), orderBy);
        it = FilterIterators.newCombinedFilter(it, distinct, this.limit.orElse(Long.MAX_VALUE), this.offset.orElse(0L), null, this.settings);
        if (this.measure) {
            it = new QueryImpl.MeasuringIterator(this, it){
                QueryImpl.MeasuringIterator left;
                QueryImpl.MeasuringIterator right;
                {
                    super(query, delegate);
                    this.left = (QueryImpl.MeasuringIterator)leftRows;
                    this.right = (QueryImpl.MeasuringIterator)rightRows;
                }

                @Override
                protected void setColumns(ColumnImpl[] cols) {
                    UnionQueryImpl.access$002(UnionQueryImpl.this, cols);
                    this.left.setColumns(cols);
                    this.right.setColumns(cols);
                }

                @Override
                protected Map<String, Long> getSelectorScanCount() {
                    Map<String, Long> leftSelectorScan = this.left.getSelectorScanCount();
                    Map<String, Long> rightSelectorScan = this.right.getSelectorScanCount();
                    HashMap<String, Long> unionScan = Maps.newHashMap(leftSelectorScan);
                    for (String key : rightSelectorScan.keySet()) {
                        if (unionScan.containsKey(key)) {
                            unionScan.put(key, rightSelectorScan.get(key) + (Long)unionScan.get(key));
                            continue;
                        }
                        unionScan.put(key, rightSelectorScan.get(key));
                    }
                    return unionScan;
                }

                @Override
                protected long getReadCount() {
                    return this.left.getReadCount() + this.right.getReadCount();
                }
            };
        }
        return it;
    }

    @Override
    public void setInternal(boolean isInternal) {
        this.isInternal = isInternal;
    }

    @Override
    public boolean isSortedByIndex() {
        return this.left.isSortedByIndex() && this.right.isSortedByIndex();
    }

    @Override
    public Query buildAlternativeQuery() {
        return this;
    }

    @Override
    public Query copyOf() throws IllegalStateException {
        return null;
    }

    @Override
    public boolean isInit() {
        return this.left.isInit() || this.right.isInit();
    }

    @Override
    public String getStatement() {
        return this.toString();
    }

    @Override
    public boolean isInternal() {
        return this.left.isInternal() || this.right.isInternal();
    }

    @Override
    public boolean containsUnfilteredFullTextCondition() {
        return this.left.containsUnfilteredFullTextCondition() || this.right.containsUnfilteredFullTextCondition();
    }

    @Override
    public boolean isPotentiallySlow() {
        return this.left.isPotentiallySlow() || this.right.isPotentiallySlow();
    }

    @Override
    public void verifyNotPotentiallySlow() {
        this.left.verifyNotPotentiallySlow();
        this.right.verifyNotPotentiallySlow();
    }

    public Query[] getChildren() {
        return new Query[]{this.left, this.right};
    }

    @Override
    public QueryStatsData.QueryExecutionStats getQueryExecutionStats() {
        return this.left.getQueryExecutionStats();
    }

    @Override
    public Optional<Long> getLimit() {
        return this.limit;
    }

    @Override
    public Optional<Long> getOffset() {
        return this.offset;
    }

    static /* synthetic */ ColumnImpl[] access$002(UnionQueryImpl x0, ColumnImpl[] x1) {
        x0.columns = x1;
        return x1;
    }

    static class MappingRowIterator
    extends AbstractIterator<ResultRowImpl> {
        private final Map<String, String> columnToFacetMap;
        private final Iterator<ResultRowImpl> delegate;

        MappingRowIterator(Map<String, String> columnToFacetMap, Iterator<ResultRowImpl> delegate) {
            this.columnToFacetMap = columnToFacetMap;
            this.delegate = delegate;
        }

        @Override
        protected ResultRowImpl computeNext() {
            if (this.delegate.hasNext()) {
                return ResultRowImpl.getMappingResultRow(this.delegate.next(), this.columnToFacetMap);
            }
            return (ResultRowImpl)this.endOfData();
        }
    }

    static class FacetMerger {
        private final Iterator<ResultRowImpl> leftIterator;
        private final Iterator<ResultRowImpl> rightIterator;

        FacetMerger(Query left, Query right) {
            ColumnImpl[] columns = left.getColumns();
            String[] columnNames = new String[columns.length];
            Arrays.setAll(columnNames, i -> columns[i].getColumnName());
            Iterator<ResultRowImpl> lIter = left.getRows();
            Iterator<ResultRowImpl> rIter = right.getRows();
            if (!this.hasFacets(columnNames) || !this.bothHaveRows(lIter, rIter)) {
                this.leftIterator = lIter;
                this.rightIterator = rIter;
                return;
            }
            PeekingIterator<ResultRowImpl> lPeekIter = Iterators.peekingIterator(lIter);
            PeekingIterator<ResultRowImpl> rPeekIter = Iterators.peekingIterator(rIter);
            ResultRow lRow = lPeekIter.peek();
            ResultRow rRow = rPeekIter.peek();
            FacetResult facetResult = new FacetResult(columnNames, columnName -> {
                PropertyValue value = lRow.getValue(columnName);
                return value == null ? null : value.getValue(Type.STRING);
            }, columnName -> {
                PropertyValue value = rRow.getValue(columnName);
                return value == null ? null : value.getValue(Type.STRING);
            });
            Map<String, String> columnToFacetMap = facetResult.asColumnToFacetJsonMap();
            this.leftIterator = new MappingRowIterator(columnToFacetMap, lPeekIter);
            this.rightIterator = new MappingRowIterator(columnToFacetMap, rPeekIter);
        }

        Iterator<ResultRowImpl> getLeftIterator() {
            return this.leftIterator;
        }

        Iterator<ResultRowImpl> getRightIterator() {
            return this.rightIterator;
        }

        private boolean hasFacets(String[] columnNames) {
            for (String c : columnNames) {
                if (!c.startsWith("rep:facet(")) continue;
                return true;
            }
            return false;
        }

        private boolean bothHaveRows(Iterator<ResultRowImpl> lIter, Iterator<ResultRowImpl> rIter) {
            return lIter.hasNext() && rIter.hasNext();
        }
    }
}

