/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query;

import java.net.URI;
import javax.jcr.PropertyType;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.memory.PropertyValues;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueConverter {
    private static final Logger log = LoggerFactory.getLogger(ValueConverter.class);

    private ValueConverter() {
    }

    public static boolean canConvert(int sourceType, int targetType) {
        if (sourceType == targetType || sourceType == 0 || targetType == 0) {
            return true;
        }
        switch (targetType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 12: {
                return true;
            }
            case 7: 
            case 8: 
            case 11: {
                switch (sourceType) {
                    case 7: 
                    case 8: 
                    case 11: {
                        return true;
                    }
                }
                break;
            }
            case 9: 
            case 10: {
                switch (sourceType) {
                    case 9: 
                    case 10: {
                        return true;
                    }
                }
            }
        }
        return sourceType == 1 || sourceType == 2;
    }

    public static PropertyValue convert(@NotNull PropertyValue value, int targetType, @Nullable NamePathMapper mapper) {
        int sourceType = value.getType().tag();
        if (sourceType == targetType) {
            return value;
        }
        switch (targetType) {
            case 2: {
                Blob blob = value.getValue(Type.BINARY);
                return PropertyValues.newBinary(blob);
            }
            case 6: {
                return PropertyValues.newBoolean(value.getValue(Type.BOOLEAN));
            }
            case 5: {
                return PropertyValues.newDate(value.getValue(Type.DATE));
            }
            case 4: {
                return PropertyValues.newDouble(value.getValue(Type.DOUBLE));
            }
            case 3: {
                return PropertyValues.newLong(value.getValue(Type.LONG));
            }
            case 12: {
                return PropertyValues.newDecimal(value.getValue(Type.DECIMAL));
            }
        }
        String v = value.getValue(Type.STRING);
        switch (targetType) {
            case 1: {
                return PropertyValues.newString(v);
            }
            case 8: {
                switch (sourceType) {
                    case 1: 
                    case 2: 
                    case 7: {
                        return PropertyValues.newPath(v);
                    }
                    case 11: {
                        URI uri = URI.create(v);
                        if (uri.isAbsolute()) {
                            throw new IllegalArgumentException("Failed to convert URI " + v + " to PATH");
                        }
                        String p = uri.getPath();
                        if (p.startsWith("./")) {
                            p = p.substring(2);
                        }
                        return PropertyValues.newPath(v);
                    }
                }
                break;
            }
            case 7: {
                switch (sourceType) {
                    case 1: 
                    case 2: 
                    case 8: {
                        return PropertyValues.newName(ValueConverter.getOakPath(v, mapper));
                    }
                    case 11: {
                        URI uri = URI.create(v);
                        if (uri.isAbsolute()) {
                            throw new IllegalArgumentException("Failed to convert URI " + v + " to PATH");
                        }
                        String p = uri.getPath();
                        if (p.startsWith("./")) {
                            p = p.substring(2);
                        }
                        return PropertyValues.newName(ValueConverter.getOakPath(v, mapper));
                    }
                }
                break;
            }
            case 9: {
                switch (sourceType) {
                    case 1: 
                    case 2: 
                    case 10: {
                        return PropertyValues.newReference(v);
                    }
                }
                break;
            }
            case 10: {
                switch (sourceType) {
                    case 1: 
                    case 2: 
                    case 9: {
                        return PropertyValues.newWeakReference(v);
                    }
                }
                break;
            }
            case 11: {
                switch (sourceType) {
                    case 1: 
                    case 2: {
                        return PropertyValues.newUri(v);
                    }
                    case 7: {
                        return PropertyValues.newUri("./" + v);
                    }
                    case 8: {
                        return PropertyValues.newUri("./" + v);
                    }
                }
            }
        }
        throw new IllegalArgumentException("Unsupported conversion from property type " + PropertyType.nameFromValue((int)sourceType) + " to property type " + PropertyType.nameFromValue((int)targetType));
    }

    private static String getOakPath(@NotNull String jcrPath, @Nullable NamePathMapper mapper) {
        if (mapper == null) {
            return jcrPath;
        }
        String p = mapper.getOakPath(jcrPath);
        if (p == null) {
            throw new IllegalArgumentException("Not a valid JCR path: " + jcrPath);
        }
        return p;
    }
}

