/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.principal;

import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.principal.ItemBasedPrincipal;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.Query;
import org.apache.jackrabbit.api.security.user.QueryBuilder;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.security.principal.EveryoneFilter;
import org.apache.jackrabbit.oak.spi.security.principal.EveryonePrincipal;
import org.apache.jackrabbit.oak.spi.security.principal.GroupPrincipals;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalProvider;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sling-mock-oak.com.google.common.base.Function;
import sling-mock-oak.com.google.common.collect.Iterators;
import sling-mock-oak.com.google.common.collect.UnmodifiableIterator;

class PrincipalProviderImpl
implements PrincipalProvider {
    private static final Logger log = LoggerFactory.getLogger(PrincipalProviderImpl.class);
    private final UserManager userManager;
    private final NamePathMapper namePathMapper;

    PrincipalProviderImpl(@NotNull Root root, @NotNull UserConfiguration userConfiguration, @NotNull NamePathMapper namePathMapper) {
        this.userManager = userConfiguration.getUserManager(root, namePathMapper);
        this.namePathMapper = namePathMapper;
    }

    @Override
    @Nullable
    public Principal getPrincipal(@NotNull String principalName) {
        Authorizable authorizable = this.getAuthorizable(new PrincipalImpl(principalName));
        if (authorizable != null) {
            try {
                return authorizable.getPrincipal();
            }
            catch (RepositoryException e) {
                log.debug(e.getMessage());
            }
        }
        return "everyone".equals(principalName) ? EveryonePrincipal.getInstance() : null;
    }

    @Override
    @Nullable
    public ItemBasedPrincipal getItemBasedPrincipal(@NotNull String principalOakPath) {
        try {
            Principal principal;
            Authorizable authorizable = this.userManager.getAuthorizableByPath(this.namePathMapper.getJcrPath(principalOakPath));
            if (authorizable != null && (principal = authorizable.getPrincipal()) instanceof ItemBasedPrincipal) {
                return (ItemBasedPrincipal)principal;
            }
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage());
        }
        return null;
    }

    @Override
    @NotNull
    public Set<Principal> getMembershipPrincipals(@NotNull Principal principal) {
        Authorizable authorizable = this.getAuthorizable(principal);
        if (authorizable == null) {
            return Collections.emptySet();
        }
        return PrincipalProviderImpl.getGroupMembership(authorizable);
    }

    @Override
    @NotNull
    public Set<? extends Principal> getPrincipals(@NotNull String userID) {
        HashSet<Principal> principals = new HashSet<Principal>();
        try {
            Authorizable authorizable = this.userManager.getAuthorizable(userID);
            if (authorizable != null && !authorizable.isGroup()) {
                principals.add(authorizable.getPrincipal());
                principals.addAll(PrincipalProviderImpl.getGroupMembership(authorizable));
            }
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage());
        }
        return principals;
    }

    @Override
    @NotNull
    public Iterator<? extends Principal> findPrincipals(@Nullable String nameHint, int searchType) {
        return this.findPrincipals(nameHint, false, searchType, 0L, -1L);
    }

    @Override
    @NotNull
    public Iterator<? extends Principal> findPrincipals(@Nullable String nameHint, boolean fullText, int searchType, long offset, long limit) {
        if (offset < 0L) {
            offset = 0L;
        }
        if (limit < 0L) {
            limit = Long.MAX_VALUE;
        }
        try {
            Iterator<Authorizable> authorizables = this.findAuthorizables(nameHint, searchType, offset, limit);
            UnmodifiableIterator<Principal> principals = Iterators.filter(Iterators.transform(authorizables, new AuthorizableToPrincipal()), Objects::nonNull);
            return EveryoneFilter.filter(principals, nameHint, searchType, offset, limit);
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage());
            return Collections.emptyIterator();
        }
    }

    @Override
    @NotNull
    public Iterator<? extends Principal> findPrincipals(int searchType) {
        return this.findPrincipals(null, searchType);
    }

    @Nullable
    private Authorizable getAuthorizable(@NotNull Principal principal) {
        try {
            return this.userManager.getAuthorizable(principal);
        }
        catch (RepositoryException e) {
            log.debug("Error while retrieving principal: {}", (Object)e.getMessage());
            return null;
        }
    }

    @NotNull
    private static Set<Principal> getGroupMembership(@NotNull Authorizable authorizable) {
        HashSet<Principal> groupPrincipals = new HashSet<Principal>();
        try {
            Iterator<Group> groups = authorizable.memberOf();
            while (groups.hasNext()) {
                Principal grPrincipal = groups.next().getPrincipal();
                if (!GroupPrincipals.isGroup(grPrincipal)) continue;
                groupPrincipals.add(grPrincipal);
            }
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage());
        }
        groupPrincipals.add(EveryonePrincipal.getInstance());
        return groupPrincipals;
    }

    @NotNull
    private Iterator<Authorizable> findAuthorizables(final @Nullable String nameHint, final int searchType, final long offset, final long limit) throws RepositoryException {
        Query userQuery = new Query(){

            @Override
            public <T> void build(@NotNull QueryBuilder<T> builder) {
                builder.setCondition(builder.like("@rep:principalName", PrincipalProviderImpl.buildSearchPattern(nameHint)));
                builder.setSelector(AuthorizableType.getType(searchType).getAuthorizableClass());
                builder.setSortOrder("rep:principalName", QueryBuilder.Direction.ASCENDING);
                builder.setLimit(offset, limit);
            }
        };
        return this.userManager.findAuthorizables(userQuery);
    }

    @NotNull
    private static String buildSearchPattern(@Nullable String nameHint) {
        if (nameHint == null) {
            return "%";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('%');
        sb.append(nameHint.replace("%", "\\%").replace("_", "\\_"));
        sb.append('%');
        return sb.toString();
    }

    private static final class AuthorizableToPrincipal
    implements Function<Authorizable, Principal> {
        private AuthorizableToPrincipal() {
        }

        @Override
        public Principal apply(@Nullable Authorizable authorizable) {
            if (authorizable != null) {
                try {
                    return authorizable.getPrincipal();
                }
                catch (RepositoryException e) {
                    log.debug(e.getMessage());
                }
            }
            return null;
        }
    }
}

