/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.privilege;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.security.privilege.PrivilegeDefinitionReader;
import org.apache.jackrabbit.oak.security.privilege.PrivilegeDefinitionWriter;
import org.apache.jackrabbit.oak.spi.security.privilege.ImmutablePrivilegeDefinition;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeDefinition;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sling-mock-oak.com.google.common.base.Strings;

class PrivilegeManagerImpl
implements PrivilegeManager {
    private static final Logger log = LoggerFactory.getLogger(PrivilegeManagerImpl.class);
    private final Root root;
    private final NamePathMapper namePathMapper;

    PrivilegeManagerImpl(Root root, NamePathMapper namePathMapper) {
        this.root = root;
        this.namePathMapper = namePathMapper;
    }

    @Override
    @NotNull
    public Privilege[] getRegisteredPrivileges() {
        HashSet<Privilege> privileges = new HashSet<Privilege>();
        for (PrivilegeDefinition def : this.getPrivilegeDefinitions()) {
            privileges.add(this.getPrivilege(def));
        }
        return privileges.toArray(new Privilege[0]);
    }

    @Override
    @NotNull
    public Privilege getPrivilege(@NotNull String privilegeName) throws RepositoryException {
        PrivilegeDefinition def = this.getPrivilegeDefinition(PrivilegeUtil.getOakName(privilegeName, this.namePathMapper));
        if (def == null) {
            throw new AccessControlException("No such privilege " + privilegeName);
        }
        return this.getPrivilege(def);
    }

    @Override
    @NotNull
    public Privilege registerPrivilege(@NotNull String privilegeName, boolean isAbstract, @Nullable String[] declaredAggregateNames) throws RepositoryException {
        if (this.root.hasPendingChanges()) {
            throw new InvalidItemStateException("Attempt to register a new privilege while there are pending changes.");
        }
        if (Strings.isNullOrEmpty(privilegeName)) {
            throw new RepositoryException("Invalid privilege name " + privilegeName);
        }
        ImmutablePrivilegeDefinition definition = new ImmutablePrivilegeDefinition(PrivilegeUtil.getOakName(privilegeName, this.namePathMapper), isAbstract, PrivilegeUtil.getOakNames(declaredAggregateNames, this.namePathMapper));
        PrivilegeDefinitionWriter writer = new PrivilegeDefinitionWriter(this.getWriteRoot());
        writer.writeDefinition(definition);
        this.root.refresh();
        return this.getPrivilege(definition);
    }

    @NotNull
    private Root getWriteRoot() {
        return this.root.getContentSession().getLatestRoot();
    }

    @NotNull
    private Privilege getPrivilege(@NotNull PrivilegeDefinition definition) {
        return new PrivilegeImpl(definition);
    }

    @NotNull
    private PrivilegeDefinition[] getPrivilegeDefinitions() {
        Map<String, PrivilegeDefinition> definitions = this.getReader().readDefinitions();
        return definitions.values().toArray(new PrivilegeDefinition[0]);
    }

    @Nullable
    private PrivilegeDefinition getPrivilegeDefinition(@NotNull String oakName) {
        return this.getReader().readDefinition(oakName);
    }

    @NotNull
    private PrivilegeDefinitionReader getReader() {
        return new PrivilegeDefinitionReader(this.root);
    }

    private final class PrivilegeImpl
    implements Privilege {
        private final PrivilegeDefinition definition;

        private PrivilegeImpl(PrivilegeDefinition definition) {
            this.definition = definition;
        }

        public String getName() {
            return PrivilegeManagerImpl.this.namePathMapper.getJcrName(this.definition.getName());
        }

        public boolean isAbstract() {
            return this.definition.isAbstract();
        }

        public boolean isAggregate() {
            return !this.definition.getDeclaredAggregateNames().isEmpty();
        }

        public Privilege[] getDeclaredAggregatePrivileges() {
            Set<String> declaredAggregateNames = this.definition.getDeclaredAggregateNames();
            HashSet<Privilege> declaredAggregates = new HashSet<Privilege>(declaredAggregateNames.size());
            for (String oakName : declaredAggregateNames) {
                if (oakName.equals(this.definition.getName())) {
                    log.warn("Found cyclic privilege aggregation -> ignore declared aggregate {}", (Object)oakName);
                    continue;
                }
                PrivilegeDefinition def = PrivilegeManagerImpl.this.getPrivilegeDefinition(oakName);
                if (def != null) {
                    declaredAggregates.add(PrivilegeManagerImpl.this.getPrivilege(def));
                    continue;
                }
                log.warn("Invalid privilege '{}' in declared aggregates of '{}'", (Object)oakName, (Object)this.getName());
            }
            return declaredAggregates.toArray(new Privilege[0]);
        }

        public Privilege[] getAggregatePrivileges() {
            HashSet<Privilege> aggr = new HashSet<Privilege>();
            for (Privilege decl : this.getDeclaredAggregatePrivileges()) {
                aggr.add(decl);
                if (!decl.isAggregate()) continue;
                aggr.addAll(Arrays.asList(decl.getAggregatePrivileges()));
            }
            return aggr.toArray(new Privilege[0]);
        }

        public int hashCode() {
            return this.definition.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof PrivilegeImpl) {
                return this.definition.equals(((PrivilegeImpl)o).definition);
            }
            return false;
        }

        public String toString() {
            return this.definition.getName();
        }
    }
}

