/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.guava.common.util.concurrent;

import java.util.Locale;
import java.util.logging.Level;
import org.apache.jackrabbit.guava.common.annotations.GwtIncompatible;
import org.apache.jackrabbit.guava.common.annotations.J2ktIncompatible;
import org.apache.jackrabbit.guava.common.annotations.VisibleForTesting;
import org.apache.jackrabbit.guava.common.util.concurrent.ElementTypesAreNonnullByDefault;
import org.apache.jackrabbit.guava.common.util.concurrent.LazyLogger;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public final class UncaughtExceptionHandlers {
    private UncaughtExceptionHandlers() {
    }

    public static Thread.UncaughtExceptionHandler systemExit() {
        return new Exiter(Runtime.getRuntime());
    }

    @VisibleForTesting
    static final class Exiter
    implements Thread.UncaughtExceptionHandler {
        private static final LazyLogger logger = new LazyLogger(Exiter.class);
        private final Runtime runtime;

        Exiter(Runtime runtime) {
            this.runtime = runtime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void uncaughtException(Thread t, Throwable e) {
            try {
                logger.get().log(Level.SEVERE, String.format(Locale.ROOT, "Caught an exception in %s.  Shutting down.", t), e);
            }
            catch (Throwable errorInLogging) {
                System.err.println(e.getMessage());
                System.err.println(errorInLogging.getMessage());
            }
            finally {
                this.runtime.exit(1);
            }
        }
    }
}

