/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.cache.impl;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.guava.common.collect.ImmutableList;
import org.apache.jackrabbit.guava.common.collect.Maps;
import org.apache.jackrabbit.oak.api.jmx.CacheStatsMBean;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class CacheStatsMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(CacheStatsMetrics.class);
    static final String REQUEST = "request";
    static final String HIT = "hit";
    static final String MISS = "miss";
    static final String EVICTION = "eviction";
    static final String ELEMENT = "element";
    static final String LOAD_TIME = "loadTime";
    private static final List<String> TYPES = ImmutableList.of("request", "hit", "miss", "eviction", "element", "loadTime");
    private Map<String, CacheStatsMBean> cacheStatsMBeans = Maps.newHashMap();
    private MetricRegistry registry = new MetricRegistry();

    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC)
    synchronized void addCacheStatsMBean(CacheStatsMBean stats) {
        LOG.debug("addCacheStatsMBean({})", (Object)stats.getName());
        this.cacheStatsMBeans.put(stats.getName(), stats);
        CacheStatsMetrics.registerCacheStatsMBean(this.registry, stats);
    }

    synchronized void removeCacheStatsMBean(CacheStatsMBean stats) {
        LOG.debug("removeCacheStatsMBean({})", (Object)stats.getName());
        this.cacheStatsMBeans.remove(stats.getName());
        CacheStatsMetrics.unregisterCacheStatsMBean(this.registry, stats);
    }

    @Reference(target="(name=oak)")
    synchronized void setMetricRegistry(MetricRegistry registry) {
        LOG.debug("setMetricRegistry({})", (Object)registry);
        for (CacheStatsMBean stats : this.cacheStatsMBeans.values()) {
            CacheStatsMetrics.unregisterCacheStatsMBean(this.registry, stats);
            CacheStatsMetrics.registerCacheStatsMBean(registry, stats);
        }
        this.registry = registry;
    }

    private static void registerCacheStatsMBean(MetricRegistry registry, CacheStatsMBean stats) {
        CacheStatsMetrics.registerMetric(registry, new RequestCounter(stats));
        CacheStatsMetrics.registerMetric(registry, new HitCounter(stats));
        CacheStatsMetrics.registerMetric(registry, new MissCounter(stats));
        CacheStatsMetrics.registerMetric(registry, new EvictionCounter(stats));
        CacheStatsMetrics.registerMetric(registry, new ElementCounter(stats));
        CacheStatsMetrics.registerMetric(registry, new LoadTimeCounter(stats));
    }

    private static void registerMetric(MetricRegistry registry, CacheStatsMBeanCounter metric) {
        String name = metric.getName();
        registry.remove(name);
        registry.register(name, (Metric)metric);
    }

    private static void unregisterCacheStatsMBean(MetricRegistry registry, CacheStatsMBean stats) {
        String name = stats.getName();
        for (String t : TYPES) {
            registry.remove(CacheStatsMetrics.metricName(name, t));
        }
    }

    static String metricName(String cacheStatsName, String type) {
        return "CacheStats." + cacheStatsName + "." + type;
    }

    private static final class LoadTimeCounter
    extends CacheStatsMBeanCounter {
        LoadTimeCounter(CacheStatsMBean stats) {
            super(stats, CacheStatsMetrics.LOAD_TIME);
        }

        public long getCount() {
            return this.stats.getTotalLoadTime();
        }
    }

    private static final class ElementCounter
    extends CacheStatsMBeanCounter {
        ElementCounter(CacheStatsMBean stats) {
            super(stats, CacheStatsMetrics.ELEMENT);
        }

        public long getCount() {
            return this.stats.getElementCount();
        }
    }

    private static final class EvictionCounter
    extends CacheStatsMBeanCounter {
        EvictionCounter(CacheStatsMBean stats) {
            super(stats, CacheStatsMetrics.EVICTION);
        }

        public long getCount() {
            return this.stats.getEvictionCount();
        }
    }

    private static final class MissCounter
    extends CacheStatsMBeanCounter {
        MissCounter(CacheStatsMBean stats) {
            super(stats, CacheStatsMetrics.MISS);
        }

        public long getCount() {
            return this.stats.getMissCount();
        }
    }

    private static final class HitCounter
    extends CacheStatsMBeanCounter {
        HitCounter(CacheStatsMBean stats) {
            super(stats, CacheStatsMetrics.HIT);
        }

        public long getCount() {
            return this.stats.getHitCount();
        }
    }

    private static final class RequestCounter
    extends CacheStatsMBeanCounter {
        RequestCounter(CacheStatsMBean stats) {
            super(stats, CacheStatsMetrics.REQUEST);
        }

        public long getCount() {
            return this.stats.getRequestCount();
        }
    }

    private static abstract class CacheStatsMBeanCounter
    extends Counter {
        protected CacheStatsMBean stats;
        protected String type;

        CacheStatsMBeanCounter(CacheStatsMBean stats, String type) {
            this.stats = stats;
            this.type = type;
        }

        String getName() {
            return CacheStatsMetrics.metricName(this.stats.getName(), this.type);
        }
    }
}

