/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons;

import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringUtils {
    private static final Logger LOG = LoggerFactory.getLogger(StringUtils.class);
    private static final char[] HEX = "0123456789abcdef".toCharArray();

    private StringUtils() {
    }

    @NotNull
    public static String convertBytesToHex(@NotNull byte[] value) {
        Preconditions.checkNotNull(value);
        int len = value.length;
        char[] buff = new char[len + len];
        char[] hex = HEX;
        for (int i = 0; i < len; ++i) {
            int c = value[i] & 0xFF;
            buff[i + i] = hex[c >> 4];
            buff[i + i + 1] = hex[c & 0xF];
        }
        return new String(buff);
    }

    @NotNull
    public static byte[] convertHexToBytes(@NotNull String s) {
        Preconditions.checkNotNull(s);
        int len = s.length();
        Preconditions.checkArgument(len % 2 == 0);
        byte[] buff = new byte[len /= 2];
        for (int i = 0; i < len; ++i) {
            buff[i] = (byte)(StringUtils.getHexDigit(s, i + i) << 4 | StringUtils.getHexDigit(s, i + i + 1));
        }
        return buff;
    }

    private static int getHexDigit(String s, int i) {
        char c = s.charAt(i);
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        throw new IllegalArgumentException(s);
    }

    public static int estimateMemoryUsage(String s) {
        long size;
        long l = size = s == null ? 0L : 48L + (long)s.length() * 2L;
        if (size > Integer.MAX_VALUE) {
            LOG.debug("Estimated memory footprint larger than Integer.MAX_VALUE: {}.", (Object)size);
            size = Integer.MAX_VALUE;
        }
        return (int)size;
    }
}

