/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.io;

import java.io.File;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.jackrabbit.guava.common.graph.SuccessorsFunction;
import org.apache.jackrabbit.guava.common.graph.Traverser;
import org.jetbrains.annotations.NotNull;

public class FileTreeTraverser {
    private static final FileSystemTree FILE_SYSTEM_TREE = new FileSystemTree();

    public static Stream<File> depthFirstPostOrder(File startNode) {
        Iterable<File> iterable = Traverser.forTree(FILE_SYSTEM_TREE).depthFirstPostOrder(startNode);
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static Stream<File> breadthFirst(File startNode) {
        Iterable<File> iterable = Traverser.forTree(FILE_SYSTEM_TREE).breadthFirst(startNode);
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static Stream<File> depthFirstPreOrder(File startNode) {
        Iterable<File> iterable = Traverser.forTree(FILE_SYSTEM_TREE).depthFirstPreOrder(startNode);
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    private static class FileSystemTree
    implements SuccessorsFunction<File> {
        private FileSystemTree() {
        }

        @Override
        @NotNull
        public Iterable<? extends File> successors(File file) {
            if (!file.isDirectory()) {
                return Set.of();
            }
            File[] children = file.listFiles();
            if (children == null || children.length == 0) {
                return Set.of();
            }
            return Set.copyOf(Arrays.asList(children));
        }
    }
}

