/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.sort;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.function.Function;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.commons.Compression;

public class ExternalSortByteArray {
    private static final int DEFAULT_BUFFER_SIZE = 16384;

    public static <T> void mergeSortedFilesBinary(List<Path> files, OutputStream fbw, Comparator<T> cmp, boolean distinct, Compression algorithm, Function<T, byte[]> typeToByteArray, Function<byte[], T> byteArrayToType) throws IOException {
        ExternalSortByteArray.mergeSortedFilesBinary(files, fbw, cmp, distinct, algorithm, typeToByteArray, byteArrayToType, 16384);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void mergeSortedFilesBinary(List<Path> files, OutputStream fbw, Comparator<T> cmp, boolean distinct, Compression algorithm, Function<T, byte[]> typeToByteArray, Function<byte[], T> byteArrayToType, int readBufferSize) throws IOException {
        ArrayList<BinaryFileBuffer<T>> bfbs = new ArrayList<BinaryFileBuffer<T>>();
        try {
            for (Path path : files) {
                InputStream in = algorithm.getInputStream(Files.newInputStream(path, new OpenOption[0]));
                bfbs.add(new BinaryFileBuffer<T>(in, byteArrayToType, readBufferSize));
            }
            ExternalSortByteArray.mergeBinary(fbw, cmp, distinct, bfbs, typeToByteArray);
        }
        finally {
            for (BinaryFileBuffer binaryFileBuffer : bfbs) {
                try {
                    binaryFileBuffer.close();
                }
                catch (Exception exception) {}
            }
            for (Path path : files) {
                Files.deleteIfExists(path);
            }
        }
    }

    private static <T> int mergeBinary(OutputStream fbw, Comparator<T> cmp, boolean distinct, List<BinaryFileBuffer<T>> buffers, Function<T, byte[]> typeToByteArray) throws IOException {
        PriorityQueue<BinaryFileBuffer> pq = new PriorityQueue<BinaryFileBuffer>(11, (i, j) -> cmp.compare(i.peek(), j.peek()));
        for (BinaryFileBuffer<T> bfb : buffers) {
            if (bfb.empty()) continue;
            pq.add(bfb);
        }
        int rowcounter = 0;
        Object lastLine = null;
        while (!pq.isEmpty()) {
            BinaryFileBuffer bfb = (BinaryFileBuffer)pq.poll();
            Object r = bfb.pop();
            if (!distinct || lastLine == null || cmp.compare(r, lastLine) != 0) {
                fbw.write(typeToByteArray.apply(r));
                fbw.write(10);
                lastLine = r;
            }
            ++rowcounter;
            if (bfb.empty()) {
                bfb.fbr.close();
                continue;
            }
            pq.add(bfb);
        }
        return rowcounter;
    }

    private static class BinaryFileBuffer<T> {
        public final InputStream fbr;
        private final Function<byte[], T> byteArrayToType;
        private T cache;
        private boolean empty;
        private final ByteArrayOutputStream bais = new ByteArrayOutputStream();
        private final byte[] buffer;
        private int bufferPos = 0;
        private int bufferLimit = 0;

        public BinaryFileBuffer(InputStream r, Function<byte[], T> byteArrayToType, int bufferSize) throws IOException {
            Preconditions.checkArgument(bufferSize > 1024, "Buffer size must be greater than 1024 bytes");
            this.fbr = r;
            this.byteArrayToType = byteArrayToType;
            this.buffer = new byte[bufferSize];
            this.reload();
        }

        public boolean empty() {
            return this.empty;
        }

        private void reload() throws IOException {
            try {
                byte[] line = this.readLine();
                this.cache = this.byteArrayToType.apply(line);
                this.empty = this.cache == null;
            }
            catch (EOFException oef) {
                this.empty = true;
                this.cache = null;
            }
        }

        private boolean bufferIsEmpty() {
            return this.bufferPos >= this.bufferLimit;
        }

        private byte[] readLine() throws IOException {
            this.bais.reset();
            while (true) {
                if (this.bufferIsEmpty()) {
                    this.bufferLimit = this.fbr.read(this.buffer);
                    this.bufferPos = 0;
                }
                if (this.bufferIsEmpty()) {
                    if (this.bais.size() == 0) {
                        return null;
                    }
                    return this.bais.toByteArray();
                }
                int startByte = this.bufferPos;
                while (!this.bufferIsEmpty()) {
                    byte c = this.buffer[this.bufferPos];
                    ++this.bufferPos;
                    if (c != 10) continue;
                    int lineSegmentSize = this.bufferPos - startByte - 1;
                    if (this.bais.size() == 0) {
                        if (lineSegmentSize == 0) {
                            return null;
                        }
                        byte[] line = new byte[lineSegmentSize];
                        System.arraycopy(this.buffer, startByte, line, 0, lineSegmentSize);
                        return line;
                    }
                    this.bais.write(this.buffer, startByte, lineSegmentSize);
                    if (this.bais.size() == 0) {
                        return null;
                    }
                    return this.bais.toByteArray();
                }
                this.bais.write(this.buffer, startByte, this.bufferPos - startByte);
            }
        }

        public void close() throws IOException {
            this.fbr.close();
        }

        public T peek() {
            if (this.empty()) {
                return null;
            }
            return this.cache;
        }

        public T pop() throws IOException {
            T answer = this.peek();
            this.reload();
            return answer;
        }
    }
}

