/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.session;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Binary;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockManager;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import org.apache.jackrabbit.api.JackrabbitNode;
import org.apache.jackrabbit.commons.ItemNameMatcher;
import org.apache.jackrabbit.commons.iterator.NodeIteratorAdapter;
import org.apache.jackrabbit.commons.iterator.PropertyIteratorAdapter;
import org.apache.jackrabbit.guava.common.base.Function;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.base.Predicate;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.guava.common.collect.Iterators;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.guava.common.collect.Sets;
import org.apache.jackrabbit.guava.common.collect.UnmodifiableIterator;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.LazyValue;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.jcr.delegate.NodeDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.PropertyDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.VersionManagerDelegate;
import org.apache.jackrabbit.oak.jcr.lock.LockDeprecation;
import org.apache.jackrabbit.oak.jcr.session.ItemImpl;
import org.apache.jackrabbit.oak.jcr.session.PropertyImpl;
import org.apache.jackrabbit.oak.jcr.session.SessionContext;
import org.apache.jackrabbit.oak.jcr.session.SessionImpl;
import org.apache.jackrabbit.oak.jcr.session.operation.ItemOperation;
import org.apache.jackrabbit.oak.jcr.session.operation.NodeOperation;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;
import org.apache.jackrabbit.oak.jcr.version.VersionHistoryImpl;
import org.apache.jackrabbit.oak.jcr.version.VersionImpl;
import org.apache.jackrabbit.oak.plugins.identifier.IdentifierManager;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.nodetype.write.ReadWriteNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.plugins.tree.factories.RootFactory;
import org.apache.jackrabbit.oak.spi.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.value.ValueHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeImpl<T extends NodeDelegate>
extends ItemImpl<T>
implements JackrabbitNode {
    private static final PropertyState EMPTY_MIXIN_TYPES = PropertyStates.createProperty("jcr:mixinTypes", Collections.emptyList(), Type.NAMES);
    private static final long NODE_ITERATOR_MAX_SIZE = Long.MAX_VALUE;
    private static final Logger LOG = LoggerFactory.getLogger(NodeImpl.class);
    private final int logWarnStringSizeThreshold = Integer.getInteger("oak.repository.node.property.logWarnStringSizeThreshold", 102400);

    @Nullable
    public static NodeImpl<? extends NodeDelegate> createNodeOrNull(@Nullable NodeDelegate delegate, @NotNull SessionContext context) throws RepositoryException {
        if (delegate != null) {
            return NodeImpl.createNode(delegate, context);
        }
        return null;
    }

    @NotNull
    public static NodeImpl<? extends NodeDelegate> createNode(@NotNull NodeDelegate delegate, @NotNull SessionContext context) throws RepositoryException {
        String type;
        PropertyDelegate pd = delegate.getPropertyOrNull("jcr:primaryType");
        String string = type = pd != null ? pd.getString() : null;
        if ("nt:version".equals(type)) {
            VersionManagerDelegate vmd = VersionManagerDelegate.create(context.getSessionDelegate());
            return new VersionImpl(vmd.createVersion(delegate), context);
        }
        if ("nt:versionHistory".equals(type)) {
            VersionManagerDelegate vmd = VersionManagerDelegate.create(context.getSessionDelegate());
            return new VersionHistoryImpl(vmd.createVersionHistory(delegate), context);
        }
        return new NodeImpl<NodeDelegate>(delegate, context);
    }

    public NodeImpl(T dlg, SessionContext sessionContext) {
        super(dlg, sessionContext);
    }

    public boolean isNode() {
        return true;
    }

    @NotNull
    public Node getParent() throws RepositoryException {
        return this.perform(new NodeOperation<Node>((NodeDelegate)this.dlg, "getParent"){

            @Override
            @NotNull
            public Node perform() throws RepositoryException {
                if (this.node.isRoot()) {
                    throw new ItemNotFoundException("Root has no parent");
                }
                NodeDelegate parent = this.node.getParent();
                if (parent == null) {
                    throw new AccessDeniedException();
                }
                return NodeImpl.createNode(parent, NodeImpl.this.sessionContext);
            }
        });
    }

    public boolean isNew() {
        return this.sessionDelegate.safePerform(new NodeOperation<Boolean>((NodeDelegate)this.dlg, "isNew"){

            @Override
            @NotNull
            public Boolean perform() {
                return this.node.exists() && this.node.getStatus() == Tree.Status.NEW;
            }
        });
    }

    public boolean isModified() {
        return this.sessionDelegate.safePerform(new NodeOperation<Boolean>((NodeDelegate)this.dlg, "isModified"){

            @Override
            @NotNull
            public Boolean perform() {
                return this.node.exists() && this.node.getStatus() == Tree.Status.MODIFIED;
            }
        });
    }

    public void remove() throws RepositoryException {
        this.sessionDelegate.performVoid((SessionOperation<Void>)new ItemImpl.ItemWriteOperation<Void>("remove"){

            @Override
            public void performVoid() throws RepositoryException {
                if (((NodeDelegate)NodeImpl.this.dlg).isRoot()) {
                    throw new RepositoryException("Cannot remove the root node");
                }
                ((NodeDelegate)NodeImpl.this.dlg).remove();
            }

            @Override
            public String toString() {
                return String.format("removeNode [%s]", ((NodeDelegate)NodeImpl.this.dlg).getPath());
            }
        });
    }

    public void accept(ItemVisitor visitor) throws RepositoryException {
        visitor.visit((Node)this);
    }

    @NotNull
    public Node addNode(String relPath) throws RepositoryException {
        return this.addNode(relPath, null);
    }

    @NotNull
    public Node addNode(final String relPath, String primaryNodeTypeName) throws RepositoryException {
        String oakPath;
        try {
            oakPath = this.getOakPathOrThrowNotFound(relPath);
        }
        catch (PathNotFoundException ex) {
            throw new RepositoryException("cannot determine oak path for: " + relPath, (Throwable)ex);
        }
        final String oakTypeName = primaryNodeTypeName != null ? this.getOakName(primaryNodeTypeName) : null;
        SessionImpl.checkIndexOnName(relPath);
        return this.perform(new ItemImpl.ItemWriteOperation<Node>("addNode"){

            @Override
            @NotNull
            public Node perform() throws RepositoryException {
                NodeDelegate added;
                String oakName = PathUtils.getName(oakPath);
                String parentPath = PathUtils.getParentPath(oakPath);
                NodeDelegate parent = ((NodeDelegate)NodeImpl.this.dlg).getChild(parentPath);
                if (parent == null) {
                    String propName;
                    String grandParentPath = PathUtils.getParentPath(parentPath);
                    NodeDelegate grandParent = ((NodeDelegate)NodeImpl.this.dlg).getChild(grandParentPath);
                    if (grandParent != null && grandParent.getPropertyOrNull(propName = PathUtils.getName(parentPath)) != null) {
                        throw new ConstraintViolationException("Can't add new node to property.");
                    }
                    throw new PathNotFoundException(relPath);
                }
                if (parent.getChild(oakName) != null) {
                    throw new ItemExistsException(relPath);
                }
                if (oakTypeName != null) {
                    PropertyState prop = PropertyStates.createProperty("jcr:primaryType", (Object)oakTypeName, Type.NAME);
                    NodeImpl.this.sessionContext.getAccessManager().checkPermissions(parent.getTree(), prop, 512L);
                }
                if ((added = parent.addChild(oakName, oakTypeName)) == null) {
                    throw new ItemExistsException(String.format("Node [%s/%s] exists", NodeImpl.this.getNodePath(), oakName));
                }
                return NodeImpl.createNode(added, NodeImpl.this.sessionContext);
            }

            @Override
            public String toString() {
                return String.format("addNode [%s/%s]", ((NodeDelegate)NodeImpl.this.dlg).getPath(), relPath);
            }
        });
    }

    public void orderBefore(final String srcChildRelPath, final String destChildRelPath) throws RepositoryException {
        this.sessionDelegate.performVoid((SessionOperation<Void>)new ItemImpl.ItemWriteOperation<Void>("orderBefore"){

            @Override
            public void performVoid() throws RepositoryException {
                NodeImpl.this.getEffectiveNodeType().checkOrderableChildNodes();
                String oakSrcChildRelPath = NodeImpl.this.getOakPathOrThrowNotFound(srcChildRelPath);
                String oakDestChildRelPath = null;
                if (destChildRelPath != null) {
                    oakDestChildRelPath = NodeImpl.this.getOakPathOrThrowNotFound(destChildRelPath);
                }
                ((NodeDelegate)NodeImpl.this.dlg).orderBefore(oakSrcChildRelPath, oakDestChildRelPath);
            }
        });
    }

    @NotNull
    public Property setProperty(String name, Value value) throws RepositoryException {
        if (value != null) {
            return this.internalSetProperty(name, value, false);
        }
        return this.internalRemoveProperty(name);
    }

    @NotNull
    public Property setProperty(String name, Value value, int type) throws RepositoryException {
        if (value != null) {
            boolean exactTypeMatch = true;
            if (type == 0) {
                exactTypeMatch = false;
            } else {
                value = ValueHelper.convert(value, type, this.getValueFactory());
            }
            return this.internalSetProperty(name, value, exactTypeMatch);
        }
        return this.internalRemoveProperty(name);
    }

    @NotNull
    public Property setProperty(String name, Value[] values) throws RepositoryException {
        if (values != null) {
            return this.internalSetProperty(name, values, ValueHelper.getType(values), false);
        }
        return this.internalRemoveProperty(name);
    }

    @NotNull
    public Property setProperty(String jcrName, Value[] values, int type) throws RepositoryException {
        if (values != null) {
            boolean exactTypeMatch = true;
            if (type == 0) {
                type = 1;
                exactTypeMatch = false;
            }
            values = ValueHelper.convert(values, type, this.getValueFactory());
            return this.internalSetProperty(jcrName, values, type, exactTypeMatch);
        }
        return this.internalRemoveProperty(jcrName);
    }

    @NotNull
    public Property setProperty(String name, String[] values) throws RepositoryException {
        if (values != null) {
            int type = 1;
            Value[] vs = ValueHelper.convert(values, type, this.getValueFactory());
            return this.internalSetProperty(name, vs, type, false);
        }
        return this.internalRemoveProperty(name);
    }

    @NotNull
    public Property setProperty(String name, String[] values, int type) throws RepositoryException {
        if (values != null) {
            boolean exactTypeMatch = true;
            if (type == 0) {
                type = 1;
                exactTypeMatch = false;
            }
            Value[] vs = ValueHelper.convert(values, type, this.getValueFactory());
            return this.internalSetProperty(name, vs, type, exactTypeMatch);
        }
        return this.internalRemoveProperty(name);
    }

    @NotNull
    public Property setProperty(String name, String value) throws RepositoryException {
        if (value != null) {
            Value v = this.getValueFactory().createValue(value);
            return this.internalSetProperty(name, v, false);
        }
        return this.internalRemoveProperty(name);
    }

    @NotNull
    public Property setProperty(String name, String value, int type) throws RepositoryException {
        if (value != null) {
            boolean exactTypeMatch = true;
            if (type == 0) {
                type = 1;
                exactTypeMatch = false;
            }
            Value v = this.getValueFactory().createValue(value, type);
            return this.internalSetProperty(name, v, exactTypeMatch);
        }
        return this.internalRemoveProperty(name);
    }

    @NotNull
    public Property setProperty(String name, InputStream value) throws RepositoryException {
        if (value != null) {
            Value v = this.getValueFactory().createValue(value);
            return this.internalSetProperty(name, v, false);
        }
        return this.internalRemoveProperty(name);
    }

    @NotNull
    public Property setProperty(String name, Binary value) throws RepositoryException {
        if (value != null) {
            Value v = this.getValueFactory().createValue(value);
            return this.internalSetProperty(name, v, false);
        }
        return this.internalRemoveProperty(name);
    }

    @NotNull
    public Property setProperty(String name, boolean value) throws RepositoryException {
        Value v = this.getValueFactory().createValue(value);
        return this.internalSetProperty(name, v, false);
    }

    @NotNull
    public Property setProperty(String name, double value) throws RepositoryException {
        Value v = this.getValueFactory().createValue(value);
        return this.internalSetProperty(name, v, false);
    }

    @NotNull
    public Property setProperty(String name, BigDecimal value) throws RepositoryException {
        if (value != null) {
            Value v = this.getValueFactory().createValue(value);
            return this.internalSetProperty(name, v, false);
        }
        return this.internalRemoveProperty(name);
    }

    @NotNull
    public Property setProperty(String name, long value) throws RepositoryException {
        Value v = this.getValueFactory().createValue(value);
        return this.internalSetProperty(name, v, false);
    }

    @NotNull
    public Property setProperty(String name, Calendar value) throws RepositoryException {
        if (value != null) {
            Value v = this.getValueFactory().createValue(value);
            return this.internalSetProperty(name, v, false);
        }
        return this.internalRemoveProperty(name);
    }

    @NotNull
    public Property setProperty(String name, Node value) throws RepositoryException {
        if (value != null) {
            Value v = this.getValueFactory().createValue(value);
            return this.internalSetProperty(name, v, false);
        }
        return this.internalRemoveProperty(name);
    }

    @NotNull
    public Node getNode(String relPath) throws RepositoryException {
        final String oakPath = this.getOakPathOrThrowNotFound(relPath);
        return this.perform(new NodeOperation<Node>((NodeDelegate)this.dlg, "getNode"){

            @Override
            @NotNull
            public Node perform() throws RepositoryException {
                NodeDelegate nd = this.node.getChild(oakPath);
                if (nd == null) {
                    throw new PathNotFoundException(oakPath);
                }
                return NodeImpl.createNode(nd, NodeImpl.this.sessionContext);
            }
        });
    }

    @NotNull
    public NodeIterator getNodes() throws RepositoryException {
        return this.perform(new NodeOperation<NodeIterator>((NodeDelegate)this.dlg, "getNodes"){

            @Override
            @NotNull
            public NodeIterator perform() throws RepositoryException {
                Iterator<NodeDelegate> children = this.node.getChildren();
                return new NodeIteratorAdapter(NodeImpl.this.nodeIterator(children)){
                    private long size;
                    {
                        this.size = -2L;
                    }

                    @Override
                    public long getSize() {
                        if (this.size == -2L) {
                            try {
                                this.size = node.getChildCount(Long.MAX_VALUE);
                                if (this.size == Long.MAX_VALUE) {
                                    this.size = -1L;
                                }
                            }
                            catch (InvalidItemStateException e) {
                                throw new IllegalStateException("This iterator is no longer valid", e);
                            }
                        }
                        return this.size;
                    }
                };
            }

            @Override
            public String toString() {
                return String.format("getNodes [%s]", ((NodeDelegate)NodeImpl.this.dlg).getPath());
            }
        });
    }

    @NotNull
    public NodeIterator getNodes(final String namePattern) throws RepositoryException {
        return this.perform(new NodeOperation<NodeIterator>((NodeDelegate)this.dlg, "getNodes"){

            @Override
            @NotNull
            public NodeIterator perform() throws RepositoryException {
                UnmodifiableIterator<NodeDelegate> children = Iterators.filter(this.node.getChildren(), new Predicate<NodeDelegate>(){

                    @Override
                    public boolean apply(NodeDelegate state) {
                        return ItemNameMatcher.matches(NodeImpl.this.toJcrPath(state.getName()), namePattern);
                    }
                });
                return new NodeIteratorAdapter(NodeImpl.this.nodeIterator(children));
            }

            @Override
            public String toString() {
                return String.format("getNodes [%s]", ((NodeDelegate)NodeImpl.this.dlg).getPath());
            }
        });
    }

    @NotNull
    public NodeIterator getNodes(final String[] nameGlobs) throws RepositoryException {
        return this.perform(new NodeOperation<NodeIterator>((NodeDelegate)this.dlg, "getNodes"){

            @Override
            @NotNull
            public NodeIterator perform() throws RepositoryException {
                UnmodifiableIterator<NodeDelegate> children = Iterators.filter(this.node.getChildren(), new Predicate<NodeDelegate>(){

                    @Override
                    public boolean apply(NodeDelegate state) {
                        return ItemNameMatcher.matches(NodeImpl.this.toJcrPath(state.getName()), nameGlobs);
                    }
                });
                return new NodeIteratorAdapter(NodeImpl.this.nodeIterator(children));
            }

            @Override
            public String toString() {
                return String.format("getNodes [%s]", ((NodeDelegate)NodeImpl.this.dlg).getPath());
            }
        });
    }

    @NotNull
    public Property getProperty(String relPath) throws RepositoryException {
        final String oakPath = this.getOakPathOrThrowNotFound(relPath);
        return this.perform(new NodeOperation<PropertyImpl>((NodeDelegate)this.dlg, "getProperty"){

            @Override
            @NotNull
            public PropertyImpl perform() throws RepositoryException {
                PropertyDelegate pd = this.node.getPropertyOrNull(oakPath);
                if (pd == null) {
                    throw new PathNotFoundException(oakPath + " not found on " + this.node.getPath());
                }
                return new PropertyImpl(pd, NodeImpl.this.sessionContext);
            }

            @Override
            public String toString() {
                return String.format("getProperty [%s]", ((NodeDelegate)NodeImpl.this.dlg).getPath());
            }
        });
    }

    @NotNull
    public PropertyIterator getProperties() throws RepositoryException {
        return this.perform(new NodeOperation<PropertyIterator>((NodeDelegate)this.dlg, "getProperties"){

            @Override
            @NotNull
            public PropertyIterator perform() throws RepositoryException {
                Iterator<PropertyDelegate> properties = this.node.getProperties();
                long size = this.node.getPropertyCount();
                return new PropertyIteratorAdapter(NodeImpl.this.propertyIterator(properties), size);
            }

            @Override
            public String toString() {
                return String.format("getProperties [%s]", ((NodeDelegate)NodeImpl.this.dlg).getPath());
            }
        });
    }

    @NotNull
    public PropertyIterator getProperties(final String namePattern) throws RepositoryException {
        return this.perform(new NodeOperation<PropertyIterator>((NodeDelegate)this.dlg, "getProperties"){

            @Override
            @NotNull
            public PropertyIterator perform() throws RepositoryException {
                final PropertyIteratorDelegate delegate = new PropertyIteratorDelegate(this.node, new Predicate<PropertyDelegate>(){

                    @Override
                    public boolean apply(PropertyDelegate entry) {
                        return ItemNameMatcher.matches(NodeImpl.this.toJcrPath(entry.getName()), namePattern);
                    }
                });
                return new PropertyIteratorAdapter(NodeImpl.this.propertyIterator(delegate.iterator())){

                    @Override
                    public long getSize() {
                        return delegate.getSize();
                    }
                };
            }
        });
    }

    @NotNull
    public PropertyIterator getProperties(final String[] nameGlobs) throws RepositoryException {
        return this.perform(new NodeOperation<PropertyIterator>((NodeDelegate)this.dlg, "getProperties"){

            @Override
            @NotNull
            public PropertyIterator perform() throws RepositoryException {
                final PropertyIteratorDelegate delegate = new PropertyIteratorDelegate(this.node, new Predicate<PropertyDelegate>(){

                    @Override
                    public boolean apply(PropertyDelegate entry) {
                        return ItemNameMatcher.matches(NodeImpl.this.toJcrPath(entry.getName()), nameGlobs);
                    }
                });
                return new PropertyIteratorAdapter(NodeImpl.this.propertyIterator(delegate.iterator())){

                    @Override
                    public long getSize() {
                        return delegate.getSize();
                    }
                };
            }
        });
    }

    @NotNull
    public Item getPrimaryItem() throws RepositoryException {
        return this.perform(new NodeOperation<Item>((NodeDelegate)this.dlg, "getPrimaryItem"){

            @Override
            @NotNull
            public Item perform() throws RepositoryException {
                String name = NodeImpl.this.getPrimaryNodeType().getPrimaryItemName();
                if (name == null) {
                    throw new ItemNotFoundException("No primary item present on node " + NodeImpl.this);
                }
                if (NodeImpl.this.hasProperty(name)) {
                    return NodeImpl.this.getProperty(name);
                }
                if (NodeImpl.this.hasNode(name)) {
                    return NodeImpl.this.getNode(name);
                }
                throw new ItemNotFoundException("Primary item " + name + " does not exist on node " + NodeImpl.this);
            }
        });
    }

    @NotNull
    public String getUUID() throws RepositoryException {
        return this.perform(new NodeOperation<String>((NodeDelegate)this.dlg, "getUUID"){

            @Override
            @NotNull
            public String perform() throws RepositoryException {
                if (NodeImpl.this.isNodeType("{http://www.jcp.org/jcr/mix/1.0}referenceable")) {
                    return NodeImpl.this.getIdentifier();
                }
                throw new UnsupportedRepositoryOperationException(String.format("Node [%s] is not referenceable.", NodeImpl.this.getNodePath()));
            }
        });
    }

    @NotNull
    public String getIdentifier() throws RepositoryException {
        return this.perform(new NodeOperation<String>((NodeDelegate)this.dlg, "getIdentifier"){

            @Override
            @NotNull
            public String perform() throws RepositoryException {
                return this.node.getIdentifier();
            }
        });
    }

    public int getIndex() throws RepositoryException {
        return 1;
    }

    private PropertyIterator internalGetReferences(final String name, final boolean weak) throws RepositoryException {
        return this.perform(new NodeOperation<PropertyIterator>((NodeDelegate)this.dlg, "internalGetReferences"){

            @Override
            @NotNull
            public PropertyIterator perform() throws InvalidItemStateException {
                IdentifierManager idManager = NodeImpl.this.sessionDelegate.getIdManager();
                Iterable<String> propertyOakPaths = idManager.getReferences(weak, this.node.getTree(), name);
                Iterable<Property> properties = Iterables.transform(propertyOakPaths, new Function<String, Property>(){

                    @Override
                    public Property apply(String oakPath) {
                        PropertyDelegate pd = NodeImpl.this.sessionDelegate.getProperty(oakPath);
                        return pd == null ? null : new PropertyImpl(pd, NodeImpl.this.sessionContext);
                    }
                });
                return new PropertyIteratorAdapter(NodeImpl.this.sessionDelegate.sync(properties.iterator()));
            }
        });
    }

    @NotNull
    public PropertyIterator getReferences() throws RepositoryException {
        return this.internalGetReferences(null, false);
    }

    @NotNull
    public PropertyIterator getReferences(String name) throws RepositoryException {
        return this.internalGetReferences(name, false);
    }

    @NotNull
    public PropertyIterator getWeakReferences() throws RepositoryException {
        return this.internalGetReferences(null, true);
    }

    @NotNull
    public PropertyIterator getWeakReferences(String name) throws RepositoryException {
        return this.internalGetReferences(name, true);
    }

    public boolean hasNode(String relPath) throws RepositoryException {
        try {
            final String oakPath = this.getOakPathOrThrow(relPath);
            return this.perform(new NodeOperation<Boolean>((NodeDelegate)this.dlg, "hasNode"){

                @Override
                @NotNull
                public Boolean perform() throws RepositoryException {
                    return this.node.getChild(oakPath) != null;
                }
            });
        }
        catch (PathNotFoundException e) {
            return false;
        }
    }

    public boolean hasProperty(String relPath) throws RepositoryException {
        try {
            final String oakPath = this.getOakPathOrThrow(relPath);
            return this.perform(new NodeOperation<Boolean>((NodeDelegate)this.dlg, "hasProperty"){

                @Override
                @NotNull
                public Boolean perform() throws RepositoryException {
                    return this.node.getPropertyOrNull(oakPath) != null;
                }

                @Override
                public String toString() {
                    return String.format("hasProperty [%s]", ((NodeDelegate)NodeImpl.this.dlg).getPath());
                }
            });
        }
        catch (PathNotFoundException e) {
            return false;
        }
    }

    public boolean hasNodes() throws RepositoryException {
        return this.getNodes().hasNext();
    }

    public boolean hasProperties() throws RepositoryException {
        return this.perform(new NodeOperation<Boolean>((NodeDelegate)this.dlg, "hasProperties"){

            @Override
            @NotNull
            public Boolean perform() throws RepositoryException {
                return this.node.getPropertyCount() != 0L;
            }
        });
    }

    @NotNull
    public NodeType getPrimaryNodeType() throws RepositoryException {
        return this.perform(new NodeOperation<NodeType>((NodeDelegate)this.dlg, "getPrimaryNodeType"){

            @Override
            @NotNull
            public NodeType perform() throws RepositoryException {
                Tree tree = this.node.getTree();
                String primaryTypeName = NodeImpl.this.getPrimaryTypeName(tree);
                if (primaryTypeName != null) {
                    return NodeImpl.this.getNodeTypeManager().getNodeType(NodeImpl.this.sessionContext.getJcrName(primaryTypeName));
                }
                throw new RepositoryException("Unable to retrieve primary type for Node " + NodeImpl.this.getNodePath());
            }
        });
    }

    @NotNull
    public NodeType[] getMixinNodeTypes() throws RepositoryException {
        return this.perform(new NodeOperation<NodeType[]>((NodeDelegate)this.dlg, "getMixinNodeTypes"){

            @Override
            @NotNull
            public NodeType[] perform() throws RepositoryException {
                Tree tree = this.node.getTree();
                Iterator<String> mixinNames = NodeImpl.this.getMixinTypeNames(tree).iterator();
                if (mixinNames.hasNext()) {
                    ReadWriteNodeTypeManager ntMgr = NodeImpl.this.getNodeTypeManager();
                    ArrayList<NodeType> mixinTypes = Lists.newArrayList();
                    while (mixinNames.hasNext()) {
                        mixinTypes.add(ntMgr.getNodeType(NodeImpl.this.sessionContext.getJcrName(mixinNames.next())));
                    }
                    return mixinTypes.toArray(new NodeType[mixinTypes.size()]);
                }
                return new NodeType[0];
            }
        });
    }

    public boolean isNodeType(String nodeTypeName) throws RepositoryException {
        final String oakName = this.getOakName(nodeTypeName);
        return this.perform(new NodeOperation<Boolean>((NodeDelegate)this.dlg, "isNodeType"){

            @Override
            @NotNull
            public Boolean perform() throws RepositoryException {
                Tree tree = this.node.getTree();
                return NodeImpl.this.getNodeTypeManager().isNodeType(NodeImpl.this.getPrimaryTypeName(tree), () -> NodeImpl.this.getMixinTypeNames(tree), oakName);
            }
        });
    }

    public void setPrimaryType(String nodeTypeName) throws RepositoryException {
        final String oakTypeName = this.getOakName(Preconditions.checkNotNull(nodeTypeName));
        this.sessionDelegate.performVoid((SessionOperation<Void>)new ItemImpl.ItemWriteOperation<Void>("setPrimaryType"){

            @Override
            public void checkPreconditions() throws RepositoryException {
                super.checkPreconditions();
                if (!NodeImpl.this.internalIsCheckedOut()) {
                    throw new VersionException(String.format("Cannot set primary type. Node [%s] is checked in.", NodeImpl.this.getNodePath()));
                }
            }

            @Override
            public void performVoid() throws RepositoryException {
                NodeImpl.this.internalSetPrimaryType(oakTypeName);
            }
        });
    }

    public void addMixin(String mixinName) throws RepositoryException {
        final String oakTypeName = this.getOakName(Preconditions.checkNotNull(mixinName));
        if ("mix:lockable".equals(oakTypeName)) {
            LockDeprecation.handleCall("addMixin mix:lockable");
        }
        this.sessionDelegate.performVoid((SessionOperation<Void>)new ItemImpl.ItemWriteOperation<Void>("addMixin"){

            @Override
            public void checkPreconditions() throws RepositoryException {
                super.checkPreconditions();
                if (!NodeImpl.this.internalIsCheckedOut()) {
                    throw new VersionException(String.format("Cannot add mixin type. Node [%s] is checked in.", NodeImpl.this.getNodePath()));
                }
            }

            @Override
            public void performVoid() throws RepositoryException {
                ((NodeDelegate)NodeImpl.this.dlg).addMixin(x$0 -> NodeImpl.this.getMixinTypeNames((Tree)x$0), oakTypeName);
            }
        });
    }

    public void removeMixin(final String mixinName) throws RepositoryException {
        final String oakTypeName = this.getOakName(Preconditions.checkNotNull(mixinName));
        this.sessionDelegate.performVoid((SessionOperation<Void>)new ItemImpl.ItemWriteOperation<Void>("removeMixin"){

            @Override
            public void checkPreconditions() throws RepositoryException {
                super.checkPreconditions();
                if (!NodeImpl.this.internalIsCheckedOut()) {
                    throw new VersionException(String.format("Cannot remove mixin type. Node [%s] is checked in.", NodeImpl.this.getNodePath()));
                }
                LinkedHashSet<String> mixins = Sets.newLinkedHashSet(TreeUtil.getNames(((NodeDelegate)NodeImpl.this.dlg).getTree(), "jcr:mixinTypes"));
                if (!mixins.isEmpty() && mixins.remove(NodeImpl.this.getOakName(mixinName))) {
                    PropertyState prop = PropertyStates.createProperty("jcr:mixinTypes", mixins, Type.NAMES);
                    NodeImpl.this.sessionContext.getAccessManager().checkPermissions(((NodeDelegate)NodeImpl.this.dlg).getTree(), prop, 512L);
                }
            }

            @Override
            public void performVoid() throws RepositoryException {
                ((NodeDelegate)NodeImpl.this.dlg).removeMixin(oakTypeName);
            }
        });
    }

    public boolean canAddMixin(String mixinName) throws RepositoryException {
        final String oakTypeName = this.getOakName(mixinName);
        return this.perform(new NodeOperation<Boolean>((NodeDelegate)this.dlg, "canAddMixin"){

            @Override
            @NotNull
            public Boolean perform() throws RepositoryException {
                PropertyState prop = PropertyStates.createProperty("jcr:mixinTypes", Collections.singleton(oakTypeName), Type.NAMES);
                return NodeImpl.this.sessionContext.getAccessManager().hasPermissions(this.node.getTree(), prop, 512L) && !this.node.isProtected() && NodeImpl.this.getVersionManager().isCheckedOut(this.node) && this.node.canAddMixin(oakTypeName);
            }
        });
    }

    @NotNull
    public NodeDefinition getDefinition() throws RepositoryException {
        return this.perform(new NodeOperation<NodeDefinition>((NodeDelegate)this.dlg, "getDefinition"){

            @Override
            @NotNull
            public NodeDefinition perform() throws RepositoryException {
                NodeDelegate parent = this.node.getParent();
                if (parent == null) {
                    return NodeImpl.this.getNodeTypeManager().getRootDefinition();
                }
                return NodeImpl.this.getNodeTypeManager().getDefinition(parent.getTree(), this.node.getTree());
            }
        });
    }

    @NotNull
    public String getCorrespondingNodePath(final String workspaceName) throws RepositoryException {
        return this.toJcrPath(this.perform(new ItemOperation<String>(this.dlg, "getCorrespondingNodePath"){

            @Override
            @NotNull
            public String perform() throws RepositoryException {
                NodeImpl.this.checkValidWorkspace(workspaceName);
                if (workspaceName.equals(NodeImpl.this.sessionDelegate.getWorkspaceName())) {
                    return this.item.getPath();
                }
                throw new UnsupportedRepositoryOperationException("OAK-118: Node.getCorrespondingNodePath at " + NodeImpl.this.getNodePath());
            }
        }));
    }

    public void update(final String srcWorkspace) throws RepositoryException {
        this.sessionDelegate.performVoid((SessionOperation<Void>)new ItemImpl.ItemWriteOperation<Void>("update"){

            @Override
            public void performVoid() throws RepositoryException {
                NodeImpl.this.checkValidWorkspace(srcWorkspace);
                if (NodeImpl.this.sessionDelegate.hasPendingChanges()) {
                    String msg = String.format("Unable to perform operation. Session has pending changes. Node [%s]", NodeImpl.this.getNodePath());
                    LOG.debug(msg);
                    throw new InvalidItemStateException(msg);
                }
                if (!srcWorkspace.equals(NodeImpl.this.sessionDelegate.getWorkspaceName())) {
                    throw new UnsupportedRepositoryOperationException("OAK-118: Node.update at " + NodeImpl.this.getNodePath());
                }
            }
        });
    }

    @NotNull
    public Version checkin() throws RepositoryException {
        return this.getVersionManager().checkin(this.getPath());
    }

    public void checkout() throws RepositoryException {
        this.getVersionManager().checkout(this.getPath());
    }

    public void doneMerge(Version version) throws RepositoryException {
        this.getVersionManager().doneMerge(this.getPath(), version);
    }

    public void cancelMerge(Version version) throws RepositoryException {
        this.getVersionManager().cancelMerge(this.getPath(), version);
    }

    @NotNull
    public NodeIterator merge(String srcWorkspace, boolean bestEffort) throws RepositoryException {
        return this.getVersionManager().merge(this.getPath(), srcWorkspace, bestEffort);
    }

    public boolean isCheckedOut() throws RepositoryException {
        SessionDelegate sessionDelegate = this.sessionContext.getSessionDelegate();
        return sessionDelegate.perform(new SessionOperation<Boolean>("isCheckedOut"){

            @Override
            @NotNull
            public Boolean perform() throws RepositoryException {
                return NodeImpl.this.internalIsCheckedOut();
            }
        });
    }

    public void restore(String versionName, boolean removeExisting) throws RepositoryException {
        if (!this.isNodeType("{http://www.jcp.org/jcr/mix/1.0}versionable")) {
            throw new UnsupportedRepositoryOperationException(String.format("Node [%s] is not mix:versionable", this.getNodePath()));
        }
        this.getVersionManager().restore(this.getPath(), versionName, removeExisting);
    }

    public void restore(Version version, boolean removeExisting) throws RepositoryException {
        if (!this.isNodeType("{http://www.jcp.org/jcr/mix/1.0}versionable")) {
            throw new UnsupportedRepositoryOperationException(String.format("Node [%s] is not mix:versionable", this.getNodePath()));
        }
        String id = version.getContainingHistory().getVersionableIdentifier();
        if (!this.getIdentifier().equals(id)) {
            throw new VersionException(String.format("Version does not belong to the VersionHistory of this node [%s].", this.getNodePath()));
        }
        this.getVersionManager().restore(version, removeExisting);
    }

    public void restore(Version version, String relPath, boolean removeExisting) throws RepositoryException {
        if (this.hasNode(relPath)) {
            this.getNode(relPath).restore(version, removeExisting);
        } else {
            String absPath = PathUtils.concat(this.getPath(), relPath);
            this.getVersionManager().restore(absPath, version, removeExisting);
        }
    }

    public void restoreByLabel(String versionLabel, boolean removeExisting) throws RepositoryException {
        this.getVersionManager().restoreByLabel(this.getPath(), versionLabel, removeExisting);
    }

    @NotNull
    public VersionHistory getVersionHistory() throws RepositoryException {
        return this.getVersionManager().getVersionHistory(this.getPath());
    }

    @NotNull
    public Version getBaseVersion() throws RepositoryException {
        return this.getVersionManager().getBaseVersion(this.getPath());
    }

    private LockManager getLockManager() throws RepositoryException {
        return this.getSession().getWorkspace().getLockManager();
    }

    public boolean isLocked() throws RepositoryException {
        if (!LockDeprecation.isLockingSupported()) {
            return false;
        }
        return this.sessionDelegate.perform(new SessionOperation<Boolean>("isLocked"){

            @Override
            @NotNull
            public Boolean perform() {
                return ((NodeDelegate)NodeImpl.this.dlg).isLocked();
            }
        });
    }

    public boolean holdsLock() throws RepositoryException {
        return this.getLockManager().holdsLock(this.getPath());
    }

    @NotNull
    public Lock getLock() throws RepositoryException {
        return this.getLockManager().getLock(this.getPath());
    }

    @NotNull
    public Lock lock(boolean isDeep, boolean isSessionScoped) throws RepositoryException {
        return this.getLockManager().lock(this.getPath(), isDeep, isSessionScoped, Long.MAX_VALUE, null);
    }

    public void unlock() throws RepositoryException {
        this.getLockManager().unlock(this.getPath());
    }

    @NotNull
    public NodeIterator getSharedSet() {
        return new NodeIteratorAdapter(Collections.singleton(this));
    }

    public void removeSharedSet() throws RepositoryException {
        this.sessionDelegate.performVoid((SessionOperation<Void>)new ItemImpl.ItemWriteOperation<Void>("removeSharedSet"){

            @Override
            public void performVoid() throws RepositoryException {
                NodeIterator sharedSet = NodeImpl.this.getSharedSet();
                while (sharedSet.hasNext()) {
                    sharedSet.nextNode().removeShare();
                }
            }
        });
    }

    public void removeShare() throws RepositoryException {
        this.remove();
    }

    public void followLifecycleTransition(String transition) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("Lifecycle Management is not supported");
    }

    @NotNull
    public String[] getAllowedLifecycleTransistions() throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("Lifecycle Management is not supported");
    }

    public boolean internalIsCheckedOut() throws RepositoryException {
        return this.getVersionManager().isCheckedOut((NodeDelegate)this.dlg);
    }

    @Nullable
    private String getPrimaryTypeName(@NotNull Tree tree) {
        return TreeUtil.getPrimaryTypeName(tree, this.getReadOnlyTree(tree));
    }

    @NotNull
    private Iterable<String> getMixinTypeNames(@NotNull Tree tree) {
        if (tree.hasProperty("jcr:mixinTypes") || this.canReadMixinTypes(tree)) {
            return TreeUtil.getMixinTypeNames(tree);
        }
        return TreeUtil.getMixinTypeNames(tree, this.getReadOnlyTree(tree));
    }

    @NotNull
    private LazyValue<Tree> getReadOnlyTree(final @NotNull Tree tree) {
        return new LazyValue<Tree>(){

            @Override
            protected Tree createValue() {
                return RootFactory.createReadOnlyRoot(NodeImpl.this.sessionDelegate.getRoot()).getTree(tree.getPath());
            }
        };
    }

    private boolean canReadMixinTypes(@NotNull Tree tree) {
        return this.sessionContext.getAccessManager().hasPermissions(tree, EMPTY_MIXIN_TYPES, 2L);
    }

    private EffectiveNodeType getEffectiveNodeType() throws RepositoryException {
        return this.getNodeTypeManager().getEffectiveNodeType(((NodeDelegate)this.dlg).getTree());
    }

    private Iterator<Node> nodeIterator(Iterator<NodeDelegate> childNodes) {
        return this.sessionDelegate.sync(Iterators.transform(childNodes, new Function<NodeDelegate, Node>(){

            @Override
            public Node apply(NodeDelegate nodeDelegate) {
                return new NodeImpl<NodeDelegate>(nodeDelegate, NodeImpl.this.sessionContext);
            }
        }));
    }

    private Iterator<Property> propertyIterator(Iterator<PropertyDelegate> properties) {
        return this.sessionDelegate.sync(Iterators.transform(properties, new Function<PropertyDelegate, Property>(){

            @Override
            public Property apply(PropertyDelegate propertyDelegate) {
                return new PropertyImpl(propertyDelegate, NodeImpl.this.sessionContext);
            }
        }));
    }

    private void checkValidWorkspace(String workspaceName) throws RepositoryException {
        String[] workspaceNames = this.getSession().getWorkspace().getAccessibleWorkspaceNames();
        if (!Arrays.asList(workspaceNames).contains(workspaceName)) {
            throw new NoSuchWorkspaceException("Workspace " + workspaceName + " does not exist");
        }
    }

    private void internalSetPrimaryType(String nodeTypeName) throws RepositoryException {
        NodeType nt = this.getNodeTypeManager().getNodeType(nodeTypeName);
        if (nt.isAbstract() || nt.isMixin()) {
            throw new ConstraintViolationException(this.getNodePath());
        }
        PropertyState state = PropertyStates.createProperty("jcr:primaryType", (Object)this.getOakName(nodeTypeName), Type.NAME);
        ((NodeDelegate)this.dlg).setProperty(state, true, true);
        Tree typeRoot = this.sessionDelegate.getRoot().getTree("/jcr:system/jcr:nodeTypes");
        TreeUtil.autoCreateItems(((NodeDelegate)this.dlg).getTree(), typeRoot.getChild(nodeTypeName), typeRoot, this.sessionDelegate.getAuthInfo().getUserID());
        ((NodeDelegate)this.dlg).setOrderableChildren(nt.hasOrderableChildNodes());
    }

    private Property internalSetProperty(final String jcrName, Value value, final boolean exactTypeMatch) throws RepositoryException {
        String oakName = this.getOakPathOrThrow(Preconditions.checkNotNull(jcrName));
        final PropertyState state = this.createSingleState(oakName, value, Type.fromTag(value.getType(), false));
        if (value.getType() == 1) {
            this.logLargeStringProperties(jcrName, value.getString());
        }
        return this.perform(new ItemImpl.ItemWriteOperation<Property>("internalSetProperty"){

            @Override
            public void checkPreconditions() throws RepositoryException {
                super.checkPreconditions();
                if (!NodeImpl.this.internalIsCheckedOut() && NodeImpl.this.getOPV(((NodeDelegate)NodeImpl.this.dlg).getTree(), state) != 5) {
                    throw new VersionException(String.format("Cannot set property. Node [%s] is checked in.", NodeImpl.this.getNodePath()));
                }
            }

            @Override
            @NotNull
            public Property perform() throws RepositoryException {
                return new PropertyImpl(((NodeDelegate)NodeImpl.this.dlg).setProperty(state, exactTypeMatch, false), NodeImpl.this.sessionContext);
            }

            @Override
            public String toString() {
                return String.format("setProperty [%s/%s]", ((NodeDelegate)NodeImpl.this.dlg).getPath(), jcrName);
            }
        });
    }

    private void logLargeStringProperties(String propertyName, String value) throws RepositoryException {
        if (value.length() > this.logWarnStringSizeThreshold) {
            LOG.warn("String length: {} for property: {} at Node: {} is greater than configured value {}", new Object[]{value.length(), propertyName, this.getPath(), this.logWarnStringSizeThreshold});
        }
    }

    private Property internalSetProperty(final String jcrName, Value[] values, int type, final boolean exactTypeMatch) throws RepositoryException {
        String oakName = this.getOakPathOrThrow(Preconditions.checkNotNull(jcrName));
        final PropertyState state = this.createMultiState(oakName, NodeImpl.compact(values), Type.fromTag(type, true));
        if (values.length > 1000) {
            LOG.warn("Large multi valued property [{}/{}] detected ({} values).", new Object[]{((NodeDelegate)this.dlg).getPath(), jcrName, values.length});
        }
        for (Value value : values) {
            if (value == null || value.getType() != 1) continue;
            this.logLargeStringProperties(jcrName, value.getString());
        }
        return this.perform(new ItemImpl.ItemWriteOperation<Property>("internalSetProperty"){

            @Override
            public void checkPreconditions() throws RepositoryException {
                super.checkPreconditions();
                if (!NodeImpl.this.internalIsCheckedOut() && NodeImpl.this.getOPV(((NodeDelegate)NodeImpl.this.dlg).getTree(), state) != 5) {
                    throw new VersionException(String.format("Cannot set property. Node [%s] is checked in.", NodeImpl.this.getNodePath()));
                }
            }

            @Override
            @NotNull
            public Property perform() throws RepositoryException {
                return new PropertyImpl(((NodeDelegate)NodeImpl.this.dlg).setProperty(state, exactTypeMatch, false), NodeImpl.this.sessionContext);
            }

            @Override
            public String toString() {
                return String.format("setProperty [%s/%s]", ((NodeDelegate)NodeImpl.this.dlg).getPath(), jcrName);
            }
        });
    }

    private static List<Value> compact(Value[] values) {
        ArrayList<Value> list = Lists.newArrayListWithCapacity(values.length);
        for (Value value : values) {
            if (value == null) continue;
            list.add(value);
        }
        return list;
    }

    private Property internalRemoveProperty(final String jcrName) throws RepositoryException {
        final String oakName = this.getOakName(Preconditions.checkNotNull(jcrName));
        return this.perform(new ItemImpl.ItemWriteOperation<Property>("internalRemoveProperty"){

            @Override
            public void checkPreconditions() throws RepositoryException {
                super.checkPreconditions();
                PropertyDelegate property = ((NodeDelegate)NodeImpl.this.dlg).getPropertyOrNull(oakName);
                if (property != null && !NodeImpl.this.internalIsCheckedOut() && NodeImpl.this.getOPV(((NodeDelegate)NodeImpl.this.dlg).getTree(), property.getPropertyState()) != 5) {
                    throw new VersionException(String.format("Cannot remove property. Node [%s] is checked in.", NodeImpl.this.getNodePath()));
                }
            }

            @Override
            @NotNull
            public Property perform() throws RepositoryException {
                PropertyDelegate property = ((NodeDelegate)NodeImpl.this.dlg).getPropertyOrNull(oakName);
                if (property != null) {
                    property.remove();
                } else {
                    property = ((NodeDelegate)NodeImpl.this.dlg).getProperty(oakName);
                }
                return new PropertyImpl(property, NodeImpl.this.sessionContext);
            }

            @Override
            public String toString() {
                return String.format("removeProperty [%s]", jcrName);
            }
        });
    }

    @Override
    public void rename(final String newName) throws RepositoryException {
        if (((NodeDelegate)this.dlg).isRoot()) {
            throw new RepositoryException("Cannot rename the root node");
        }
        final String name = this.getName();
        if (newName.equals(name)) {
            return;
        }
        this.sessionDelegate.performVoid((SessionOperation<Void>)new ItemImpl.ItemWriteOperation<Void>("rename"){

            @Override
            public void performVoid() throws RepositoryException {
                Node parent = NodeImpl.this.getParent();
                String beforeName = null;
                if (NodeImpl.isOrderable(parent)) {
                    NodeIterator nit = parent.getNodes();
                    while (nit.hasNext()) {
                        Node child = nit.nextNode();
                        if (!name.equals(child.getName())) continue;
                        if (!nit.hasNext()) break;
                        beforeName = nit.nextNode().getName();
                        break;
                    }
                }
                String srcPath = NodeImpl.this.getPath();
                String destPath = "/" + newName;
                String parentPath = parent.getPath();
                if (!"/".equals(parentPath)) {
                    destPath = parentPath + destPath;
                }
                NodeImpl.this.sessionContext.getSession().move(srcPath, destPath);
                if (beforeName != null) {
                    parent.orderBefore(newName, beforeName);
                }
            }
        });
    }

    private static boolean isOrderable(Node node) throws RepositoryException {
        NodeType[] types;
        if (node.getPrimaryNodeType().hasOrderableChildNodes()) {
            return true;
        }
        for (NodeType type : types = node.getMixinNodeTypes()) {
            if (!type.hasOrderableChildNodes()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setMixins(String[] mixinNames) throws RepositoryException {
        final LinkedHashSet<String> oakTypeNames = Sets.newLinkedHashSet();
        for (String mixinName : mixinNames) {
            oakTypeNames.add(this.getOakName(Preconditions.checkNotNull(mixinName)));
        }
        this.sessionDelegate.performVoid((SessionOperation<Void>)new ItemImpl.ItemWriteOperation<Void>("setMixins"){

            @Override
            public void checkPreconditions() throws RepositoryException {
                super.checkPreconditions();
                if (!NodeImpl.this.internalIsCheckedOut()) {
                    throw new VersionException(String.format("Cannot set mixin types. Node [%s] is checked in.", NodeImpl.this.getNodePath()));
                }
                PropertyDelegate mixinProp = ((NodeDelegate)NodeImpl.this.dlg).getPropertyOrNull("jcr:mixinTypes");
                if (mixinProp != null) {
                    NodeImpl.this.sessionContext.getAccessManager().checkPermissions(((NodeDelegate)NodeImpl.this.dlg).getTree(), mixinProp.getPropertyState(), 512L);
                }
            }

            @Override
            public void performVoid() throws RepositoryException {
                ((NodeDelegate)NodeImpl.this.dlg).setMixins(oakTypeNames);
            }
        });
    }

    @Override
    @Nullable
    public JackrabbitNode getNodeOrNull(@NotNull String relPath) throws RepositoryException {
        final String oakPath = this.getOakPathOrThrowNotFound(relPath);
        return this.sessionDelegate.performNullable(new NodeOperation<JackrabbitNode>((NodeDelegate)this.dlg, "getNodeOrNull"){

            @Override
            @Nullable
            public JackrabbitNode performNullable() throws RepositoryException {
                NodeDelegate nd = this.node.getChild(oakPath);
                if (nd == null) {
                    return null;
                }
                return NodeImpl.createNode(nd, NodeImpl.this.sessionContext);
            }
        });
    }

    @Override
    @Nullable
    public Property getPropertyOrNull(@NotNull String relPath) throws RepositoryException {
        final String oakPath = this.getOakPathOrThrowNotFound(relPath);
        return this.sessionDelegate.performNullable(new NodeOperation<PropertyImpl>((NodeDelegate)this.dlg, "getPropertyOrNull"){

            @Override
            @Nullable
            public PropertyImpl performNullable() throws RepositoryException {
                PropertyDelegate pd = this.node.getPropertyOrNull(oakPath);
                if (pd == null) {
                    return null;
                }
                return new PropertyImpl(pd, NodeImpl.this.sessionContext);
            }
        });
    }

    private String getNodePath() {
        return ((NodeDelegate)this.dlg).getPath();
    }

    private int getOPV(Tree nodeTree, PropertyState property) throws RepositoryException {
        return this.getNodeTypeManager().getDefinition(nodeTree, property, false).getOnParentVersion();
    }

    private static class PropertyIteratorDelegate {
        private final NodeDelegate node;
        private final Predicate<PropertyDelegate> predicate;

        PropertyIteratorDelegate(NodeDelegate node, Predicate<PropertyDelegate> predicate) {
            this.node = node;
            this.predicate = predicate;
        }

        public Iterator<PropertyDelegate> iterator() throws InvalidItemStateException {
            return Iterators.filter(this.node.getProperties(), this.predicate);
        }

        public long getSize() {
            try {
                return Iterators.size(this.iterator());
            }
            catch (InvalidItemStateException e) {
                throw new IllegalStateException("This iterator is no longer valid", e);
            }
        }
    }
}

