/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.version;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.jcr.delegate.NodeDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.PropertyDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.VersionDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.VersionHistoryDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.VersionManagerDelegate;
import org.apache.jackrabbit.oak.jcr.session.NodeImpl;
import org.apache.jackrabbit.oak.jcr.session.SessionContext;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;
import org.apache.jackrabbit.oak.jcr.version.VersionHistoryImpl;
import org.apache.jackrabbit.oak.plugins.value.Conversions;
import org.apache.jackrabbit.oak.plugins.value.jcr.PartialValueFactory;
import org.jetbrains.annotations.NotNull;

public class VersionImpl
extends NodeImpl<VersionDelegate>
implements Version {
    public VersionImpl(VersionDelegate dlg, SessionContext sessionContext) {
        super(dlg, sessionContext);
    }

    public VersionHistory getContainingHistory() throws RepositoryException {
        return this.perform(new SessionOperation<VersionHistory>("getContainingHistory"){

            @Override
            @NotNull
            public VersionHistory perform() throws RepositoryException {
                return new VersionHistoryImpl(VersionImpl.this.getVersionManagerDelegate().createVersionHistory(((VersionDelegate)VersionImpl.this.dlg).getParent()), VersionImpl.this.sessionContext);
            }
        });
    }

    public Calendar getCreated() throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Calendar>("getCreated"){

            @Override
            @NotNull
            public Calendar perform() throws RepositoryException {
                PropertyDelegate dlg = VersionImpl.this.getPropertyOrThrow("jcr:created");
                return Conversions.convert(dlg.getDate()).toCalendar();
            }
        });
    }

    public Version getLinearPredecessor() throws RepositoryException {
        return this.sessionDelegate.performNullable(new SessionOperation<Version>("getLinearPredecessor"){

            @Override
            public Version performNullable() throws RepositoryException {
                VersionDelegate predecessor = ((VersionDelegate)VersionImpl.this.dlg).getLinearPredecessor();
                if (predecessor == null) {
                    return null;
                }
                return new VersionImpl(predecessor, VersionImpl.this.sessionContext);
            }
        });
    }

    public Version getLinearSuccessor() throws RepositoryException {
        return this.sessionDelegate.performNullable(new SessionOperation<Version>("getLinearSuccessor"){

            @Override
            public Version performNullable() throws RepositoryException {
                VersionHistoryDelegate vHistory = VersionImpl.this.getVersionManagerDelegate().createVersionHistory(((VersionDelegate)VersionImpl.this.dlg).getParent());
                Iterator<VersionDelegate> it = vHistory.getAllLinearVersions();
                while (it.hasNext()) {
                    VersionDelegate vDlg = it.next();
                    if (!vDlg.getIdentifier().equals(((VersionDelegate)VersionImpl.this.dlg).getIdentifier()) || !it.hasNext()) continue;
                    return new VersionImpl(it.next(), VersionImpl.this.sessionContext);
                }
                return null;
            }
        });
    }

    private List<Value> getValues(PropertyDelegate p) throws InvalidItemStateException, ValueFormatException {
        return new PartialValueFactory(this.sessionContext, this.sessionContext.getBlobAccessProvider()).createValues(p.getMultiState());
    }

    public Version[] getPredecessors() throws RepositoryException {
        return this.perform(new SessionOperation<Version[]>("getPredecessors"){

            @Override
            @NotNull
            public Version[] perform() throws RepositoryException {
                ArrayList<VersionImpl> predecessors = new ArrayList<VersionImpl>();
                for (VersionDelegate vDelegate : ((VersionDelegate)VersionImpl.this.dlg).getPredecessors()) {
                    predecessors.add(new VersionImpl(vDelegate, VersionImpl.this.sessionContext));
                }
                return predecessors.toArray(new Version[predecessors.size()]);
            }
        });
    }

    public Version[] getSuccessors() throws RepositoryException {
        return this.perform(new SessionOperation<Version[]>("getSuccessors"){

            @Override
            @NotNull
            public Version[] perform() throws RepositoryException {
                PropertyDelegate p = VersionImpl.this.getPropertyOrThrow("jcr:successors");
                ArrayList<VersionImpl> successors = new ArrayList<VersionImpl>();
                VersionManagerDelegate vMgr = VersionImpl.this.getVersionManagerDelegate();
                for (Value v : VersionImpl.this.getValues(p)) {
                    String id = v.getString();
                    successors.add(new VersionImpl(vMgr.getVersionByIdentifier(id), VersionImpl.this.sessionContext));
                }
                return successors.toArray(new Version[successors.size()]);
            }
        });
    }

    public Node getFrozenNode() throws RepositoryException {
        return this.perform(new SessionOperation<Node>("getFrozenNode"){

            @Override
            @NotNull
            public Node perform() throws RepositoryException {
                NodeDelegate frozenNode = ((VersionDelegate)VersionImpl.this.dlg).getChild("jcr:frozenNode");
                if (frozenNode == null) {
                    throw new IllegalStateException("Version without frozen node.");
                }
                return NodeImpl.createNode(frozenNode, VersionImpl.this.sessionContext);
            }
        });
    }

    @NotNull
    private VersionManagerDelegate getVersionManagerDelegate() {
        return VersionManagerDelegate.create(this.sessionContext.getSessionDelegate());
    }

    @NotNull
    private PropertyDelegate getPropertyOrThrow(@NotNull String name) throws RepositoryException {
        PropertyDelegate p = ((VersionDelegate)this.dlg).getPropertyOrNull(Preconditions.checkNotNull(name));
        if (p == null) {
            throw new RepositoryException("Inconsistent version storage. Version does not have a " + name + " property.");
        }
        return p;
    }
}

