/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.atomic;

import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.base.Strings;
import org.apache.jackrabbit.guava.common.collect.ImmutableMap;
import org.apache.jackrabbit.guava.common.collect.Iterators;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.memory.LongPropertyState;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.DefaultEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.SimpleCommitContext;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomicCounterEditor
extends DefaultEditor {
    public static final String PROP_INCREMENT = "oak:increment";
    public static final String PROP_COUNTER = "oak:counter";
    public static final String PREFIX_PROP_COUNTER = ":oak-counter-";
    public static final String PREFIX_PROP_REVISION = ":rev-";
    private static final Logger LOG = LoggerFactory.getLogger(AtomicCounterEditor.class);
    private final NodeBuilder builder;
    private final String path;
    private final String instanceId;
    private final ScheduledExecutorService executor;
    private final NodeStore store;
    private final Whiteboard board;
    private final String counterName;
    private final String revisionName;
    private boolean update;

    public AtomicCounterEditor(@NotNull NodeBuilder builder, @Nullable String instanceId, @Nullable ScheduledExecutorService executor, @Nullable NodeStore store, @Nullable Whiteboard board) {
        this("", Preconditions.checkNotNull(builder), instanceId, executor, store, board);
    }

    private AtomicCounterEditor(String path, NodeBuilder builder, @Nullable String instanceId, @Nullable ScheduledExecutorService executor, @Nullable NodeStore store, @Nullable Whiteboard board) {
        this.builder = Preconditions.checkNotNull(builder);
        this.path = path;
        this.instanceId = Strings.isNullOrEmpty(instanceId) ? null : instanceId;
        this.executor = executor;
        this.store = store;
        this.board = board;
        this.counterName = instanceId == null ? PREFIX_PROP_COUNTER : PREFIX_PROP_COUNTER + instanceId;
        this.revisionName = instanceId == null ? PREFIX_PROP_REVISION : PREFIX_PROP_REVISION + instanceId;
    }

    private static boolean shallWeProcessProperty(PropertyState property, String path, NodeBuilder builder) {
        boolean process = false;
        PropertyState mixin = Preconditions.checkNotNull(builder).getProperty("jcr:mixinTypes");
        if (mixin != null && PROP_INCREMENT.equals(property.getName()) && Iterators.contains(mixin.getValue(Type.NAMES).iterator(), "mix:atomicCounter")) {
            if (Type.LONG.equals(property.getType())) {
                process = true;
            } else {
                LOG.warn("although the {} property is set is not of the right value: LONG. Not processing node: {}.", (Object)PROP_INCREMENT, (Object)path);
            }
        }
        return process;
    }

    public static void consolidateCount(@NotNull NodeBuilder builder) {
        long count = 0L;
        for (PropertyState propertyState : builder.getProperties()) {
            if (!propertyState.getName().startsWith(PREFIX_PROP_COUNTER)) continue;
            count += propertyState.getValue(Type.LONG).longValue();
        }
        builder.setProperty(PROP_COUNTER, count);
    }

    private void setUniqueCounter(long value) {
        this.update = true;
        PropertyState counter = this.builder.getProperty(this.counterName);
        PropertyState revision = this.builder.getProperty(this.revisionName);
        long currentValue = 0L;
        if (counter != null) {
            currentValue = counter.getValue(Type.LONG);
        }
        long currentRevision = 0L;
        if (revision != null) {
            currentRevision = revision.getValue(Type.LONG);
        }
        this.builder.setProperty(this.counterName, currentValue += value, Type.LONG);
        this.builder.setProperty(this.revisionName, ++currentRevision, Type.LONG);
    }

    @Override
    public void propertyAdded(PropertyState after) throws CommitFailedException {
        if (AtomicCounterEditor.shallWeProcessProperty(after, this.path, this.builder)) {
            this.setUniqueCounter(after.getValue(Type.LONG));
            this.builder.removeProperty(PROP_INCREMENT);
        }
    }

    @Override
    public Editor childNodeAdded(String name, NodeState after) throws CommitFailedException {
        return new AtomicCounterEditor(this.path + "/" + name, this.builder.getChildNode(name), this.instanceId, this.executor, this.store, this.board);
    }

    @Override
    public Editor childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
        return new AtomicCounterEditor(this.path + "/" + name, this.builder.getChildNode(name), this.instanceId, this.executor, this.store, this.board);
    }

    @Override
    public void leave(NodeState before, NodeState after) throws CommitFailedException {
        if (this.update) {
            if (this.instanceId == null || this.store == null || this.executor == null || this.board == null) {
                LOG.trace("Executing synchronously. instanceId: {}, store: {}, executor: {}, board: {}", new Object[]{this.instanceId, this.store, this.executor, this.board});
                AtomicCounterEditor.consolidateCount(this.builder);
            } else {
                CommitHook hook = WhiteboardUtils.getService(this.board, CommitHook.class);
                if (hook == null) {
                    LOG.trace("CommitHook not registered with Whiteboard. Falling back to sync.");
                    AtomicCounterEditor.consolidateCount(this.builder);
                } else {
                    long delay = 500L;
                    ConsolidatorTask t = new ConsolidatorTask(this.path, this.builder.getProperty(this.revisionName), this.store, this.executor, delay, hook);
                    LOG.debug("[{}] Scheduling process by {}ms", (Object)t.getName(), (Object)delay);
                    this.executor.schedule(t, delay, TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    static boolean checkRevision(@NotNull NodeBuilder builder, @Nullable PropertyState revision) {
        long rValue;
        if (revision == null) {
            return true;
        }
        String pName = revision.getName();
        PropertyState builderRev = builder.getProperty(pName);
        if (builderRev == null) {
            return false;
        }
        long brValue = builderRev.getValue(Type.LONG);
        return brValue >= (rValue = revision.getValue(Type.LONG).longValue());
    }

    private static NodeBuilder builderFromPath(@NotNull NodeBuilder ancestor, @NotNull String path) {
        NodeBuilder b = Preconditions.checkNotNull(ancestor);
        for (String name : PathUtils.elements(Preconditions.checkNotNull(path))) {
            b = b.getChildNode(name);
        }
        return b;
    }

    static boolean isConsolidate(@NotNull NodeBuilder b) {
        Preconditions.checkNotNull(b);
        PropertyState counter = b.getProperty(PROP_COUNTER);
        if (counter == null) {
            counter = LongPropertyState.createLongProperty(PROP_COUNTER, 0L);
        }
        long hiddensum = 0L;
        for (PropertyState propertyState : b.getProperties()) {
            if (!propertyState.getName().startsWith(PREFIX_PROP_COUNTER)) continue;
            hiddensum += propertyState.getValue(Type.LONG).longValue();
        }
        return counter.getValue(Type.LONG) != hiddensum;
    }

    private static CommitInfo createCommitInfo() {
        ImmutableMap<String, Object> info = ImmutableMap.of("oak.commitAttributes", new SimpleCommitContext());
        return new CommitInfo("oak:unknown", "oak:unknown", info);
    }

    public static class ConsolidatorTask
    implements Callable<Void> {
        public static final long MAX_TIMEOUT = Long.getLong("oak.atomiccounter.task.timeout", 32000L);
        public static final long MIN_TIMEOUT = 500L;
        private final String name;
        private final String p;
        private final PropertyState rev;
        private final NodeStore s;
        private final ScheduledExecutorService exec;
        private final long delay;
        private final long start;
        private final CommitHook hook;

        public ConsolidatorTask(@NotNull String path, @Nullable PropertyState revision, @NotNull NodeStore store, @NotNull ScheduledExecutorService exec, long delay, @NotNull CommitHook hook) {
            this.start = System.currentTimeMillis();
            this.p = Preconditions.checkNotNull(path);
            this.rev = revision;
            this.s = Preconditions.checkNotNull(store);
            this.exec = Preconditions.checkNotNull(exec);
            this.delay = delay;
            this.hook = Preconditions.checkNotNull(hook);
            this.name = UUID.randomUUID().toString();
        }

        private ConsolidatorTask(@NotNull ConsolidatorTask task, long delay) {
            Preconditions.checkNotNull(task);
            this.p = task.p;
            this.rev = task.rev;
            this.s = task.s;
            this.exec = task.exec;
            this.delay = delay;
            this.hook = task.hook;
            this.name = task.name;
            this.start = task.start;
        }

        @Override
        public Void call() throws Exception {
            try {
                LOG.debug("[{}] Async consolidation running: path: {}, revision: {}", new Object[]{this.name, this.p, this.rev});
                NodeBuilder root = this.s.getRoot().builder();
                NodeBuilder b = AtomicCounterEditor.builderFromPath(root, this.p);
                this.dumpNode(b, this.p);
                if (!b.exists()) {
                    LOG.debug("[{}] Builder for '{}' from NodeStore not available. Rescheduling.", (Object)this.name, (Object)this.p);
                    this.reschedule();
                    return null;
                }
                if (!AtomicCounterEditor.checkRevision(b, this.rev)) {
                    LOG.debug("[{}] Missing or not yet a valid revision for '{}'. Rescheduling.", (Object)this.name, (Object)this.p);
                    this.reschedule();
                    return null;
                }
                if (AtomicCounterEditor.isConsolidate(b)) {
                    LOG.trace("[{}] consolidating.", (Object)this.name);
                    AtomicCounterEditor.consolidateCount(b);
                    this.s.merge(root, this.hook, AtomicCounterEditor.createCommitInfo());
                } else {
                    LOG.debug("[{}] Someone else consolidated. Skipping any operation.", (Object)this.name);
                }
            }
            catch (Exception e) {
                LOG.debug("[{}] caught Exception. Rescheduling. {}", (Object)this.name, (Object)e.getMessage());
                if (LOG.isTraceEnabled()) {
                    LOG.trace("[{}] caught Exception. Rescheduling.", (Object)this.name, (Object)e);
                }
                this.reschedule();
                return null;
            }
            LOG.debug("[{}] Consolidation for '{}', '{}' completed in {}ms", new Object[]{this.name, this.p, this.rev, System.currentTimeMillis() - this.start});
            return null;
        }

        private void dumpNode(@NotNull NodeBuilder b, String path) {
            if (LOG.isTraceEnabled()) {
                Preconditions.checkNotNull(b);
                StringBuilder s = new StringBuilder();
                for (PropertyState propertyState : b.getProperties()) {
                    s.append(propertyState).append("\n");
                }
                LOG.trace("[{}] Node status for {}:\n{}", new Object[]{this.name, path, s});
            }
        }

        private void reschedule() {
            long d = ConsolidatorTask.nextDelay(this.delay);
            if (ConsolidatorTask.isTimedOut(d)) {
                LOG.warn("[{}] The consolidator task for '{}' timed out. Cancelling the retry.", (Object)this.name, (Object)this.p);
                return;
            }
            ConsolidatorTask task = new ConsolidatorTask(this, d);
            LOG.debug("[{}] Rescheduling '{}' by {}ms", new Object[]{task.getName(), this.p, d});
            this.exec.schedule(task, d, TimeUnit.MILLISECONDS);
        }

        public static long nextDelay(long currentDelay) {
            if (currentDelay < 500L) {
                return 500L;
            }
            if (currentDelay >= MAX_TIMEOUT) {
                return Long.MAX_VALUE;
            }
            return currentDelay * 2L;
        }

        public static boolean isTimedOut(long delay) {
            return delay > MAX_TIMEOUT;
        }

        public String getName() {
            return this.name;
        }
    }
}

