/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.cache.AbstractCache;
import org.apache.jackrabbit.guava.common.cache.CacheLoader;
import org.apache.jackrabbit.guava.common.util.concurrent.ListeningExecutorService;
import org.apache.jackrabbit.oak.plugins.blob.DataStoreCacheStatsMBean;
import org.apache.jackrabbit.oak.plugins.blob.FileCache;
import org.apache.jackrabbit.oak.plugins.blob.StagingUploader;
import org.apache.jackrabbit.oak.plugins.blob.UploadStagingCache;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeDataStoreCache
extends AbstractCache<String, File>
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeDataStoreCache.class);
    private final FileCache downloadCache;
    private final UploadStagingCache stagingCache;
    private final File directory;

    public CompositeDataStoreCache(String path, File home, long size, int uploadSplitPercentage, int uploadThreads, CacheLoader<String, InputStream> loader, StagingUploader uploader, StatisticsProvider statsProvider, ListeningExecutorService listeningExecutor, ScheduledExecutorService scheduledExecutor, ExecutorService executor, int purgeInterval, int stagingRetryInterval) {
        Preconditions.checkArgument(uploadSplitPercentage >= 0 && uploadSplitPercentage < 100, "Upload percentage should be between 0 and 100");
        this.directory = new File(path);
        long uploadSize = size * (long)uploadSplitPercentage / 100L;
        this.stagingCache = UploadStagingCache.build(this.directory, home, uploadThreads, uploadSize, uploader, null, statsProvider, listeningExecutor, scheduledExecutor, purgeInterval, stagingRetryInterval);
        this.downloadCache = FileCache.build(size - uploadSize, this.directory, loader, executor);
        this.stagingCache.setDownloadCache(this.downloadCache);
    }

    @Nullable
    public File getIfPresent(String key) {
        File staged = this.stagingCache.getIfPresent(key);
        if (staged != null && staged.exists()) {
            return staged;
        }
        return this.downloadCache.getIfPresent(key);
    }

    @Override
    @Nullable
    public File getIfPresent(Object key) {
        return this.getIfPresent((String)key);
    }

    public File get(String key) throws IOException {
        try {
            File staged = this.stagingCache.getIfPresent(key);
            if (staged != null && staged.exists()) {
                return staged;
            }
            return this.downloadCache.get(key);
        }
        catch (IOException e) {
            LOG.error("Error loading [{}] from cache", (Object)key);
            throw e;
        }
    }

    @Override
    public void invalidate(Object key) {
        this.stagingCache.invalidate((String)key);
        this.downloadCache.invalidate(key);
    }

    public boolean stage(String key, File file) {
        return this.stagingCache.put(key, file).isPresent();
    }

    public DataStoreCacheStatsMBean getStagingCacheStats() {
        return this.stagingCache.getStats();
    }

    public DataStoreCacheStatsMBean getCacheStats() {
        return this.downloadCache.getStats();
    }

    @Override
    public void close() {
        this.downloadCache.close();
        this.stagingCache.close();
    }

    UploadStagingCache getStagingCache() {
        return this.stagingCache;
    }

    FileCache getDownloadCache() {
        return this.downloadCache;
    }
}

