/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.jackrabbit.oak.OakVersion;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.plugins.index.IndexingReporter;
import org.jetbrains.annotations.NotNull;

public class ConsoleIndexingReporter
implements IndexingReporter {
    private final Map<String, String> config = new TreeMap<String, String>();
    private final Map<String, String> timings = new LinkedHashMap<String, String>();
    private final Map<String, String> metrics = new TreeMap<String, String>();
    private final List<String> envVariablesToLog;
    private List<String> indexes = List.of();

    public ConsoleIndexingReporter() {
        this(List.of());
    }

    public ConsoleIndexingReporter(@NotNull List<String> envVariablesToLog) {
        this.envVariablesToLog = List.copyOf(envVariablesToLog);
    }

    @Override
    public void setIndexNames(@NotNull List<String> indexes) {
        this.indexes = List.copyOf(indexes);
    }

    @Override
    public void addConfig(String key, Object value) {
        this.config.put(key, value.toString());
    }

    @Override
    public void addTiming(String stage, String time) {
        this.timings.put(stage, time);
    }

    @Override
    public void addMetric(String name, long value) {
        this.metrics.put(name, String.valueOf(value));
    }

    @Override
    public void addMetricByteSize(String name, long value) {
        Object v = String.valueOf(value);
        if (value >= 1024L) {
            v = (String)v + " (" + IOUtils.humanReadableByteCountBin(value) + ")";
        }
        this.metrics.put(name, (String)v);
    }

    @Override
    public String generateReport() {
        return "Indexes: " + String.join((CharSequence)", ", this.indexes) + "\nDate: " + DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(ZonedDateTime.now()) + "\nOAK Version: " + OakVersion.getVersion() + "\nConfiguration:\n" + this.mapToString(this.config) + "\nEnvironment Variables:\n" + this.genEnvVariables() + "\nTimings:\n" + this.mapToString(this.timings) + "\nMetrics:\n" + this.mapToString(this.metrics);
    }

    private String genEnvVariables() {
        return this.envVariablesToLog.stream().sorted().map(var -> "  " + var + ": " + System.getenv(var)).collect(Collectors.joining("\n"));
    }

    private String mapToString(Map<String, String> map) {
        return map.entrySet().stream().map(entry -> "  " + (String)entry.getKey() + ": " + (String)entry.getValue()).collect(Collectors.joining("\n"));
    }
}

