/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index;

import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.guava.common.base.Stopwatch;

public class FormattingUtils {
    public static String formatToSeconds(Stopwatch stopwatch) {
        return FormattingUtils.formatToSeconds(stopwatch.elapsed(TimeUnit.SECONDS));
    }

    public static String formatToSeconds(long seconds) {
        long absSeconds = Math.abs(seconds);
        long hoursPart = TimeUnit.SECONDS.toHours(absSeconds);
        long minutesPart = TimeUnit.SECONDS.toMinutes(absSeconds) % 60L;
        long secondsPart = TimeUnit.SECONDS.toSeconds(absSeconds) % 60L;
        String sign = seconds < 0L ? "-" : "";
        return String.format("%s%02d:%02d:%02d", sign, hoursPart, minutesPart, secondsPart);
    }

    public static String formatToMillis(Stopwatch stopwatch) {
        long millis = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        long absMillis = Math.abs(millis);
        long hoursPart = TimeUnit.MILLISECONDS.toHours(absMillis);
        long minutesPart = TimeUnit.MILLISECONDS.toMinutes(absMillis) % 60L;
        long secondsPart = TimeUnit.MILLISECONDS.toSeconds(absMillis) % 60L;
        long millisPart = TimeUnit.MILLISECONDS.toMillis(absMillis) % 1000L;
        String sign = millis < 0L ? "-" : "";
        return String.format("%s%02d:%02d:%02d.%03d", sign, hoursPart, minutesPart, secondsPart, millisPart);
    }
}

