/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.importer;

import java.util.Collections;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.collect.ImmutableMap;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.commit.AnnotatingConflictHandler;
import org.apache.jackrabbit.oak.plugins.commit.ConflictHook;
import org.apache.jackrabbit.oak.plugins.commit.ConflictValidatorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateProvider;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.CompositeEditorProvider;
import org.apache.jackrabbit.oak.spi.commit.CompositeHook;
import org.apache.jackrabbit.oak.spi.commit.EditorHook;
import org.apache.jackrabbit.oak.spi.commit.ResetCommitAttributeHook;
import org.apache.jackrabbit.oak.spi.commit.SimpleCommitContext;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeStore;

final class NodeStoreUtils {
    NodeStoreUtils() {
    }

    static void mergeWithConcurrentCheck(NodeStore nodeStore, NodeBuilder builder) throws CommitFailedException {
        CompositeHook hooks = new CompositeHook(ResetCommitAttributeHook.INSTANCE, new ConflictHook(new AnnotatingConflictHandler()), new EditorHook(CompositeEditorProvider.compose(Collections.singletonList(new ConflictValidatorProvider()))));
        nodeStore.merge(builder, hooks, NodeStoreUtils.createCommitInfo());
    }

    static void mergeWithConcurrentCheck(NodeStore nodeStore, NodeBuilder builder, IndexEditorProvider indexEditorProvider) throws CommitFailedException {
        CompositeHook hooks = new CompositeHook(ResetCommitAttributeHook.INSTANCE, new EditorHook(new IndexUpdateProvider(indexEditorProvider, null, true)), new ConflictHook(new AnnotatingConflictHandler()), new EditorHook(CompositeEditorProvider.compose(Collections.singletonList(new ConflictValidatorProvider()))));
        nodeStore.merge(builder, hooks, NodeStoreUtils.createCommitInfo());
    }

    static NodeBuilder childBuilder(NodeBuilder nb, String path) {
        for (String name : PathUtils.elements(Preconditions.checkNotNull(path))) {
            nb = nb.child(name);
        }
        return nb;
    }

    private static CommitInfo createCommitInfo() {
        ImmutableMap<String, Object> info = ImmutableMap.of("oak.commitAttributes", new SimpleCommitContext());
        return new CommitInfo("oak:unknown", "oak:unknown", info);
    }
}

