/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.importer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.jackrabbit.guava.common.base.Preconditions;

final class PropUtils {
    PropUtils() {
    }

    static Properties loadFromFile(File file) throws IOException {
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
            Properties p = new Properties();
            p.load(is);
            Properties properties = p;
            return properties;
        }
    }

    static String getProp(Properties p, String key) {
        return Preconditions.checkNotNull(p.getProperty(key), "No property named [%s] found", (Object)key);
    }

    static void writeTo(Properties p, File file, String comment) throws IOException {
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
            p.store(os, comment);
        }
    }
}

