/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property;

import java.util.function.Supplier;
import org.apache.jackrabbit.guava.common.base.Stopwatch;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecursiveDelete {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final NodeStore nodeStore;
    private final CommitHook commitHook;
    private final Supplier<CommitInfo> commitInfo;
    private int batchSize = 1024;
    private int sleepPerBatch;
    private int maxRemoveCount = Integer.MAX_VALUE;
    private int numRemoved;
    private int mergeCount;
    private NodeBuilder builder;

    public RecursiveDelete(NodeStore nodeStore, CommitHook commitHook, Supplier<CommitInfo> commitInfo) {
        this.nodeStore = nodeStore;
        this.commitHook = commitHook;
        this.commitInfo = commitInfo;
    }

    public void run(Iterable<String> paths) throws CommitFailedException {
        Stopwatch w = Stopwatch.createStarted();
        NodeState root = this.nodeStore.getRoot();
        this.builder = root.builder();
        int currentSize = 0;
        for (String path : paths) {
            NodeState node = NodeStateUtils.getNode(root, path);
            currentSize = this.delete(node, path);
            this.save(path, currentSize, false);
        }
        String pathDetails = Iterables.toString(paths);
        this.save(pathDetails, currentSize, true);
        this.log.debug("Removed subtree under [{}] with {} child nodes in {} ({} saves)", new Object[]{pathDetails, this.numRemoved, w, this.mergeCount});
    }

    public void run(String path) throws CommitFailedException {
        NodeState root = this.nodeStore.getRoot();
        this.builder = root.builder();
        NodeState node = NodeStateUtils.getNode(root, path);
        Stopwatch w = Stopwatch.createStarted();
        int currentSize = this.delete(node, path);
        this.save(path, currentSize, true);
        this.log.debug("Removed subtree under [{}] with {} child nodes in {} ({} saves)", new Object[]{path, this.numRemoved, w, this.mergeCount});
    }

    public int getNumRemoved() {
        return this.numRemoved;
    }

    public int getMergeCount() {
        return this.mergeCount;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    private int delete(NodeState node, String path) throws CommitFailedException {
        int currentSize = this.deleteChildNodes(node, path);
        if (this.numRemoved >= this.maxRemoveCount) {
            return currentSize;
        }
        RecursiveDelete.child(this.builder, path).remove();
        ++this.numRemoved;
        return currentSize + 1;
    }

    private int deleteChildNodes(NodeState node, String path) throws CommitFailedException {
        int currentSize = 0;
        for (ChildNodeEntry childNodeEntry : node.getChildNodeEntries()) {
            String name = childNodeEntry.getName();
            String childPath = PathUtils.concat(path, name);
            if (this.save(childPath, currentSize += this.delete(childNodeEntry.getNodeState(), childPath), false)) {
                currentSize = 0;
            }
            if (this.numRemoved < this.maxRemoveCount) continue;
            break;
        }
        return currentSize;
    }

    private boolean save(String pathDetails, int currentSize, boolean force) throws CommitFailedException {
        if (currentSize >= this.batchSize || force) {
            this.log.debug("Deleting {} nodes under {} ({} removed so far)", new Object[]{currentSize, pathDetails, this.numRemoved});
            this.nodeStore.merge(this.builder, this.commitHook, this.commitInfo.get());
            this.builder = this.nodeStore.getRoot().builder();
            ++this.mergeCount;
            if (this.sleepPerBatch > 0) {
                try {
                    Thread.sleep(this.sleepPerBatch);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    private static NodeBuilder child(NodeBuilder nb, String path) {
        for (String name : PathUtils.elements(path)) {
            nb = nb.getChildNode(name);
        }
        return nb;
    }

    public int getMaxRemoveCount() {
        return this.maxRemoveCount;
    }

    public void setMaxRemoveCount(int maxRemoveCount) {
        this.maxRemoveCount = maxRemoveCount;
    }

    public int getSleepPerBatch() {
        return this.sleepPerBatch;
    }

    public void setSleepPerBatch(int sleepPerBatch) {
        this.sleepPerBatch = sleepPerBatch;
    }
}

