/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import java.util.Map;
import org.apache.jackrabbit.guava.common.base.Function;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.oak.spi.state.AbstractChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class MemoryChildNodeEntry
extends AbstractChildNodeEntry {
    private final String name;
    private final NodeState node;

    public static <E extends Map.Entry<String, ? extends NodeState>> Iterable<ChildNodeEntry> iterable(Iterable<E> set) {
        return Iterables.transform(set, new Function<Map.Entry<String, ? extends NodeState>, ChildNodeEntry>(){

            @Override
            public ChildNodeEntry apply(Map.Entry<String, ? extends NodeState> entry) {
                return new MemoryChildNodeEntry(entry.getKey(), entry.getValue());
            }
        });
    }

    public MemoryChildNodeEntry(String name, NodeState node) {
        this.name = Preconditions.checkNotNull(name);
        this.node = Preconditions.checkNotNull(node);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public NodeState getNodeState() {
        return this.node;
    }
}

