/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.guava.common.base.MoreObjects;
import org.apache.jackrabbit.guava.common.base.Objects;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.io.ByteStreams;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.memory.ArrayBasedBlob;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MutableNodeState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeState;
import org.apache.jackrabbit.oak.spi.state.EqualsDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryNodeBuilder
implements NodeBuilder {
    private final MemoryNodeBuilder parent;
    private final String name;
    private final MemoryNodeBuilder rootBuilder;
    private long baseRevision;
    @NotNull
    private NodeState base;
    private final RootHead rootHead;
    private Head head;

    protected MemoryNodeBuilder(MemoryNodeBuilder parent, String name) {
        this.parent = parent;
        this.name = name;
        this.rootBuilder = parent.rootBuilder;
        this.base = parent.base().getChildNode(name);
        this.baseRevision = parent.baseRevision;
        this.rootHead = parent.rootHead;
        this.head = new UnconnectedHead(this, this.base);
    }

    public MemoryNodeBuilder(@NotNull NodeState base) {
        this.parent = null;
        this.name = null;
        this.rootBuilder = this;
        this.baseRevision = 0L;
        this.base = Preconditions.checkNotNull(base);
        this.rootHead = new RootHead(this);
        this.head = this.rootHead;
    }

    private Head head() {
        return this.head.update();
    }

    public final boolean isRoot() {
        return this == this.rootBuilder;
    }

    @NotNull
    private NodeState base() {
        if (this.rootBuilder.baseRevision != this.baseRevision) {
            this.base = this.parent.base().getChildNode(this.name);
            this.baseRevision = this.rootBuilder.baseRevision;
        }
        return this.base;
    }

    protected MemoryNodeBuilder createChildBuilder(String name) {
        return new MemoryNodeBuilder(this, name);
    }

    protected void updated() {
        if (this != this.rootBuilder) {
            this.rootBuilder.updated();
        }
    }

    protected final MemoryNodeBuilder getParent() {
        return this.parent;
    }

    protected final String getName() {
        return this.name;
    }

    public void reset(@NotNull NodeState newBase) {
        Preconditions.checkState(this.parent == null);
        this.base = Preconditions.checkNotNull(newBase);
        this.baseRevision = this.rootHead.setState(newBase) + 1L;
    }

    protected void set(NodeState newState) {
        if (this.parent == null) {
            this.baseRevision = this.rootHead.setState(newState);
        } else {
            this.parent.setChildNode(this.name, newState);
        }
    }

    @Override
    @NotNull
    public NodeState getNodeState() {
        return this.head().getImmutableNodeState();
    }

    @Override
    @NotNull
    public NodeState getBaseState() {
        return this.base();
    }

    @Override
    public boolean exists() {
        return this.head().getCurrentNodeState().exists();
    }

    @Override
    public boolean isNew() {
        return this.exists() && !this.getBaseState().exists();
    }

    @Override
    public boolean isNew(String name) {
        return this.hasProperty(name) && !this.getBaseState().hasProperty(name);
    }

    @Override
    public boolean isModified() {
        return this.head().isModified();
    }

    @Override
    public boolean isReplaced() {
        return this.head().isReplaced();
    }

    @Override
    public boolean isReplaced(String name) {
        return this.head().isReplaced(name);
    }

    @Override
    public long getChildNodeCount(long max) {
        return this.head().getCurrentNodeState().getChildNodeCount(max);
    }

    @Override
    @NotNull
    public Iterable<String> getChildNodeNames() {
        return this.head().getCurrentNodeState().getChildNodeNames();
    }

    @Override
    public boolean hasChildNode(@NotNull String name) {
        return this.head().getCurrentNodeState().hasChildNode(Preconditions.checkNotNull(name));
    }

    @Override
    @NotNull
    public NodeBuilder child(@NotNull String name) {
        if (this.hasChildNode(name)) {
            return this.getChildNode(name);
        }
        return this.setChildNode(name);
    }

    @Override
    @NotNull
    public NodeBuilder getChildNode(@NotNull String name) {
        AbstractNodeState.checkValidName(name);
        return this.createChildBuilder(name);
    }

    @Override
    @NotNull
    public NodeBuilder setChildNode(@NotNull String name) {
        return this.setChildNode(name, EmptyNodeState.EMPTY_NODE);
    }

    @Override
    @NotNull
    public NodeBuilder setChildNode(@NotNull String name, @NotNull NodeState state) {
        Preconditions.checkState(this.exists(), "This builder does not exist: " + this.name);
        this.head().getMutableNodeState().setChildNode(name, Preconditions.checkNotNull(state));
        MemoryNodeBuilder builder = this.createChildBuilder(name);
        this.updated();
        return builder;
    }

    @Override
    public boolean remove() {
        if (!this.isRoot() && this.exists()) {
            this.head().getMutableNodeState();
            this.parent.head().getMutableNodeState().removeChildNode(this.name);
            this.updated();
            return true;
        }
        return false;
    }

    @Override
    public boolean moveTo(@NotNull NodeBuilder newParent, @NotNull String newName) throws IllegalArgumentException {
        Preconditions.checkNotNull(newParent);
        AbstractNodeState.checkValidName(newName);
        if (this.isRoot() || !this.exists() || newParent.hasChildNode(newName)) {
            return false;
        }
        if (newParent.exists()) {
            this.annotateSourcePath();
            NodeState nodeState = this.getNodeState();
            newParent.setChildNode(newName, nodeState);
            this.remove();
            return true;
        }
        return false;
    }

    protected final void annotateSourcePath() {
        String sourcePath = this.getSourcePath();
        if (!this.isTransientlyAdded(sourcePath)) {
            this.setProperty(":source-path", sourcePath);
        }
    }

    private final String getSourcePath() {
        MemoryNodeBuilder builder = this;
        String sourcePath = MemoryNodeBuilder.getSourcePathAnnotation(builder);
        while (sourcePath == null && builder.parent != null) {
            builder = builder.parent;
            sourcePath = MemoryNodeBuilder.getSourcePathAnnotation(builder);
        }
        if (sourcePath == null) {
            return this.getPath();
        }
        return PathUtils.concat(sourcePath, PathUtils.relativize(builder.getPath(), this.getPath()));
    }

    private static String getSourcePathAnnotation(MemoryNodeBuilder builder) {
        PropertyState head;
        PropertyState base = builder.getBaseState().getProperty(":source-path");
        if (Objects.equal(base, head = builder.getNodeState().getProperty(":source-path"))) {
            return null;
        }
        return head != null ? head.getValue(Type.STRING) : null;
    }

    private boolean isTransientlyAdded(String path) {
        NodeState node = this.rootBuilder.getBaseState();
        for (String name : PathUtils.elements(path)) {
            node = node.getChildNode(name);
        }
        return !node.exists();
    }

    @Override
    public long getPropertyCount() {
        return this.head().getCurrentNodeState().getPropertyCount();
    }

    @Override
    @NotNull
    public Iterable<? extends PropertyState> getProperties() {
        return this.head().getCurrentNodeState().getProperties();
    }

    @Override
    public boolean hasProperty(String name) {
        return this.head().getCurrentNodeState().hasProperty(Preconditions.checkNotNull(name));
    }

    @Override
    public PropertyState getProperty(String name) {
        return this.head.update().getCurrentNodeState().getProperty(Preconditions.checkNotNull(name));
    }

    @Override
    public boolean getBoolean(@NotNull String name) {
        return this.head().getCurrentNodeState().getBoolean(Preconditions.checkNotNull(name));
    }

    @Override
    @Nullable
    public String getString(@NotNull String name) {
        return this.head().getCurrentNodeState().getString(Preconditions.checkNotNull(name));
    }

    @Override
    @Nullable
    public String getName(@NotNull String name) {
        return this.head().getCurrentNodeState().getName(Preconditions.checkNotNull(name));
    }

    @Override
    @NotNull
    public Iterable<String> getNames(@NotNull String name) {
        return this.head().getCurrentNodeState().getNames(Preconditions.checkNotNull(name));
    }

    @Override
    @NotNull
    public NodeBuilder setProperty(@NotNull PropertyState property) {
        Preconditions.checkState(this.exists(), "This builder does not exist: " + this.name);
        this.head().getMutableNodeState().setProperty(Preconditions.checkNotNull(property));
        this.updated();
        return this;
    }

    @Override
    @NotNull
    public <T> NodeBuilder setProperty(String name, @NotNull T value) {
        this.setProperty(PropertyStates.createProperty(name, value));
        return this;
    }

    @Override
    @NotNull
    public <T> NodeBuilder setProperty(String name, @NotNull T value, Type<T> type) {
        this.setProperty(PropertyStates.createProperty(name, value, type));
        return this;
    }

    @Override
    @NotNull
    public NodeBuilder removeProperty(String name) {
        Preconditions.checkState(this.exists(), "This builder does not exist: " + name);
        if (this.head().getMutableNodeState().removeProperty(Preconditions.checkNotNull(name))) {
            this.updated();
        }
        return this;
    }

    @Override
    public Blob createBlob(InputStream stream) throws IOException {
        try {
            ArrayBasedBlob arrayBasedBlob = new ArrayBasedBlob(ByteStreams.toByteArray(stream));
            return arrayBasedBlob;
        }
        finally {
            stream.close();
        }
    }

    public final String getPath() {
        return this.parent == null ? "/" : this.getPath(new StringBuilder()).toString();
    }

    private StringBuilder getPath(StringBuilder parentPath) {
        return this.parent == null ? parentPath : this.parent.getPath(parentPath).append('/').append(this.name);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("path", this.getPath()).toString();
    }

    private static class RootHead
    extends ConnectedHead {
        public RootHead(MemoryNodeBuilder builder) {
            super(builder, new MutableNodeState(builder.base));
        }

        @Override
        public Head update() {
            return this;
        }

        public final long setState(NodeState state) {
            this.state = new MutableNodeState(state);
            ++this.revision;
            return this.revision++;
        }
    }

    private static class ConnectedHead
    implements Head {
        private final MemoryNodeBuilder builder;
        protected long revision;
        protected MutableNodeState state;

        public ConnectedHead(MemoryNodeBuilder builder, MutableNodeState state) {
            this.builder = builder;
            this.revision = builder.rootBuilder.baseRevision;
            this.state = state;
        }

        @Override
        public Head update() {
            if (this.revision != this.builder.rootBuilder.baseRevision) {
                this.builder.head = new UnconnectedHead(this.builder, this.builder.base);
                return this.builder.head.update();
            }
            return this;
        }

        @Override
        public NodeState getCurrentNodeState() {
            return this.state;
        }

        @Override
        public MutableNodeState getMutableNodeState() {
            ++this.builder.rootHead.revision;
            return this.state;
        }

        @Override
        public NodeState getImmutableNodeState() {
            return this.state.snapshot();
        }

        @Override
        public boolean isModified() {
            return this.state.isModified(this.builder.base());
        }

        @Override
        public boolean isReplaced() {
            return this.state.isReplaced(this.builder.base());
        }

        @Override
        public boolean isReplaced(String name) {
            return this.state.isReplaced(this.builder.base(), name);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("path", this.builder.getPath()).toString();
        }
    }

    private static class UnconnectedHead
    implements Head {
        private final MemoryNodeBuilder builder;
        private final RootHead rootHead;
        private long revision;
        private NodeState state;

        UnconnectedHead(MemoryNodeBuilder builder, NodeState state) {
            this.builder = builder;
            this.rootHead = builder.rootHead;
            this.revision = builder.baseRevision;
            this.state = state;
        }

        @Override
        public Head update() {
            long rootRevision = this.rootHead.revision;
            if (this.revision != rootRevision) {
                NodeState parentState = this.builder.parent.head().getCurrentNodeState();
                NodeState newState = parentState.getChildNode(this.builder.name);
                if (newState instanceof MutableNodeState) {
                    this.builder.head = new ConnectedHead(this.builder, (MutableNodeState)newState);
                    return this.builder.head;
                }
                this.state = newState;
                this.revision = rootRevision;
            }
            return this;
        }

        @Override
        public NodeState getCurrentNodeState() {
            return this.state;
        }

        @Override
        public MutableNodeState getMutableNodeState() {
            MutableNodeState parentState = this.builder.parent.head().getMutableNodeState();
            MutableNodeState state = parentState.getMutableChildNode(this.builder.name);
            return new ConnectedHead(this.builder, state).getMutableNodeState();
        }

        @Override
        public NodeState getImmutableNodeState() {
            assert (!(this.state instanceof MutableNodeState));
            return this.state;
        }

        @Override
        public boolean isModified() {
            return EqualsDiff.modified(this.builder.base(), this.state);
        }

        @Override
        public boolean isReplaced() {
            return false;
        }

        @Override
        public boolean isReplaced(String name) {
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("path", this.builder.getPath()).toString();
        }
    }

    private static interface Head {
        public Head update();

        public NodeState getCurrentNodeState();

        public MutableNodeState getMutableNodeState();

        public NodeState getImmutableNodeState();

        public boolean isModified();

        public boolean isReplaced();

        public boolean isReplaced(String var1);
    }
}

