/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.metric;

import com.codahale.metrics.MetricRegistry;
import java.io.Closeable;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.management.MBeanServer;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.oak.commons.concurrent.ExecutorCloser;
import org.apache.jackrabbit.oak.plugins.metric.MetricStatisticsProvider;
import org.apache.jackrabbit.oak.stats.DefaultStatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Designate(ocd=Configuration.class)
public class StatisticsProviderFactory {
    private static final String TYPE_DEFAULT = "DEFAULT";
    private static final String TYPE_METRIC = "METRIC";
    private static final String TYPE_NONE = "NONE";
    private static final String TYPE_AUTO = "AUTO";
    private static final String METRIC_PROVIDER_CLASS = "com.codahale.metrics.MetricRegistry";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    private MBeanServer server;
    private StatisticsProvider statisticsProvider;
    private List<ServiceRegistration> regs = Lists.newArrayList();
    private ScheduledExecutorService executor;
    private BundleContext bundleContext;

    @Activate
    private void activate(BundleContext context, Configuration config) {
        this.bundleContext = context;
        this.statisticsProvider = this.createProvider(config.providerType());
        if (this.statisticsProvider != null) {
            this.regs.add(context.registerService(StatisticsProvider.class.getName(), (Object)this.statisticsProvider, null));
        }
    }

    @Deactivate
    private void deactivate() throws IOException {
        for (ServiceRegistration reg : this.regs) {
            reg.unregister();
        }
        this.regs.clear();
        if (this.statisticsProvider instanceof Closeable) {
            ((Closeable)((Object)this.statisticsProvider)).close();
        }
        new ExecutorCloser(this.executor).close();
    }

    private StatisticsProvider createProvider(String providerType) {
        if (TYPE_NONE.equals(providerType)) {
            this.log.info("No statistics provider created as {} option is selected", (Object)TYPE_NONE);
            return null;
        }
        this.executor = Executors.newSingleThreadScheduledExecutor();
        String effectiveProviderType = providerType;
        if (TYPE_AUTO.equals(providerType) && this.isMetricSupportPresent()) {
            effectiveProviderType = TYPE_METRIC;
        }
        if (TYPE_METRIC.equals(effectiveProviderType)) {
            this.log.info("Using MetricsStatisticsProvider");
            return this.createMetricsProvider(this.executor);
        }
        this.log.info("Using DefaultStatisticsProvider");
        return new DefaultStatisticsProvider(this.executor);
    }

    private StatisticsProvider createMetricsProvider(ScheduledExecutorService executor) {
        MetricStatisticsProvider metricProvider = new MetricStatisticsProvider(this.server, executor);
        Hashtable<String, String> dictionary = new Hashtable<String, String>();
        ((Dictionary)dictionary).put("name", "oak");
        this.regs.add(this.bundleContext.registerService(MetricRegistry.class, (Object)metricProvider.getRegistry(), dictionary));
        return metricProvider;
    }

    private boolean isMetricSupportPresent() {
        try {
            StatisticsProviderFactory.class.getClassLoader().loadClass(METRIC_PROVIDER_CLASS);
        }
        catch (Throwable e) {
            this.log.debug("Cannot load optional Metrics library support", e);
            return false;
        }
        return true;
    }

    @ObjectClassDefinition(name="Apache Jackrabbit Oak StatisticsProviderFactory", description="Creates a statistics providers used by Oak. By default if checks if Metrics (See http://metrics.dropwizard.io) library is present then that is used. Otherwise it fallbacks to default")
    static @interface Configuration {
        @AttributeDefinition(options={@Option(label="DEFAULT", value="DEFAULT"), @Option(label="METRIC", value="METRIC"), @Option(label="NONE", value="NONE")})
        public String providerType() default "AUTO";
    }
}

