/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.observation.filter;

import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.observation.filter.EventFilter;
import org.apache.jackrabbit.oak.plugins.tree.factories.TreeFactory;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

public final class ACFilter
implements EventFilter {
    private final NodeState before;
    private final NodeState after;
    private final String name;
    private final ACFilter parentFilter;
    private final PermissionProvider permissionProvider;
    private TreePermission treePermission;

    private ACFilter(@NotNull NodeState before, @NotNull NodeState after, @NotNull String name, @NotNull PermissionProvider permissionProvider, @NotNull ACFilter parentFilter) {
        this.before = Preconditions.checkNotNull(before);
        this.after = Preconditions.checkNotNull(after);
        this.name = Preconditions.checkNotNull(name);
        this.permissionProvider = Preconditions.checkNotNull(permissionProvider);
        this.parentFilter = Preconditions.checkNotNull(parentFilter);
    }

    public ACFilter(@NotNull NodeState before, @NotNull NodeState after, @NotNull PermissionProvider permissionProvider) {
        this.before = Preconditions.checkNotNull(before);
        this.after = Preconditions.checkNotNull(after);
        this.name = null;
        this.permissionProvider = Preconditions.checkNotNull(permissionProvider);
        this.parentFilter = null;
    }

    @Override
    public boolean includeAdd(PropertyState after) {
        return this.getTreePermission().canRead(after);
    }

    @Override
    public boolean includeChange(PropertyState before, PropertyState after) {
        return this.getTreePermission().canRead(after);
    }

    @Override
    public boolean includeDelete(PropertyState before) {
        return this.getTreePermission().canRead(before);
    }

    @Override
    public boolean includeAdd(String name, NodeState after) {
        return this.getTreePermission().getChildPermission(name, after).canRead();
    }

    @Override
    public boolean includeDelete(String name, NodeState before) {
        return this.getTreePermission().getChildPermission(name, before).canRead();
    }

    @Override
    public boolean includeMove(String sourcePath, String name, NodeState moved) {
        return this.getTreePermission().getChildPermission(name, moved).canRead();
    }

    @Override
    public boolean includeReorder(String destName, String name, NodeState reordered) {
        return this.getTreePermission().getChildPermission(name, reordered).canRead();
    }

    @Override
    public EventFilter create(String name, NodeState before, NodeState after) {
        return new ACFilter(before, after, name, this.permissionProvider, this);
    }

    private TreePermission getTreePermission() {
        TreePermission tp = this.treePermission;
        if (tp == null) {
            tp = this.parentFilter == null ? this.permissionProvider.getTreePermission(TreeFactory.createReadOnlyTree(this.after.exists() ? this.after : this.before), TreePermission.EMPTY) : this.parentFilter.getTreePermission().getChildPermission(this.name, this.after);
            this.treePermission = tp;
        }
        return tp;
    }
}

